PROGRAM MyComm;
 { MYCOMM.PAS - Bare-minimum serial communications program }
 { Michael A. Covington - 1992 - Turbo Pascal for Windows  }

USES   WinCrt, WinTypes, WinProcs, Strings;

CONST  portname: PChar = 'COM1';
       exitkey         = ^\;

CONST  c:            CHAR  = #0;

VAR    i, charsrecd: INTEGER;
       inputdata:    ARRAY[0..1023] OF CHAR;

       port:         INTEGER;      { Port identifier }
       dcb:          TDCB;         { Device control block }
       comstat:      TCOMSTAT;     { Comm status information }

BEGIN
  StrCopy(WindowTitle,'Communications Program');
  InitWinCrt;

  checkbreak := false;  { Treat Ctrl-C as ordinary character }

  port := OpenComm(portname,2000,10);
    { Serial port with 2000-byte input queue }
    {               and 10-byte output queue }
  IF port < 0 THEN BEGIN
    writeln('Could not open serial port');
    halt
  END;

  GetCommState(port,dcb);
  WITH dcb DO BEGIN
    Baudrate := 2400;
    ByteSize := 7;          { or 8 }
    Parity   := EvenParity; { or OddParity, NoParity, etc. }
    StopBits := OneStopBit; { NOT the number 1 }
  END;
  SetCommState(dcb);

  writeln('Ready. Press Ctrl-\ to exit.');
  writechar('_');         { ersatz cursor }

  REPEAT

    Yield;                { let other processes run }

    charsrecd := ReadComm(port,inputdata,sizeof(inputdata));

    IF charsrecd <= 0 THEN BEGIN
      i := GetCommError(port,comstat);
      IF i<>0 THEN write('<Error ',i,'> ')
        { Error codes are documented in doc/wintypes.pas }
    END
    ELSE BEGIN
      writechar(^H);      { erase ersatz cursor }
      FOR i:=0 TO charsrecd-1 DO writechar(inputdata[i]);
      writechar('_');     { create ersatz cursor }
    END;

    IF KeyPressed THEN BEGIN
      c := ReadKey;
      if (c<>exitkey) then WriteComm(port,@c,1)
    END

  UNTIL c = exitkey;

  writeln;
  writeln('Exiting...');
  CloseComm(port);
  DoneWinCrt              { close window }
END.
