UNIT MenuFix;
INTERFACE
USES Menus,Objects;

FUNCTION AddStatusDef(AMin,AMax : Word; ADefn : PStatusDef) :
                                                      PStatusDef;

FUNCTION AddStatusItem(ADefn : PStatusDef; AText : STRING;
                        AKeyCode, ACommand : Word) : PStatusItem;

FUNCTION NewMenuPtr : PMenu;

FUNCTION AddSubMenu(AMenu : PMenu; AName : TMenuStr;
                                    AHelpCtx : Word) : PMenuItem;

FUNCTION AddMenuItem(ASub : PMenuItem; AName,AParam : TMenuStr;
         AKeyCode, ACommand : Word; AHelpCtx : Word) : PMenuItem;

FUNCTION AddMenuSub(ASub : PMenuItem; AName : TMenuStr;
                                    AHelpCtx : Word) : PMenuItem;

FUNCTION AddMenuLine(ASub : PMenuItem) : PMenuItem;
{---------------------------------------------------------------}
IMPLEMENTATION

FUNCTION AddStatusDef(AMin,AMax : Word; ADefn : PStatusDef) :
                                                      PStatusDef;
{----------------------------------------------------------------
 Create a new status line definition record (TStatusDef) for the
 application's StatusLine.  If "ADefn" is not NIL, add this def-
 inition to the linked list.
----------------------------------------------------------------}
VAR P, AThis : PStatusDef;
BEGIN
  IF (MaxAvail >= SizeOf(TStatusDef)) THEN BEGIN { If heap free }
    P := New(PStatusDef);     { Allocate a TStatusDef record... }
    WITH P^ DO BEGIN                    { ...and initialize it. }
      Next  := NIL;                     { Pointer to NEXT Def'n }
      Min   := AMin;            { Low end of help context range }
      Max   := AMax;           { High end of help context range }
      Items := NIL;                { Pointer to 1st TStatusItem }
    END;
    IF (ADefn <> NIL) THEN BEGIN   { If NOT first definition... }
      AThis := ADefn;                  { ...proceed to list end }
      WHILE (AThis^.Next <> NIL) DO
        AThis := AThis^.Next;
      AThis^.Next := P;  { Previous "last" points to this def'n }
    END;
    AddStatusDef := P;                     { Return the pointer }
  END
  ELSE                                          { No heap space }
    AddStatusDef := NIL;
END; {--------------------------------- FUNCTION AddStatusDef() }

FUNCTION AddStatusItem(ADefn : PStatusDef; AText : STRING;
                        AKeyCode, ACommand : Word) : PStatusItem;
{----------------------------------------------------------------
 Create a new status item record (TStatusItem) for the TStatusDef
 record specified through "ADefn."
----------------------------------------------------------------}
VAR P, AThis : PStatusItem;
BEGIN
  IF ((ADefn <> NIL) AND (MaxAvail >= SizeOf(TStatusItem)))
  THEN BEGIN
    P := New(PStatusItem);   { Allocate a TStatusItem record... }
    WITH P^ DO BEGIN                    { ...and initialize it. }
      Next  := NIL;                      { Pointer to NEXT Item }
      Text  := NewStr(AText);            { Pointer to item text }
      KeyCode := AKeyCode;               { Code for key binding }
      Command := ACommand;             { Code for key's command }
    END;
    IF (ADefn^.Items = NIL) THEN             { If FIRST item... }
      ADefn^.ITems := P         { ...save pointer in TStatusDef }
    ELSE BEGIN
      AThis := ADefn^.Items;   { Otherwise, proceed to list end }
      WHILE (AThis^.Next <> NIL) DO
        AThis := AThis^.Next;
      AThis^.Next := P;  { Previous "last" points to this def'n }
    END;
    AddStatusItem := P;                    { Return the pointer }
  END
  ELSE                         { No TStatusDef or no heap space }
    AddStatusItem := NIL;
END; {-------------------------------- FUNCTION AddStatusItem() }

FUNCTION NewMenuPtr : PMenu;
{----------------------------------------------------------------
 Create a TMenu record, initialize it, and return its pointer.
----------------------------------------------------------------}
VAR P : PMenu;
BEGIN
  IF (MaxAvail >= SizeOf(TMenu)) THEN BEGIN
    P := New(PMenu);
    WITH P^ DO BEGIN
      Items   := NIL;                { Pointer to FIRST submenu }
      Default := NIL;              { Pointer to default submenu }
    END;
    NewMenuPtr := P;
  END
  ELSE
    NewMenuPtr := NIL;
END; {------------------------------------- FUNCTION NewMenuPtr }

FUNCTION AddSubMenu(AMenu : PMenu; AName : TMenuStr;
                                    AHelpCtx : Word) : PMenuItem;
{----------------------------------------------------------------
 Create the TMenuItem and TMenu records for a submenu under the
 TMenu record given by "AMenu."
----------------------------------------------------------------}
VAR P, AThis : PMenuItem;
    P2 : PMenu;

BEGIN
  IF (AMenu = NIL) THEN BEGIN
    AddSubMenu := NIL;
    Exit;
  END;
  IF (MaxAvail >= (SizeOf(TMenuItem) + SizeOf(TMenu))) THEN BEGIN
    P2 := NewMenuPtr;
    P  := New(PMenuItem);
    WITH P^ DO BEGIN
      Next := NIL;                    { Pointer to next submenu }
      Name := NewStr(AName);                  { Pointer to name }
      Command := 0;                   { No command for submenus }
      Disabled := FALSE;                     { Normally enabled }
      KeyCode := 0;                                { No keycode }
      HelpCtx := AHelpCtx;                  { Help context code }
      SubMenu := P2;                  { Pointer to TMenu record }
    END;
    IF (AMenu^.Items = NIL) THEN           { If 1st submenu ... }
      AMenu^.Items := P { ... save pointer in base TMenu record }
    ELSE BEGIN                  { Otherwise, go to list end ... }
      AThis := AMenu^.Items;
      WHILE (AThis^.Next <> NIL) DO
        AThis := AThis^.Next;
      AThis^.Next := P;           { Extend list to this submenu }
    END;
    AddSubMenu := P;                       { Return the pointer }
  END
  ELSE
    AddSubMenu := NIL;
END; {----------------------------------- FUNCTION AddSubMenu() }

FUNCTION AddMenuItem(ASub : PMenuItem; AName,AParam : TMenuStr;
         AKeyCode, ACommand : Word; AHelpCtx : Word) : PMenuItem;
{----------------------------------------------------------------
 Create the TMenuItem for a single menu item under the submenu
 given by "ASub."
----------------------------------------------------------------}
VAR P, AThis : PMenuItem;
BEGIN
  IF ((ASub <> NIL) AND (MaxAvail >= SizeOf(TMenuItem))) THEN BEGIN
    P  := New(PMenuItem);
    WITH P^ DO BEGIN
      Next := NIL;                       { Pointer to next item }
      Name := NewStr(AName);                  { Pointer to name }
      Param := NewStr(AParam);               { Pointer to param }
      Command := ACommand;              { Command code for item }
      Disabled := FALSE;                    { Initially enabled }
      KeyCode := AKeyCode;                { Accelerator Keycode }
      HelpCtx := AHelpCtx;                  { Help context code }
    END;
    IF (ASub^.SubMenu^.Items = NIL) THEN  { If 1st menu item... }
      ASub^.SubMenu^.Items := P    { ... save this item pointer }
    ELSE BEGIN                  { Otherwise, go to list end ... }
      AThis := ASub^.SubMenu^.Items;
      WHILE (AThis^.Next <> NIL) DO
        AThis := AThis^.Next;
      AThis^.Next := P;           { Extend list to this submenu }
    END;
    AddMenuItem := P;                      { Return the pointer }
  END
  ELSE
    AddMenuItem := NIL;
END; {---------------------------------- FUNCTION AddMenuItem() }

FUNCTION AddMenuSub(ASub : PMenuItem; AName : TMenuStr;
                                    AHelpCtx : Word) : PMenuItem;
{----------------------------------------------------------------
 Create the TMenuItem and TMenu records for a submenu under the
 SUBMENU record given by "ASub."
----------------------------------------------------------------}
VAR P, AThis : PMenuItem;
    P2 : PMenu;

BEGIN
  IF (ASub = NIL) THEN BEGIN
    AddMenuSub := NIL;
    Exit;
  END;
  IF (MaxAvail >= (SizeOf(TMenuItem) + SizeOf(TMenu))) THEN BEGIN
    P2 := NewMenuPtr;
    P  := New(PMenuItem);
    WITH P^ DO BEGIN
      Next := NIL;                    { Pointer to next submenu }
      Name := NewStr(AName);                  { Pointer to name }
      Command := 0;                   { No command for submenus }
      Disabled := FALSE;                     { Normally enabled }
      KeyCode := 0;                                { No keycode }
      HelpCtx := AHelpCtx;                  { Help context code }
      SubMenu := P2;                  { Pointer to TMenu record }
    END;
    IF (ASub^.SubMenu^.Items = NIL) THEN  { If 1st menu item... }
      ASub^.SubMenu^.Items := P    { ... save this item pointer }
    ELSE BEGIN                  { Otherwise, go to list end ... }
      AThis := ASub^.SubMenu^.Items;
      WHILE (AThis^.Next <> NIL) DO
        AThis := AThis^.Next;
      AThis^.Next := P;           { Extend list to this submenu }
    END;
    AddMenuSub := P;                       { Return the pointer }
  END
  ELSE
    AddMenuSub := NIL;
END; {----------------------------------- FUNCTION AddItemSub() }

FUNCTION AddMenuLine(ASub : PMenuItem) : PMenuItem;
{----------------------------------------------------------------
 Create the TMenuItem for a single menu line under the submenu
 given by "ASub."
----------------------------------------------------------------}
VAR P, AThis : PMenuItem;
BEGIN
  IF ((ASub <> NIL) AND (MaxAvail >= SizeOf(TMenuItem))) THEN BEGIN
    P  := New(PMenuItem);
    WITH P^ DO BEGIN
      Next := NIL;                       { Pointer to next item }
      Name := NIL;
      Param := NIL;
      Command := 0;
      Disabled := FALSE;
      KeyCode := 0;
      HelpCtx := 0;
    END;
    IF (ASub^.SubMenu^.Items = NIL) THEN  { If 1st menu item... }
      ASub^.SubMenu^.Items := P    { ... save this item pointer }
    ELSE BEGIN                  { Otherwise, go to list end ... }
      AThis := ASub^.SubMenu^.Items;
      WHILE (AThis^.Next <> NIL) DO
        AThis := AThis^.Next;
      AThis^.Next := P;           { Extend list to this submenu }
    END;
    AddMenuLine := P;                      { Return the pointer }
  END
  ELSE
    AddMenuLine := NIL;
END; {------------------------------------ FUNCTION AddMenuLine }


END.