{ LISTING 1 : HUGEMODL.PAS                          (208 Lines) }
UNIT HugeModl;   {Copyright (c) 1992, Jon Shemitz/Midnight Beach}
{NOTE: If "Huge_InLine" is defined, the Pointer math routines
       become (relatively large) inline macros.}
{$C Moveable Discardable PreLoad}
INTERFACE

TYPE  DGig = 0..$7FFFFFFF;   {Unsigned longs (Please, Borland!)}
CONST SegSize = $10000;                                    {64K}
VAR   SegInc : word;        {This magic selector-tiling value...
                                     ...is set by the init code}

PROCEDURE GetHuge(VAR Result; Size: DGig);
PROCEDURE FreeHuge(Huge: Pointer);
PROCEDURE GetMem(VAR Ptr; Size: DGig);
PROCEDURE FreeMem(Ptr: Pointer; Size: DGig);
PROCEDURE Move(VAR Src, Dst; Bytes: DGig);

FUNCTION OfsOf(Base: Pointer; Ofs: DGig): Pointer;
{$IFDEF Huge_InLine}         (* NOTE: Alternative to functions *)
INLINE($5E /             {pop  si}
       $5F /             {pop  di}
       $58 /             {pop  ax}
       $5A /             {pop  dx}
       $31/$C9 /         {xor  cx,cx}
       $01/$F0 /         {add  ax,si}
       $11/$F9 /         {adc  cx,di}
       $74/$06 /         {jz   @Tiled}
{@Tile:}
       $03/$16/SegInc /  {add  dx,[SegInc]}
       $E2/$FA           {loop @Tile}      );
{@Tiled}
{$ENDIF}

FUNCTION PreInc(VAR Pntr; Incr: DGig): Pointer;
{$IFDEF Huge_InLine}         (* NOTE: Alternative to functions *)
INLINE($5B /             {pop  bx}
       $5E /      		   {pop  si}
       $5F /             {pop  di}
       $07 /             {pop  es}
       $26/$8B/$05 /     {mov  ax,[es:di]}
       $26/$8B/$55/$02 / {mov  dx,[es:di+2]}
       $31/$C9 /         {xor  cx,cx}
       $01/$D8 /         {add  ax,bx}
       $11/$F1 /         {adc  cx,si}
       $74/$0A /         {jz   @Offset}
{@Loop:}
       $03/$16/SegInc /  {add  dx,[SegInc]}
       $E2/$FA /         {loop @Loop}
       $26/$89/$55/$02/  {mov  [es:di+2],dx}
{@Offset:}
       $26/$89/$05       {mov  [es:di],ax}  );
{$ENDIF}

FUNCTION PostInc(VAR Pntr; Incr: DGig): Pointer;
{$IFDEF Huge_InLine}         (* NOTE: Alternative to functions *)
INLINE($5B /             {pop  bx}
       $5E /             {pop  si}
       $5F /             {pop  di}
       $07 /             {pop  es}
       $26/$8B/$05 /     {mov  ax,[es:di]}
       $26/$8B/$55/$02 / {mov  dx,[es:di+2]}
       $31/$C9 /         {xor  cx,cx}
       $01/$D8 /         {add  ax,bx}
       $11/$F1 /         {adc  cx,si}
       $74/$0A /         {jz   @Offset}
{@Loop:}
       $03/$16/ SegInc / {add  dx,[SegInc]}
       $E2/$FA /         {loop @Loop}
       $26/$87/$55/$02 / {xchg [es:di+2],dx}
 {@Offset:}
       $26/$87/$05       {xchg [es:di],ax}  );
{$ENDIF}

{===============================================================}
IMPLEMENTATION
USES WinTypes, WinProcs;

TYPE DWord   = RECORD
       Lo, Hi: word;
     END;
     Segment = 0..SegSize {bytes} ;


PROCEDURE GetHuge(VAR Result; Size: DGig);
VAR Handle : tHandle;
    Ptr    : Pointer ABSOLUTE Result;
BEGIN
  Handle := GlobalAlloc(gmem_Fixed, Size);
  IF (Handle = 0) THEN Ptr := NIL
  ELSE Ptr := GlobalLock(Handle);
END;

PROCEDURE FreeHuge(Huge: Pointer);
VAR Handle: LongInt;
BEGIN
  Handle := GlobalHandle(DWord(Huge).Hi);
  IF (DWord(Handle).Lo = 0) THEN RunError(204)
  ELSE GlobalFree(DWord(Handle).Lo);
END;

PROCEDURE GetMem(VAR Ptr; Size: DGig);
VAR P: Pointer ABSOLUTE Ptr;
BEGIN
  IF (Size <= $FFFF) THEN System.GetMem(P, Size)
  ELSE GetHuge(Ptr, Size);
END;

PROCEDURE FreeMem(Ptr: Pointer; Size: DGig);
BEGIN
  IF (Size <= $FFFF) THEN System.FreeMem(Ptr, Size)
  ELSE FreeHuge(Ptr);
END;

{$IFNDEF Huge_InLine}           (* NOTE: Alternative to macros *)
FUNCTION OfsOf(Base: Pointer; Ofs: DGig): Pointer; ASSEMBLER;
ASM
  mov  ax,[word ptr Base]
  mov  dx,[word ptr Base+2]                       {dx:ax := Base}
  xor  cx,cx
  add  ax,[word ptr Ofs]                             {new offset}
  adc  cx,[word ptr Ofs+2]            {# of 64K tiles to advance}
  jz  @Tiled
@Tile:
  add  dx,[SegInc]             {with very small CX's, this loop }
  loop @Tile                   {is probably faster than MUL even}
@Tiled:                        {on a 486, and saves a couple of }
END;                                          {mov instructions }

FUNCTION PreInc(VAR Pntr; Incr: DGig): Pointer;  ASSEMBLER;
ASM
  les  di,[Pntr]                         {pointer to the pointer}
  mov  ax,[es:di]
  mov  dx,[es:di+2]                                {dx:ax := Ptr}
  xor  cx,cx
  add  ax,[word ptr Incr]                            {new offset}
  adc  cx,[word ptr Incr+2]             {# of 64K tiles past Ptr}
  jz  @Offset
@AddTile:
  add  dx,[SegInc]
  loop @AddTile
  mov  [es:di+2],dx                     {write back new selector}
@Offset:
  mov   [es:di],ax                        {write back new offset}
END;

FUNCTION PostInc(VAR Pntr; Incr: DGig): Pointer;  ASSEMBLER;
ASM
  les  di,[Pntr]                         {pointer to the pointer}
  mov  ax,[es:di]
  mov  dx,[es:di+2]                                {dx,ax := Ptr}
  xor  cx,cx
  add  ax,[word ptr Incr]                            {new offset}
  adc  cx,[word ptr Incr+2]             {# of 64K tiles past Ptr}
  jz   @Offset
@AddTile:
  add  dx,[SegInc]
  loop @AddTile
  xchg [es:di+2],dx                 {write new selector, get old}
@Offset:
  xchg  [es:di],ax                    {write new offset, get old}
END;
{$ENDIF}

PROCEDURE WordMove(VAR Src, Dst; Bytes: Segment); NEAR; ASSEMBLER;
ASM
  mov  dx,ds
  cld
  lds  si,[Src]
  les  di,[Dst]
  mov  cx,[word ptr Bytes]
  rcr  [byte ptr Bytes+2],1                       {cf := low bit}
  rcr  cx,1                                {Cnvrt bytes to words}
  rep  movsw
  adc  cx,0
  rep  movsb                              {Move odd byte, if any}
  mov  ds,dx
END;

PROCEDURE Move(VAR Src, Dst; Bytes: DGig);
VAR Chunk  : Segment;
    MaxOfs : Word ;
    SrcPtr, DstPtr : Pointer;
BEGIN
  SrcPtr := @ Src;
  DstPtr := @ Dst;
  WHILE Bytes > 0 DO BEGIN
    ASM                       {MaxOfs := Max(Ofs(Src), Ofs(Dst) }
      mov  ax,[word ptr SrcPtr]
      cmp  ax,[word ptr DstPtr]
      jae  @Src
      mov  ax,[word ptr DstPtr]
    @Src:
      mov  [MaxOfs],ax
    END;
    Chunk := SegSize - MaxOfs;
    IF (Chunk > Bytes) THEN Chunk := Bytes;
    WordMove(PostInc(SrcPtr, Chunk)^,
             PostInc(DstPtr, Chunk)^, Chunk );
    Dec(Bytes, Chunk);
  END;
END;
{========================== Init code ==========================}
PROCEDURE __ahincr; FAR; EXTERNAL 'kernel';
BEGIN
  SegInc := Ofs(__ahincr);
END.
