{
  TESTHELP.PAS - Help demo program.
  Author:  Jim Mischel
  Last update:  10/20/92
}
Program TestHelp;

{$R TESTHELP.RES}

Uses  WinTypes, WinProcs, Strings, OWindows, ODialogs;

Const
  cm_FileNew = 101;
  cm_FileOpen = 102;
  cm_FileSave = 103;
  cm_FileExit = 24340;
  cm_HelpIndex = 901;
  cm_HelpHelp = 902;
  { Help contexts }
  hc_Contents = 101;
  hc_FileNew = 201;
  hc_FileOpen = 202;
  hc_FileSave = 203;
  hc_FileExit = 204;
  hc_InClient = 300;
  hc_NotClient = 301;

{ Generate a fully-qualified pathname for the help file }
Function GetHelpFile (HFname : PChar) : PChar;
Var
  NameLen : Integer;
  FileName : array [0..128] of Char;
  I : Integer;
Begin
  { Construct HelpFileName from Module Name }
  NameLen := GetModuleFileName (HInstance, FileName, 129);
  I := NameLen - 1;
  while (I <> 0) and ((FileName[I] <> '\') and 
                      (FileName[I] <> ':')) Do
    Dec (I);
  Inc (I);
  StrCopy (@FileName[I], HFname);
  GetHelpFile := StrNew (FileName);
End;

{ 
  Display a message box indicating that the
  requested command is not implemented.
}
Procedure NotImp (h : HWnd);
Begin
  Messagebox (h, 'Command not Implemented', 
     'Help Example', mb_Ok);
End;

Type
  PHelpWin = ^THelpWin;
  THelpWin = Object (TWindow)
    Help : Boolean;
    HelpCursor : HCursor;
    HelpFileName : PChar;
    Constructor Init (AParent : PWindowsObject; ATitle : PChar);
    Destructor Done; Virtual;
    Procedure WMCommand (Var Msg : TMessage);
      Virtual wm_First + wm_Command;
    Procedure WMLButtonDown (Var Msg : TMessage);
      Virtual wm_First + wm_LButtonDown;
    Procedure WMKeyDown (Var Msg : TMessage);
      Virtual wm_First + wm_KeyDown;
    Procedure WMSetCursor (Var Msg : TMessage);
      Virtual wm_First + wm_SetCursor;
    Procedure WMInitMenu (Var Msg : TMessage);
      Virtual wm_First + wm_InitMenu;
    Procedure WMEnterIdle (Var Msg : TMessage);
      Virtual wm_First + wm_EnterIdle;
    Procedure WMDestroy (Var Msg : TMessage);
      Virtual wm_First + wm_Destroy;
    Procedure WMNCLButtonDown (Var Msg : TMessage);
      Virtual wm_First + wm_NCLButtonDown;
    Procedure CMHelpIndex (Var Msg : TMessage);
      Virtual cm_First + cm_HelpIndex;
    Procedure CMHelpHelp (Var Msg : TMessage);
      Virtual cm_First + cm_HelpHelp;
    Procedure CMFileNew (Var Msg : TMessage);
      Virtual cm_First + cm_FileNew;
    Procedure CMFileOpen (Var Msg : TMessage);
      Virtual cm_First + cm_FileOpen;
    Procedure CMFileSave (Var Msg : TMessage);
      Virtual cm_First + cm_FileSave;
  End;

Constructor THelpWin.Init;
Begin
  Inherited Init (AParent, ATitle);
  Attr.Menu := LoadMenu (HInstance, MakeIntResource (100));
  HelpFileName := GetHelpFile ('testhelp.hlp');
  HelpCursor := LoadCursor (HInstance, 'HELPCURSOR');
  Help := False;
End;

Destructor THelpWin.Done;
Begin
  StrDispose (HelpFileName);
  TWindow.Done;
End;

{
  Process command messages.
  If the user has pressed Shift+F1 to go into "Help Mode", then
  selecting a command will bring up the help topic for that
  command.
}
Procedure THelpWin.WMCommand;
Var
  HelpContextId : LongInt;
Begin
  If Help Then Begin
    Case Msg.wParam of
      cm_FileNew : HelpContextId := hc_FileNew;
      cm_FileOpen : HelpContextId := hc_FileOpen;
      cm_FileSave : HelpContextId := hc_FileSave;
      cm_FileExit : HelpContextId := hc_FileExit;
    Else
      HelpContextId := 0;
    End;

    If HelpContextId = 0 Then Begin
      MessageBox (HWindow, 'Help not available for this topic',
        'Help Example', mb_OK);
      DefWndProc (Msg);
    End
    Else Begin
      Help := False;
      WinHelp (HWindow, HelpFileName, 
               Help_Context, HelpContextId);
    End;
  End
  Else
    Inherited WMCommand (Msg);
End;

{
  Process left mouse button clicks.
  If in Help mode, then bring up the help topic that explains
  the general concepts of this window.
}
Procedure THelpWin.WMLButtonDown;
Begin
  If Help Then Begin
    Help := False;
    WinHelp (HWindow, HelpFileName, Help_Context, hc_InClient);
  End
  Else
    DefWndProc (Msg);
End;

{
  Process key down messages.
  If the user presses Shift+F1, then turn on the "Help mode" and
  set the help cursor.  Any other press of F1 will bring up
  the help contents topic.
  If in Help mode and the user presses Esc, then help mode
  is cancelled.
}
Procedure THelpWin.WMKeyDown;
Begin
  If Msg.wParam = vk_F1 Then
    If GetKeyState (vk_Shift) < 0 Then Begin
      Help := True;
      SetCursor (HelpCursor);
      DefWndProc (Msg);
    End
    Else
      WinHelp (HWindow, HelpFileName, Help_Index, 0)
  Else If (Msg.wParam = vk_Escape) and Help Then Begin
    Help := False;
    SetCursor (HCursor (GetClassWord (HWindow, gcw_HCursor)));
  End;
End;

{ Sets the Help Cursor if in Help mode }
Procedure THelpWin.WMSetCursor;
Begin
  If Help Then
    SetCursor (HelpCursor)
  Else
    DefWndProc (Msg);
End;

{ Sets the Help Cursor if in help mode }
Procedure THelpWin.WMInitMenu;
Begin
  if Help Then
    SetCursor (HelpCursor);
End;

{ Select Help during Idle }
Procedure THelpWin.WMEnterIdle;
Begin
  If ((Msg.wParam = msgf_Menu) and 
      ((GetKeyState(vk_F1) and $8000) <> 0)) Then Begin
    Help := True;
    PostMessage (HWindow, wm_KeyDown, vk_Return, 0);
  End;
End;

{ Shut Down the Help System and post Quit }
Procedure THelpWin.WMDestroy;
Begin
  WinHelp (HWindow, HelpFileName, help_Quit, 0);
  PostQuitMessage (0);
End;

{
  Handle Help outside Client Window.
  If in Help mode, a left mouse click on any portion of the
  window's non-client area will bring up a help topic that
  describes the non-client area.  The help topic file may
  be written so that a different topic is displayed for each
  of the different window parts (i.e. border, controls, menu,
  title bar).
}
Procedure THelpWin.WMNCLButtonDown;
Var
  HelpContextId : LongInt;
Begin
  If Help Then Begin
    Case Msg.wParam of
      htCaption, htReduce, htZoom, htSysMenu,
      htBottom, htBottomLeft, htBottomRight, htTop,
      htLeft, htRight, htTopLeft, htTopRight :
        HelpContextId := hc_NotClient;
    Else
      HelpContextId := 0;
    End;

    If HelpContextId <> 0 Then Begin
      Help := False;
      WinHelp (HWindow, HelpFileName, 
               Help_Context, HelpContextId);
    End
    Else
      DefWndProc (Msg);
  End
  Else
    DefWndProc (Msg);
End;

{ Brings up the Contents topic }
Procedure THelpWin.CMHelpIndex (Var Msg : TMessage);
Begin
  WinHelp (HWindow, HelpFileName, Help_Index, 0);
End;

{ Brings up the Contents topic of the WINHELP.HLP file }
Procedure THelpWin.CMHelpHelp (Var Msg: TMessage);
Begin
  WinHelp (HWindow, HelpFileName, Help_HelpOnHelp, 0);
End;

{ 
  The file functions are not implemented in this
  test program, so just display a message box.
}
Procedure THelpWin.CMFileNew (Var Msg : TMessage);
Begin
  NotImp (HWindow);
End;

Procedure THelpWin.CMFileOpen (Var Msg : TMessage);
Begin
  NotImp (HWindow);
End;

Procedure THelpWin.CMFileSave (Var Msg : TMessage);
Begin
  NotImp (HWindow);
End;

Type
  PHelpApp = ^THelpApp;
  THelpApp = Object (TApplication)
    Procedure InitMainWindow; Virtual;
    Procedure InitInstance; Virtual;
  End;

Procedure THelpApp.InitMainWindow;
Begin
  MainWindow := New (PHelpWin, Init (nil, 'Help Example'));
End;

Procedure THelpApp.InitInstance;
Begin
  TApplication.InitInstance;
  HAccTable := LoadAccelerators (HInstance, 'ACCEL');
End;

Var
  HelpApp : THelpApp;

Begin
  HelpApp.Init ('Help Example');
  HelpApp.Run;
  HelpApp.Done;
End.
