// PORTS.H--This code is public domain.

// Get prototypes for inp() and outp() functions.
#include <dos.h>

typedef unsigned char byte;
typedef unsigned short word;

// Output a byte value to a port.
inline void _IOPortOut(word addr, byte value) {
outp(addr, value);
}

// Input a byte value from a port.
inline byte _IOPortIn(word addr, byte) {
return (inp(addr));
}

// Output a word value to a port.
inline void _IOPortOut(word addr, word value) {
outpw(addr, value);
}

// Input a word value from a port.
inline word _IOPortIn(word addr, word) {
return (inpw(addr));
}

// I/O port.
template <class T> class IOPort
  {
  word _addr;   // Port address.

  public:

  // Constructors and destructor.
  IOPort() { }
  IOPort(word addr) : _addr(addr) { }
  IOPort(const IOPort & p) : _addr(p._addr) { }
  ~IOPort() { }

  // Set port address.
  void addr(word addr) {
  _addr = addr;
  }

  // Get port address.
  word addr() const {
  return (_addr);
  }

  // Read value from port.
  operator T() const {
  return (_IOPortIn(_addr, (T)0));
  }

  // Write value to port.
  IOPort & operator =(T value) {
  _IOPortOut(_addr, value);
  return (*this);
  }

  // Set bits at port.
  IOPort & operator |=(T value) {
  _IOPortOut(_addr, _IOPortIn(_addr, (T)0) | value);
  return (*this);
  }

  // Mask bits at port.
  IOPort & operator &=(T value) {
  _IOPortOut(_addr, _IOPortIn(_addr, (T)0) & value);
  return (*this);
  }

  // Toggle bits at port.
  IOPort & operator ^=(T value) {
  _IOPortOut(_addr, _IOPortIn(_addr, (T)0) ^ value);
  return (*this);
  }

  // Copy value from one port to another.
  IOPort & operator =(const IOPort & p) {
  _IOPortOut(_addr, _IOPortIn(p._addr, (T)0));
  return (*this);
  }

  // Treat port as base of an array of ports.
  IOPort operator [](int index) const {
  return (_addr + index);
  }
  };

typedef IOPort<byte> bytePort;
typedef IOPort<word> wordPort;
