//=============================================================
//  Windows Application Template
//      ctlbar.c
//      v1.00   27-Jan-1992
//
//      An example of creating control bars.
//
//      Written by Scott Robert Ladd.
//=============================================================

#include "windows.h"
#include "ctlbar.h"

// macro to generate a simple message box
#define ShowMsg(str) MessageBox(GetFocus(),(str),\
                     "Control Bar Example Program",MB_OK)

//-----------------------------
// external function prototypes
//-----------------------------

int PASCAL WinMain
    (
    HANDLE instance,
    HANDLE prevInstance,
    LPSTR  commandLine,
    int    commandShow
    );

static BOOL InitApplication
    (
    HANDLE instance
    );

static BOOL InitInstance
    (
    HANDLE instance,
    int    commandShow
    );

long FAR PASCAL _export MainWndProc
    (
    HWND  thisWindow,
    WORD  message,
    WORD  wordParam,
    DWORD longParam
    );

long FAR PASCAL _export DesktopWndProc
    (
    HWND  thisWindow,
    WORD  message,
    WORD  wordParam,
    DWORD longParam
    );

long FAR PASCAL _export CtlBarWndProc
    (
    HWND  thisWindow,
    WORD  message,
    WORD  wordParam,
    DWORD longParam
    );

//------------------------
// global data
//------------------------

HANDLE ThisInstance;

HWND   MainWnd;
HWND   CtlBarWnd;
HWND   ButtonWnd;
HWND   DesktopWnd;

WORD   CtlBarHeight;

#ifdef __TURBOC__
    #pragma argsused
#endif

//-------------------------------------------
//  WinMain -- program start and message loop
//-------------------------------------------

int PASCAL WinMain
    (
    HANDLE instance,
    HANDLE prevInstance,
    LPSTR  commandLine,
    int    commandShow
    )
    {
    MSG msg;

    if (prevInstance)
        {
        ShowMsg("CtlBar is already running!");
        return 0;
        }

    if (!InitApplication(instance))
        return 0;

    if (!InitInstance(instance, commandShow))
        return 0;

    while (GetMessage(&msg, NULL, NULL, NULL))
        {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }

    return msg.wParam;
    }

//--------------------------
// initialize an application
//--------------------------

static BOOL InitApplication
    (
    HANDLE instance
    )
    {
    WNDCLASS wc;

    // register class for main window
    wc.style         = 0;
    wc.lpfnWndProc   = (long (FAR PASCAL *)())MainWndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = instance;
    wc.hIcon         = LoadIcon(instance,"CtlBarIcon");;
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(BLACK_BRUSH);
    wc.lpszMenuName  = "MainMenu";
    wc.lpszClassName = "MainWindowClass";

    if (!RegisterClass(&wc))
        return FALSE;

    // register class for desktop window
    wc.style         = 0;
    wc.lpfnWndProc   = (long (FAR PASCAL *)())DesktopWndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = instance;
    wc.hIcon         = NULL;
    wc.hCursor       = LoadCursor(NULL,IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = "DesktopClass";

    if (!RegisterClass(&wc))
        return FALSE;

    // register class for control bar
    wc.style         = 0;
    wc.lpfnWndProc   = (long (FAR PASCAL *)())CtlBarWndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = instance;
    wc.hIcon         = NULL;
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(LTGRAY_BRUSH);
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = "CtlBarClass";

    return RegisterClass(&wc);
    }

//-----------------------
// initialize an instance
//-----------------------

static BOOL InitInstance
    (
    HANDLE instance,
    int commandShow
    )
    {
    int        i;
    RECT       r;
    HDC        dc;
    TEXTMETRIC tm;

    // save the instance handle
    ThisInstance = instance;

    // create the main window
    MainWnd = CreateWindow("MainWindowClass",
                           "Control Bar Example",
                           WS_OVERLAPPEDWINDOW,
                           CW_USEDEFAULT,
                           CW_USEDEFAULT,
                           CW_USEDEFAULT,
                           CW_USEDEFAULT,
                           NULL,
                           NULL,
                           instance,
                           0);

    if (!MainWnd)
        return FALSE;

    ShowWindow(MainWnd, commandShow);
    UpdateWindow(MainWnd);

    // get device context for main window
    dc = GetDC(MainWnd);

    if (dc == NULL)
        return FALSE;

    // get text metrics
    if (GetTextMetrics(dc,&tm) == FALSE)
        return FALSE;

    // release device context
    ReleaseDC(MainWnd,dc);

    // get size of Main window
    GetClientRect(MainWnd,&r);

    // calculate dimensions and positions of various controls
    CtlBarHeight = tm.tmHeight + 2 *
                   (2 + GetSystemMetrics(SM_CYDLGFRAME));

    // create control bar in upper left corner of Main window
    // extending across the width of Main window.
    CtlBarWnd = CreateWindow("CtlBarClass",
                             NULL,
                             WS_CHILD
                                 | WS_VISIBLE
                                 | WS_CLIPSIBLINGS
                                 | WS_BORDER,
                             0, 0,
                             r.right, CtlBarHeight,
                             MainWnd,
                             NULL,
                             ThisInstance,
                             NULL);

    if (!CtlBarWnd)
        return FALSE;

    ShowWindow(CtlBarWnd, commandShow);
    UpdateWindow(CtlBarWnd);

    // create button on control bar
    ButtonWnd = CreateWindow("button",
                             "Beep",
                             WS_CHILD | BS_PUSHBUTTON,
                             2, 2,
                             60, tm.tmHeight + 2 *
                                 tm.tmExternalLeading + 6,
                             CtlBarWnd,
                             IDC_BUTTON,
                             ThisInstance,
                             0L);

    if (!ButtonWnd)
        return FALSE;

    ShowWindow(ButtonWnd, commandShow);
    UpdateWindow(ButtonWnd);

    // create desktop window, in the area of MainWnd's client
    // that is not used by CtlBarWnd.
    DesktopWnd = CreateWindow("DesktopClass",
                              NULL,
                              WS_CHILD
                                  | WS_VISIBLE
                                  | WS_CLIPSIBLINGS
                                  | WS_CLIPCHILDREN,
                              0, CtlBarHeight,
                              r.right, r.bottom - CtlBarHeight,
                              MainWnd,
                              NULL,
                              ThisInstance,
                              NULL);

    if (DesktopWnd == NULL)
        return FALSE;

    ShowWindow(DesktopWnd,SW_SHOW);
    UpdateWindow(DesktopWnd);

    return TRUE;
    }

long FAR PASCAL _export MainWndProc
    (
    HWND  thisWindow,
    WORD  message,
    WORD  wordParam,
    DWORD longParam
    )
    {
    switch (message)
      {
      case WM_SIZE:
        // when main window changes size, change child sizes
        MoveWindow(CtlBarWnd,0,0,LOWORD(longParam),
                   CtlBarHeight,TRUE);

        MoveWindow(DesktopWnd,0,CtlBarHeight,LOWORD(longParam),
                   HIWORD(longParam) - CtlBarHeight,TRUE);

        return DefWindowProc(thisWindow, message,
                             wordParam, longParam);

      case WM_COMMAND:
        switch (wordParam)
          {
          case IDM_EXIT:
            PostQuitMessage(0);
            break;

          default:
            return DefWindowProc(thisWindow, message,
                                 wordParam, longParam);
          }

        break;

      case WM_DESTROY:
        PostQuitMessage(0);

      default:
        return
          DefWindowProc(thisWindow, message, wordParam, longParam);
      }

    return 0L;
    }

long FAR PASCAL _export DesktopWndProc
    (
    HWND  thisWindow,
    WORD  message,
    WORD  wordParam,
    DWORD longParam
    )
    {
    // this function would be complex in a "real" application
    return DefWindowProc(thisWindow, message, wordParam, longParam);
    }

long FAR PASCAL _export CtlBarWndProc
  (
  HWND  thisWindow,
  WORD  message,
 WORD  wordParam,
  DWORD longParam
  )
  {
  if (message == WM_COMMAND)
      {
      // when the button is clicked, beep!
      if ((wordParam == IDC_BUTTON)
      && (HIWORD(longParam) == BN_CLICKED))
          MessageBeep(0);
      }
  else
    return DefWindowProc(thisWindow, message, wordParam, longParam);
  }
