/* RTCBIOS.H
 * Definitions for RTCBIOS.C */

/* Time structure used by GetRTCtime, SetRTCtime and SetAlarm */
struct RTCTIME {
    unsigned int Hour;
    unsigned int Min;
    unsigned int Sec;
    unsigned int Daylight;
};

/* Date structure used by GetRTCDate and SetRTCDate */
struct RTCDATE {
    unsigned int Century;
    unsigned int Year;
    unsigned int Month;
    unsigned int Day;
};
int SetWait (long ms, unsigned char far *Flag);
void CancelWait (void);
int Wait (long ms);
int GetRTCtime (struct RTCTIME far *Time);
int SetRTCtime (struct RTCTIME *Time);
int GetRTCdate (struct RTCDATE far *Date);
int SetRTCdate (struct RTCDATE *Date);
int SetAlarm (struct RTCTIME *Time,
		 void interrupt (*AlarmInt)());
void ClearAlarm (void);
