PROGRAM Mousey;   { Jim Kyle, 03-19-89; For Turbo Pascal 5.0    }
{$M 2048,0,0}                { Limits Stack to 2K and Heap to 0 }
USES Dos;

VAR
  CmdPath   : ComStr;
  CmdToDo   : ComStr;
  I         : Integer;
  Regs      : Registers;
  Saved     : Boolean;
  SavMse    : ARRAY[0..999] OF Byte;    { Need not be this big! }

PROCEDURE MseInt( N : Integer);
BEGIN
  Regs.es := Seg(SavMse);
  Regs.dx := Ofs(SavMse);
  Regs.ax := N;
  Intr($33,Regs);
END;

PROCEDURE SetMouse;              { Save the current mouse state }
BEGIN
  Regs.ax := $3533;
  MsDos( Regs );
  Saved := (Regs.es OR Regs.bx) <> 0;
  IF Saved THEN BEGIN
    MseInt(22);
    WriteLn('Mouse Saved...');
  END;
END;

PROCEDURE ResetMouse;           { Restore previous mouse state }
BEGIN
  IF Saved THEN BEGIN
    MseInt(23);
    WriteLn('Mouse restored...');
  END;
END;
{======================== Main Program =========================}
BEGIN
  IF ParamCount < 1 THEN BEGIN  { If no args, give help summary }
    WriteLn( '  Usage: MOUSEY Command Parms' );
    WriteLn( '  - Command is anything DOS will recognize');
    WriteLn( '  - Parms can be whatever the command will accept');
    Halt(255);
  END;
  SetMouse;            { Else install mouse service, saving old }
  CmdToDo := '/C ';         { Build up command line from input }
  FOR I := 1 TO ParamCount DO
    CmdToDo := Concat(CmdToDo, ParamStr(i), ' ');
  CmdPath := GetEnv( 'COMSPEC' );
  SwapVectors;                           { Put back DOS vectors }
  Exec(CmdPath, CmdToDo);              { Launch the application }
  SwapVectors;                             { Restore TP vectors }
  ResetMouse;                    { Restore original mouse setup }
  Halt(DosExitCode);       { Return the application's exit code }
END.
