{  SYSREQ.PAS - Unit to allow programs to 'see' System Request key }
{  Copyright 1990 S/Wizardry, Ltd.                                 }
UNIT SysReq;

INTERFACE

CONST
   SysReqKey = $4500;


IMPLEMENTATION

USES
   OpCRT, OpInline, DOS;

VAR
   SaveInt15 : POINTER;
   SaveExitProc : POINTER;

CONST
   Int15Installed : BOOLEAN = FALSE;


PROCEDURE Int15(AX, BX, CX, DX, SI, DI, DS, ES, BP : WORD); INTERRUPT;
BEGIN
   IF AX = $8500 THEN
      StuffKey(SysReqKey)
   ELSE
      JumpToOldISR(SaveInt15);
END;

PROCEDURE InstallInt15;
BEGIN
   IF NOT Int15Installed THEN BEGIN
      GetIntVec($15, SaveInt15);
      SetIntVec($15, @Int15);
      Int15Installed := TRUE;
   END;
END;

PROCEDURE RestoreInt15;
BEGIN
   IF Int15Installed THEN BEGIN
      SetIntVec($15,SaveInt15);
      Int15Installed := FALSE;
   END;
END;

{$F+}
PROCEDURE NewExitProc;
BEGIN
   ExitProc := SaveExitProc;
   RestoreInt15;
END;
{$F-}

BEGIN {UNIT initialization}
   InstallInt15;
   SaveExitProc := ExitProc;
   ExitProc := @NewExitProc;
END.
