ideal
proc setfile   far

; DX:AX contains the size to set to.  BX contains the file 
; handle to set. All registers are returned unchanged--only
; the flags are modified. If an error occurs, the carry flag 
; will be set.  Possible errors are "invalid handle" and
; "insuffficient disk space".  The file size will be unchanged
; on error. If successful, file pointer is positioned at the 
; end of the file (EOF=TRUE).

     push cx
     push dx
     push ax
     mov  cx,dx
     mov  dx,ax
     mov  ax,04200h
     int  021h      ;Move to the correct position
     jc   @@err1
     mov  ah,040h
     xor  cx,cx
     int  021h      ;Set the file size
     jc   @@err1
     mov  ax,04202h
     mov  dx,cx
     int  021h      ;Get the actually size to see 
                    ;if everything was written    
     jc   @@err1
     pop  cx
     cmp  ax,cx     ;Check the low  word
     je   @@cont
     mov  ax,cx
     stc            ;Set error condition
     jmp  @@err2
@@cont:
     pop  cx
     or   dx,cx     ;Check the high word (and clear 
                    ;the carry flag)    
jz   @@done
     mov  dx,cx
     stc            ;Set the error condition
     db   0b9h      ;Jump to @@done without emptying prefetch
                    ;(trashes CX) 
@@err1:
     pop  ax
@@err2:
     pop  dx
@@done:
     pop  cx
     retf
endp set_file

