/****************************************************************************

    FUNCTION: Panic(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "Panic" dialog box

    MESSAGES:

        WM_INITDIALOG - initialize dialog box
        WM_COMMAND    - Input received

    COMMENTS:

        No initialization is needed for this particular dialog box, but TRUE
        must be returned to Windows.

        Wait for user to click on "Panic" button. When this happens, add
        the word "again" to the empty static text control in the dialog box.
        When a second click is received, close the dialog.

****************************************************************************/

BOOL FAR PASCAL Panic(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box */
unsigned message;                         /* type of message                 */
WORD wParam;                              /* message-specific information    */
LONG lParam;
{
static BOOL bHitOnce;                     /* Has panic button been hit once? */
static char far szAgain[] = "again!";     /* Text to add to dialog box */
    switch (message) {
        case WM_INITDIALOG:                /* message: initialize dialog box */
            bHitOnce = FALSE;              /* Panic button not hit yet */
            return (TRUE);
        case WM_COMMAND:                   /* message: received a command */
            switch (wParam) {                 /* Which command? */
                case IDOK:                    /* Panic button hit */
                    if (!bHitOnce) {          /* If first push, change msg */
                        bHitOnce = TRUE;
                        SetDlgItemText(hDlg,IDC_AGAIN,szAgain);
                        MessageBeep(0);
                        return (TRUE);
                    }                         /* Otherwise, fall through */
                case IDCANCEL:
                    EndDialog(hDlg, TRUE);    /* Exits the dialog box        */
                    return (TRUE);
            }
            break;
    }
    return (FALSE);                           /* Didn't process a message    */
}
