enum	_kindOfBook { SF, Fiction, Poetry };

//---------------------------------------------------------------
class Book	{
	private:
	   static int AllBooks,         // Total number of books
			 SFBooks,	// Number of SF books
			 FictionBooks,  // Number of Fiction books
			 PoetryBooks;	// Number of Poetry books

	   enum _kindOfBook Kind;     // what kind of book this is

	public:
		Book(enum _kindOfBook);
		~Book(void);
		int numberOfBooks(void);
		int numberOfSFBooks(void);
		int numberOfFictionBooks(void);
		int numberOfPoetryBooks(void);
		int kind(void);	    // what kind of book is this?
};

//--------Book Kind---------
// Return what kind of book this is

int Book::kind(void)
{
  return Kind;
}

//-------Book Constructor
// Build a new book of a particular kind.  Increment the
// appropriate counters

Book::Book(enum _kindOfBook kind)
{
	switch(kind)	{
		case SF:
			SFBooks ++;
			break;
		case Fiction:
			FictionBooks ++;
			break;
		case Poetry:
			PoetryBooks ++;
		default:
			// ERROR
			break;
	}
     Kind = kind;
	AllBooks ++;
}				

//--------Book Destructor------------
//Destroy an instance of book; decrement the appropriate counter

Book::~Book(void)
{
	switch(Kind)	{
		case SF:
			SFBooks --;
			break;
		case Fiction:
			FictionBooks --;
			break;
		case Poetry:
			PoetryBooks --;
			break;
		default:
			// ERROR
			break;
	}
	AllBooks --;
}

//---------Book numberOfBooks---------
// Return the total number of books in the system

int Book::numberOfBooks(void)
{
	return(AllBooks);
}

//--------Book numberOfSFBooks----------
int Book::numberOfSFBooks(void)
{
	return(SFBooks);
}

//--------Book numberOfFictionBooks----------
int Book::numberOfFictionBooks(void)
{
	return(FictionBooks);
}

//--------Book numberOfPoetryBooks------------
int Book::numberOfPoetryBooks(void)
{
	return(PoetryBooks);
}