{----------------------------------------------------------}
{ Park_Disk:  Safety routine to park  the hard disk heads  }
{ prior to executing critical code which could hang the    }
{ machine and force a re-boot.                             }
{----------------------------------------------------------}
PROCEDURE Park_Disk ;

CONST BIOS_Disk_Interrupt_No = $13;
VAR Disk_Ordinal : WORD;

BEGIN {Park_Disk}
  FOR Disk_Ordinal := $0080 TO $0083 DO BEGIN
    Regs.AH := 8; {Return drive parameters}
    Regs.DX := Disk_Ordinal;
    Intr( BIOS_Disk_Interrupt_No, Regs );

{----------------------------------------------------------}
{ If Carry set, early version of BIOS which cannot execute }
{ Get Drive Parameters.                                    }
{----------------------------------------------------------}

    IF ( Regs.Flags AND FCarry ) = 0 THEN BEGIN
{----------------------------------------------------------}
{  Bump "last usable cylinder" by one to get it off last   }
{  cylinder.  Note:  This value is discontiguous in CX,    }
{  hence the peculiar code.                                }
{----------------------------------------------------------}
      INC( Regs.CH );
      IF Regs.CH = 0 THEN
        INC( Regs.CL, $40 );
      Regs.DX := Disk_Ordinal;
      Regs.AX := $0c01;  {Seek to cylinder}
      Intr( BIOS_Disk_Interrupt_No, Regs );
    END;
  END;
END {Park_Disk};

