#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <dos.h>
#include <malloc.h>

/*  info -- This program displays useful information
**          about a DOS disk.  Output is in the form of
**          a series of general information lines followed
**          by a table showing disk space usage.  Space
**          usage is shown in sectors, bytes and clusters.
**          The program should work with all disk formats
**          including "RAM" disks.
**
**          Usage: info [d:]
**          Where d: is an optional drive specification.
**          If d: is omitted, the default drive will be
**          assumed.
**          Compiler:    Microsoft C V3.0
**          Options :    /Zp    (pack arrays)
**                       /Ze    (support "far" extension)
**
**          External modules:
**                       absread()
**          Version 1.53     February 6, 1986
**          Glenn F. Roberts
*/

#define TRUE 1
#define ENTRY_LENGTH 32
#define MIN_VERSION 200        /* DOS 2.0 */
#define MAX_VERSION 310        /* DOS 3.1 */

#include "structs.h"
#include "dosfns.h"

main(argc, argv)
int argc;
char *argv[];
{
  int drive, ver;
  struct disk_table far *get_table(), far *tbl;
  struct boot *bpb;
  static struct ext_fcb fcb = {
    0xFF,0,0,0,0,0,VOL_ENTRY,0,
    '?','?','?','?','?','?','?','?','?','?','?',
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };

  ver = _osmajor*100+_osminor;
  if ((ver < MIN_VERSION) || (ver > MAX_VERSION))
    printf("Incorrect DOS version %d\n", ver);
  else if (!((--argc > 0) ?
      (parse(*++argv, &fcb.drive_id, 1) != 255) : TRUE))
    printf("Invalid drive specification\n");
  else {
    drive = (fcb.drive_id == 0) ? current_drv() : fcb.drive_id-1;
    tbl = get_table(drive);
    bpb = (struct boot *) malloc(tbl->sector_size);
    absread(drive, 1, 0, bpb);
    print_vol(drive, tbl);
    print_info(drive, bpb, tbl);
    print_tbl(drive, bpb, tbl);
  }
}
/*  scan_fat -- Analyze FAT.  Calculate the number
**              of clusters available, in use and
**              "locked out" by DOS.
*/
scan_fat(fat, is12, fatlast, avail, locked, used)
unsigned char *fat;
int is12;
unsigned fatlast, *avail, *locked, *used;
{
  int i, cn;

  *avail = *locked = *used = 0;
  for (i=2; i<=fatlast; i++) {
    cn = fatval(is12, i, fat);
    if (cn == LOCKED_OUT(is12)) (*locked)++;
    else if (cn == AVAILABLE)   (*avail)++;
    else                        (*used)++;
  }
}
/*  print_vol --   Print volume name and creation time/
**                 date if it exists, else print that
**                 volume has no label.
*/
print_vol(drive, tbl)
int drive;
struct disk_table far *tbl;
{
  struct extended_entry dir_entry;
  static struct ext_fcb vol_fcb = {
    0xFF,0,0,0,0,0,VOL_ENTRY,0,
    '?','?','?','?','?','?','?','?','?','?','?',
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
  int i;
  char cre_date[15], cre_time[15];

  printf("*** Information for Disk %c:", (drive + 'A'));
  if (tbl->designator != drive)
    printf(" (Assigned to drive %c:)", (tbl->designator + 'A'));
  printf(" ***\n\n  Volume ");
  setdta(&dir_entry);
  vol_fcb.drive_id = drive+1;
  if (search_first(&vol_fcb) != 255) {
    dtoa(dir_entry.body.create_date, cre_date);
    ttoa(dir_entry.body.create_time, cre_time);
    for (i=0; i<11; i++)
      putchar(dir_entry.body.filname[i]);
    printf(" created  %s  %s\n", cre_date, cre_time);
  }
  else
    printf("has no label\n");
}

/*  print_info -- Print general information.
*/
print_info(drive, bpb, tbl)
int drive;
struct boot *bpb;
struct disk_table far *tbl;
{
  int i, valid_boot;
  unsigned ncyl;

  /* If OEM name is printable then boot data are OK */
  for (i=0, valid_boot = TRUE; (i<8) && (valid_boot); i++)
    valid_boot = isprint(bpb->oem_name[i]);
  if (valid_boot) {
    ncyl = bpb->number_of_sectors/
        (bpb->sectors_per_track*bpb->number_of_heads);
    if ((bpb->number_of_sectors %
        (bpb->sectors_per_track*bpb->number_of_heads)) != 0)
      ncyl++;
    printf("  OEM name : ");
    for (i=0; i<8; i++)
      putchar(bpb->oem_name[i]);
    printf("     ");
  }
  printf("  Media descriptor (hex): %2x\n", tbl->media_type);
  if (valid_boot) {
    printf("  Volume has %d Surfaces, ", bpb->number_of_heads);
    printf("%d Tracks with ", ncyl);
    printf("%d Sectors/Track\n", bpb->sectors_per_track);
  }
  printf("  Sector size is %u bytes.", tbl->sector_size);
  printf("   FAT entries are %d bits\n",
      (tbl->last_cluster < MAX_12BIT) ? 12 : 16);
  printf("  Cluster size is %u bytes ",
      (tbl->cluster_size+1)*tbl->sector_size);
  printf("(%u sectors)\n\n", tbl->cluster_size+1);
}
/*  print_tbl -- Print table showing disk usage.
*/
print_tbl(drive, bpb, tbl)
int drive;
struct boot *bpb;
struct disk_table far *tbl;
{
  int i, nhidden, valid_boot, twelve_bit_fat;
  unsigned avail, locked, used, ntotal;
  unsigned char *fat;

  printf("Usage:                    ");
  printf("Sectors        Bytes     Clusters\n");
  for (i=0; i<61; i++)
    putchar('=');
  putchar('\n');

  ntotal = tbl->fat_start + tbl->fat_copies*tbl->fat_size +
      (tbl->max_entries*ENTRY_LENGTH/tbl->sector_size) +
      (tbl->last_cluster-1) * (tbl->cluster_size+1);

  /* If OEM name is printable then boot data are OK */
  for (i=0, valid_boot = TRUE; (i<8) && (valid_boot); i++)
    valid_boot = isprint(bpb->oem_name[i]);

  /* Print "hidden" information, if available */
  if(valid_boot) {
    nhidden = bpb->number_of_sectors - ntotal;
    ntotal = bpb->number_of_sectors;
    printf("Sectors Not Available        | %7d  | %12lu  |         |\n",
        nhidden, (long) nhidden * (long) tbl->sector_size);
  }
  /* Print stat's on DOS boot, FAT, and root dir. */
  printf("DOS Boot Area          | %7d  | %12lu  |         |\n",
      tbl->fat_start, (long) tbl->fat_start *
      (long) tbl->sector_size);
  printf("File Allocation Table  | %7d  | %12lu  |         |\n",
      (tbl->fat_copies)*(tbl->fat_size),
      (long) (tbl->fat_copies)*(tbl->fat_size) *
      (long) tbl->sector_size);
  printf("Root Directory         | %7d  | %12lu  |         |\n",
      (tbl->max_entries*ENTRY_LENGTH/tbl->sector_size),
      (long) (tbl->max_entries*ENTRY_LENGTH));

  /* Read and analyze the FAT */
  fat = (unsigned char *) malloc(tbl->fat_size*tbl->sector_size);
  absread(drive, tbl->fat_size, tbl->fat_start, fat);
  twelve_bit_fat = (tbl->last_cluster < MAX_12BIT);
  scan_fat(fat, twelve_bit_fat, tbl->last_cluster,
      &avail, &locked, &used);

  /* Print used, avail, locked out summary */
  printf("Files & Subdirectories | %7lu  | %12lu  | %6d  |\n",
      (long) used * (long) (tbl->cluster_size+1),
      (long) used * (long) (tbl->cluster_size+1) *
      (long) tbl->sector_size, used);
  printf("Locked Out             | %7u  | %12lu  | %6u  |\n",
      locked*(tbl->cluster_size+1),
      (long) locked * (long) (tbl->cluster_size+1) *
      (long) tbl->sector_size, locked);
  printf("Available              | %7lu  | %12lu  | %6u  |\n",
      (long) avail * (long) (tbl->cluster_size+1),
      (long) avail * (long) (tbl->cluster_size+1) *
      (long) tbl->sector_size, avail);

  /* Print totals and percent disk used information */
  for (i=0; i<61; i++)
    putchar('=');
  putchar('\n');
  printf("TOTAL                  | %7u  ", ntotal);
  printf("| %12lu  | %6u  |\n\n", (long) ntotal *
      (long) tbl->sector_size, (tbl->last_cluster)-1);
  printf("                The disk is %lu%% full\n",
      (used+locked)*100L/((tbl->last_cluster)-1));
}
