{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

{___________________________________________________________________

COLORTXT.PAS shows how to display character strings in all
combinations of foreground and background colors for EGA mode 10h,
640x350 pixels with 16 colors, then in normal and inverse video for
CGA mode 6, 640x200 pixels monochrome.  This method works for all
16-color EGA and VGA modes, and for CGA, EGA, VGA, and MCGA
monochrome modes.  For CGA mode 5, 320x200 pixels and 4 colors,
the concept remains the same, but you may have to make changes in
the Screen_Write routine.  VGA/MCGA mode 13h is another topic.

This version of COLORTXT is written for Turbo Pascal Release 4.0.

WARNING - To run as written, your PC must have either an EGA or
          a VGA video controller.

Copyright, 1987, Ben Myers
 ____________________________________________________________________
}

program colortxt;

Uses
  Crt, Dos, Turbo3;

const
  _Copyright : string[80] = 'Copyright 1987, Ben Myers';
  _VIDEO = $10;     { BIOS video interrupt }

var
  __BIOSReg : Registers;
  Previous_Mode : byte;
  TempCh : char;
  Display_String : string[80];
  i, k, Color_Index : integer;

{__________________________________________________________________

Set_Cursor_Position - Position the cursor on active display page zero.

X and Y are the row and column to position the cursor, relative to 1,
like Turbo GoToXY.  This procedure gives correct results for values
of X and Y within the range allowed by the current video BIOS mode.
 __________________________________________________________________
}

procedure Set_Cursor_Position ( X, Y : integer );

begin {Set_Cursor_Position}

  with __BIOSReg do
    begin
      Ah := $02;  { BIOS VIDEO subfunction 2, Set Cursor Position. }
      Bh := 0;                { Video display page zero }
      Dh := pred(Y);          { Make zero relative }
      Dl := pred(X) and $FF;
    end;
  Intr(_VIDEO,Dos.Registers(__BIOSReg));
{! 1. Parameter to Intr must be of the type Registers defined
 in DOS unit.}

end; {Set_Cursor_Position}

{___________________________________________________________________

Write_Byte_Attribute - Write copies of a character with a specified
                       attribute beginning at current cursor
                       position.

Data_Ch    The character to display
Count      The number of copies of Data_Ch to display
Fore, Back The foreground and background attributes for the character.
____________________________________________________________________
}

procedure Write_Byte_Attribute (Data_Ch : char;
                                Count, Fore, Back : integer);

begin {Write_Byte_Attribute}

  if (Count > 0) then
  with __BIOSReg do
    begin
      Ah  := $09;  { BIOS video subfunction 9, }
      { Write Attribute/Character at Current Cursor Position }
      Al  := Ord(Data_Ch);
      { Use video display page zero (Bh), and       }
      { force reasonable values for the attributes. }
      Bx  := ((Back and $0F) shl 4) or (Fore and $0F);
      Cx  := Count;
      Intr(_VIDEO,Dos.Registers(__BIOSReg));
    end;

end; {Write_Byte_Attribute}

{__________________________________________________________________

Screen_Write - Display a character string in color on a background
               color.

Phrase              The character string to be displayed
Text_Row, Text_Col  The starting row and column on which to display
FColor, BColor      The foreground and background colors to use

___________________________________________________________________
}

Procedure Screen_Write ( Phrase : String; Text_Row, Text_Col,
                         Fcolor, Bcolor: integer );
const
{ Font character consisting of all bits (a little square) }
    White_Space : char =  #$DB;

var
  j : integer;
  Phrase_Size : integer;
  Effective_Foreground_Color : byte;

begin  { Screen_Write }

  Phrase_Size := Length ( Phrase );
  if Bcolor <> Black then
    begin  { Display string against non-black background }
      { Paint Phrase_Size bytes of all bits in background color }
      Set_Cursor_Position ( Text_Col, Text_Row );
      Write_Byte_Attribute ( White_Space, Phrase_Size,
                             BColor, Black );
      Effective_Foreground_Color := FColor xor BColor;
      { For EGA, VGA, ATs, XT/286's, and PS/2's, the for statement
        could be replaced by a single call to video BIOS function
        $13, Write String.
      }
      for j := 1 to Phrase_Size do
      if Phrase [j] <> ' ' then
        begin
          Set_Cursor_Position ( Text_Col + pred(j), Text_Row );
          Write_Byte_Attribute ( Phrase [j], 1,
                                 Effective_Foreground_Color,
                                 8 {xor font bits on background});
        end;
     end   { Display string against non-black background }
   else
     begin  { Display string against black background }
       { Write the character string }
      for j := 1 to Phrase_Size do
      if Phrase [j] <> ' ' then
        begin
          Set_Cursor_Position ( Text_Col + pred(j), Text_Row );
          Write_Byte_Attribute ( Phrase [j], 1, FColor, Black );
        end;
     end;   { Display string against black background }

end;  { Screen_Write }

{__________________________________________________________________

Main Procedure
___________________________________________________________________
}
begin  {colortxt}

{ Display 16 colors 640x350 with EGA mode 10h }

  { BIOS VIDEO subfunction 0Fh, Read Current Video State. }
  __BIOSReg.Ah := $0F;
  Intr(_VIDEO,Dos.Registers(__BIOSReg));
  Previous_Mode := __BIOSReg.Al;
  { BIOS VIDEO subfunction 0, Set Mode. }
  __BIOSReg.Ax := $0010;
  Intr(_VIDEO,Dos.Registers(__BIOSReg));
  Display_String := ' Display all colors on line 1. ' + _Copyright;
  for i := 1 to length(Display_String) do
    begin
      { Don't display a black character }
      Color_Index := (i mod 15) + 1;
      Screen_Write ( Display_String[i], 1, i, Color_Index, Black );
    end;

  Display_String :=
    ' Display black on all background colors on line 2. ';
  for i := 1 to length(Display_String) do
    begin
      Color_Index := (i mod 15) + 1;
      Screen_Write ( Display_String[i], 2, i, Black, Color_Index );
    end;

  { Display all possible combinations }
  for k := 0 to 15 do
  for i := 0 to 15 do
    Screen_Write ( chr(ord('A')+k+i), 3+k, 1+i, i, k);

  Screen_Write (
   ' Display blue text on light cyan background on line 19. ',
                 19, 1, Blue, LightCyan );

  Screen_Write (
   ' Display yellow text on red background on line 20. ',
                 20, 1, Yellow, Red );

  Screen_Write (
   ' Display green text on yellow background on line 21. ',
                 21, 1, Green, Yellow );

  Screen_Write (
   ' Display yellow text on green background on line 22. ',
                 22, 1, Yellow, Green );

  Screen_Write (
   ' Display magenta text on light green background on line 23. ',
                 23, 1, Magenta, LightGreen );

  Screen_Write (
   ' Display light cyan text on blue background on line 24. ',
                 24, 1, LightCyan, Blue );

  Screen_Write (
 ' Display light blue text on light magenta background on line 25. ',
                 25, 1, LightBlue, LightMagenta );

  while not KeyPressed do;   { Wait for a keystroke }
  Read ( kbd, TempCh );         { Now get rid of it }

{ Display monochrome in CGA mode 6, 2 color 640x200  }

  { BIOS VIDEO subfunction 0, Set Mode. }
  __BIOSReg.Ax := $0006;
  Intr(_VIDEO,Dos.Registers(__BIOSReg));
  Screen_Write ( ' Display white on black on line 1. ',
                 1, 1, White, Black );

  Screen_Write ( ' Display black on white on line 3. ',
                 3, 1, Black, White );

  while not KeyPressed do;   { Wait for a keystroke }
  Read ( kbd, TempCh );         { Now get rid of it }

  { Leave the video mode as it was found when program started up }
  { However, active display page from that mode is not restored  }
  { BIOS VIDEO subfunction 0, Set Mode. }
  __BIOSReg.Ax := Previous_Mode;
  Intr(_VIDEO,Dos.Registers(__BIOSReg));

end.   {colortxt}
