;
; *** Listing 1 ***
;
;This program demonstrates the use of a set of routines which
; allow smooth, non-flickering, and non-destructive animation
; of objects on an IBM CGA or EGA graphics adapter. The program
; moves two helicopters and a balloon along programmed paths while
; internally animating the helicopter's roters, and orientation. You
; will see no undesirable fringe or overlap effects. Objects look
; as if they are in separate planes, and blank areas within an object
; such as the windows of the helicopters appear to be transparent.
;
; Link with Listings 2 and 3 with the command:
;	link listing1+listing2+listing3;
; to generate the executable sprite application file listing1.exe.
;
stack	segment para stack 'STACK'
	db	100 dup('Stack')
stack	ends
;
;Segment used to hold memory image of the background. It is used to
; restore the background before an object is moved.
;
background_segment  segment para 'DATA'
	db	4000h-((4000h-16000)/2) dup(0) ;last 192 bytes of the
background_segment  ends		       ; 16K video memory
;					       ; buffer are never used
cseg	segment para public 'cseg'
	assume	cs:cseg,ds:cseg,es:nothing
	extrn	byte_move_form_driver:near
	extrn	initialize:near,terminate:near,object_services:near
	extrn	vert_int_modulo_count:word
	extrn	put_objects_on_screen:far
;
;The flag below must be set properly before assembling this program
;
ega	equ  1 ;1 to assemble for use on an Enhanced Graphics Adapter
	       ;0 to assemble for use on a Color Graphics Adapter
cga	equ  (ega xor 1) ;the opposite status of ega
;
if ega
old_vert_count	dw	0	;holds number used to synchronize this
				; program to vertical interrupt
endif
;
screen_buffer_adr	equ	0b800h	    ;video mode 4's buffer
					    ; paragraph address
;
num_objects	equ	3	;this program will move three objects
;
;Below is a table which holds all the parameters which govern the
; movement of the three individual objects
x	    dw		     15,	       38,		  64
y	    dw		     90,	      180,		 164
xinc	    dw		      1,		0,		  -1
yinc	    dw		      0,	       -2,		   0
form	    dw	   bcptr_rt_tbl,      balloon_tbl,     rcptr_lft_tbl
formbase    dw	   bcptr_rt_tbl,      balloon_tbl,     rcptr_lft_tbl
formmax     dw bcptr_rt_tbl_max,  balloon_tbl_max, rcptr_lft_tbl_max
control     dw	  copter1_cinit,    balloon_cinit,     copter0_cinit
controlbase dw	copter1_control,  balloon_control,   copter0_control
controlmax  dw copter1_cntl_max, balloon_cntl_max,  copter0_cntl_max
delay	    dw		     01,	       01,		  01
delaybase   dw		     04,	       12,		  06
repeat	    dw		     47,	       91,		  55
;
;Below are lists of parameters which control the sequence of
; parameters used to define the movement patterns, and shapes.
; The parameters are listed in the following order:
;	xinc, yinc, form, formmax, delay, repeat
;

copter0_control dw -1,0
		dw rcptr_lft_tbl,rcptr_lft_tbl_max,06,54
copter0_cinit	dw 0,-2
		dw rcptr_lft_tbl,rcptr_lft_tbl_max,06,35
		dw 1,0
		dw rcptr_rt_tbl,rcptr_rt_tbl_max,06,4
		dw 1,2
		dw rcptr_rt_tbl,rcptr_rt_tbl_max,08,10
		dw 1,-2
		dw rcptr_rt_tbl,rcptr_rt_tbl_max,08,8
		dw 1,-2
		dw rcptr_rt_tbl,rcptr_rt_tbl_max,08,4
		dw 0,0
		dw rcptr_rt_tbl,rcptr_rt_tbl_max,10,10
		dw 1,-2
		dw rcptr_rt_tbl,rcptr_rt_tbl_max,08,4
		dw 1,-2
		dw rcptr_rt_tbl,rcptr_rt_tbl_max,08,9
		dw 1,2
		dw rcptr_rt_tbl,rcptr_rt_tbl_max,08,15
		dw 0,2
		dw rcptr_rt_tbl,rcptr_rt_tbl_max,10,35
copter0_cntl_max label	 byte
;
copter1_control dw 1,0
		dw bcptr_rt_tbl,bcptr_rt_tbl_max,04,46
copter1_cinit	dw -1,0
		dw bcptr_lft_tbl,bcptr_lft_tbl_max,04,46
		dw 1,0
		dw bcptr_rt_tbl,bcptr_rt_tbl_max,04,46
		dw -1,0
		dw bcptr_lft_tbl,bcptr_lft_tbl_max,04,46
		dw 0,0
		dw disappear_table,disappear_table_max,300,1
copter1_cntl_max label	 byte
;
balloon_control dw	0,-2
		dw	balloon_tbl,balloon_tbl_max,12,70
balloon_cinit	dw	0,2
		dw	balloon_tbl,balloon_tbl_max,12,70
balloon_cntl_max     label   byte
;
;Below are tables used to sequence the internal animation
;
rcptr_lft_tbl	   label   word
	dw	rcopter_left0
	dw	rcopter_left1
rcptr_lft_tbl_max  label   word
;
rcptr_rt_tbl	 label	 word
	dw	rcopter_right0
	dw	rcopter_right1
rcptr_rt_tbl_max label	 word
;
bcptr_lft_tbl	   label   word
	dw	bcopter_left0
	dw	bcopter_left1
bcptr_lft_tbl_max  label   word
;
bcptr_rt_tbl	 label	 word
	dw	bcopter_right0
	dw	bcopter_right1
bcptr_rt_tbl_max label	 word
;
balloon_tbl	      label   word
	dw	balloon
balloon_tbl_max       label   word
;
disappear_table 	  label   word
	dw	0ffffh
disappear_table_max	  label   word
;
;Below are the forms used to define the various images of the objects
; in a form suitable for an AND-OR type form driver. The format is:
;	byte 0 - height in lines (h)
;	byte 1 - width in bytes  (w)
;	followed by w X h (mask word, image word) pairs.
;
rcopter_left0	label	byte
	DB  00Eh, 006h, 000h, 000h, 0FFh, 0FFh, 000h, 00Fh, 0FFh, 0F0h
	DB  0FFh, 0FFh, 000h, 000h, 0FFh, 0F0h, 000h, 00Fh, 000h, 00Fh
	DB  0FFh, 0F0h, 0FFh, 0FFh, 000h, 000h, 0FFh, 0F0h, 000h, 00Fh
	DB  0FFh, 0FFh, 000h, 000h, 0FFh, 0FFh, 000h, 000h, 0FCh, 000h
	DB  002h, 0AAh, 003h, 0FFh, 0A8h, 000h, 0FFh, 0FFh, 000h, 000h
	DB  0F3h, 0FFh, 008h, 000h, 0C0h, 0FFh, 02Ah, 000h, 0FFh, 03Fh
	DB  000h, 0C0h, 0CFh, 0FFh, 020h, 000h, 0F0h, 03Fh, 00Ah, 080h
	DB  0FFh, 03Fh, 000h, 0C0h, 03Fh, 0FFh, 080h, 000h, 0F0h, 00Ch
	DB  00Ah, 0A2h, 03Fh, 03Fh, 080h, 0C0h, 03Fh, 0FFh, 080h, 000h
	DB  0F0h, 003h, 00Ah, 0A8h, 0C0h, 000h, 03Fh, 0FFh, 03Fh, 0FFh
	DB  080h, 000h, 0C0h, 00Ch, 02Ah, 0A2h, 03Fh, 03Fh, 080h, 0C0h
	DB  000h, 000h, 0AAh, 0AAh, 000h, 03Fh, 0AAh, 080h, 0FFh, 03Fh
	DB  000h, 0C0h, 0C0h, 000h, 02Ah, 0AAh, 000h, 0FFh, 0AAh, 000h
	DB  0FFh, 03Fh, 000h, 0C0h, 0F0h, 000h, 00Ah, 0AAh, 003h, 0FFh
	DB  0A8h, 000h, 0FFh, 0FFh, 000h, 000h, 03Ch, 0FFh, 0C3h, 000h
	DB  0CFh, 03Fh, 030h, 0C0h, 0FFh, 0FFh, 000h, 000h, 0C0h, 000h
	DB  03Fh, 0FFh, 000h, 0FFh, 0FFh, 000h, 0FFh, 0FFh, 000h, 000h
rcopter_left1	label	byte
	DB  00Eh, 006h, 000h, 000h, 0FFh, 0FFh, 000h, 00Fh, 0FFh, 0F0h
	DB  0FFh, 0FFh, 000h, 000h, 000h, 000h, 0FFh, 0FFh, 0FFh, 0FFh
	DB  000h, 000h, 0FFh, 0FFh, 000h, 000h, 0FFh, 0F0h, 000h, 00Fh
	DB  0FFh, 0FFh, 000h, 000h, 0FFh, 0FFh, 000h, 000h, 0FCh, 000h
	DB  002h, 0AAh, 003h, 0FFh, 0A8h, 000h, 0FFh, 0FFh, 000h, 000h
	DB  0F3h, 0FFh, 008h, 000h, 0C0h, 0FFh, 02Ah, 000h, 0FFh, 0FFh
	DB  000h, 000h, 0CFh, 0FFh, 020h, 000h, 0F0h, 03Fh, 00Ah, 080h
	DB  0F3h, 0F3h, 00Ch, 00Ch, 03Fh, 0FFh, 080h, 000h, 0F0h, 00Ch
	DB  00Ah, 0A2h, 03Ch, 0CFh, 083h, 030h, 03Fh, 0FFh, 080h, 000h
	DB  0F0h, 003h, 00Ah, 0A8h, 0C0h, 03Fh, 02Ah, 0C0h, 03Fh, 0FFh
	DB  080h, 000h, 0C0h, 00Ch, 02Ah, 0A2h, 03Ch, 0CFh, 083h, 030h
	DB  000h, 000h, 0AAh, 0AAh, 000h, 03Fh, 0AAh, 080h, 0F3h, 0F3h
	DB  00Ch, 00Ch, 0C0h, 000h, 02Ah, 0AAh, 000h, 0FFh, 0AAh, 000h
	DB  0FFh, 0FFh, 000h, 000h, 0F0h, 000h, 00Ah, 0AAh, 003h, 0FFh
	DB  0A8h, 000h, 0FFh, 0FFh, 000h, 000h, 03Ch, 0FFh, 0C3h, 000h
	DB  0CFh, 03Fh, 030h, 0C0h, 0FFh, 0FFh, 000h, 000h, 0C0h, 000h
	DB  03Fh, 0FFh, 000h, 0FFh, 0FFh, 000h, 0FFh, 0FFh, 000h, 000h
rcopter_right0	label	byte
	DB  00Eh, 006h, 0FFh, 0FFh, 000h, 000h, 0F0h, 000h, 00Fh, 0FFh
	DB  000h, 000h, 0FFh, 0FFh, 0FFh, 0FFh, 000h, 000h, 0FFh, 0FFh
	DB  000h, 000h, 000h, 000h, 0FFh, 0FFh, 0FFh, 0FFh, 000h, 000h
	DB  0FFh, 0FFh, 000h, 000h, 00Fh, 0FFh, 0F0h, 000h, 0FFh, 0FFh
	DB  000h, 000h, 0FFh, 0C0h, 000h, 02Ah, 000h, 03Fh, 0AAh, 080h
	DB  0FCh, 0FFh, 003h, 000h, 0FFh, 003h, 000h, 0A8h, 0FFh, 0CFh
	DB  000h, 020h, 0FCh, 0FFh, 003h, 000h, 0FCh, 00Fh, 002h, 0A0h
	DB  0FFh, 0F3h, 000h, 008h, 0FCh, 0FCh, 003h, 002h, 030h, 00Fh
	DB  08Ah, 0A0h, 0FFh, 0FCh, 000h, 002h, 000h, 003h, 0FFh, 0FCh
	DB  0C0h, 00Fh, 02Ah, 0A0h, 0FFh, 0FCh, 000h, 002h, 0FCh, 0FCh
	DB  003h, 002h, 030h, 003h, 08Ah, 0A8h, 0FFh, 0FCh, 000h, 002h
	DB  0FCh, 0FFh, 003h, 000h, 0FCh, 000h, 002h, 0AAh, 000h, 000h
	DB  0AAh, 0AAh, 0FCh, 0FFh, 003h, 000h, 0FFh, 000h, 000h, 0AAh
	DB  000h, 003h, 0AAh, 0A8h, 0FFh, 0FFh, 000h, 000h, 0FFh, 0C0h
	DB  000h, 02Ah, 000h, 00Fh, 0AAh, 0A0h, 0FFh, 0FFh, 000h, 000h
	DB  0FCh, 0F3h, 003h, 00Ch, 0FFh, 03Ch, 000h, 0C3h, 0FFh, 0FFh
	DB  000h, 000h, 0FFh, 000h, 000h, 0FFh, 000h, 003h, 0FFh, 0FCh
rcopter_right1	label	byte
	DB  00Eh, 006h, 0FFh, 0FFh, 000h, 000h, 0F0h, 000h, 00Fh, 0FFh
	DB  000h, 000h, 0FFh, 0FFh, 0FFh, 0FFh, 000h, 000h, 0F0h, 000h
	DB  00Fh, 0FFh, 00Fh, 0FFh, 0F0h, 000h, 0FFh, 0FFh, 000h, 000h
	DB  0FFh, 0FFh, 000h, 000h, 00Fh, 0FFh, 0F0h, 000h, 0FFh, 0FFh
	DB  000h, 000h, 0FFh, 0C0h, 000h, 02Ah, 000h, 03Fh, 0AAh, 080h
	DB  0FFh, 0FFh, 000h, 000h, 0FFh, 003h, 000h, 0A8h, 0FFh, 0CFh
	DB  000h, 020h, 0CFh, 0CFh, 030h, 030h, 0FCh, 00Fh, 002h, 0A0h
	DB  0FFh, 0F3h, 000h, 008h, 0F3h, 03Ch, 00Ch, 0C2h, 030h, 00Fh
	DB  08Ah, 0A0h, 0FFh, 0FCh, 000h, 002h, 0FCh, 003h, 003h, 0A8h
	DB  0C0h, 00Fh, 02Ah, 0A0h, 0FFh, 0FCh, 000h, 002h, 0F3h, 03Ch
	DB  00Ch, 0C2h, 030h, 003h, 08Ah, 0A8h, 0FFh, 0FCh, 000h, 002h
	DB  0CFh, 0CFh, 030h, 030h, 0FCh, 000h, 002h, 0AAh, 000h, 000h
	DB  0AAh, 0AAh, 0FFh, 0FFh, 000h, 000h, 0FFh, 000h, 000h, 0AAh
	DB  000h, 003h, 0AAh, 0A8h, 0FFh, 0FFh, 000h, 000h, 0FFh, 0C0h
	DB  000h, 02Ah, 000h, 00Fh, 0AAh, 0A0h, 0FFh, 0FFh, 000h, 000h
	DB  0FCh, 0F3h, 003h, 00Ch, 0FFh, 03Ch, 000h, 0C3h, 0FFh, 0FFh
	DB  000h, 000h, 0FFh, 000h, 000h, 0FFh, 000h, 003h, 0FFh, 0FCh
bcopter_left0	label	byte
	DB  00Eh, 006h, 000h, 000h, 0FFh, 0FFh, 000h, 00Fh, 0FFh, 0F0h
	DB  0FFh, 0FFh, 000h, 000h, 000h, 000h, 0FFh, 0FFh, 0FFh, 0FFh
	DB  000h, 000h, 0FFh, 0FFh, 000h, 000h, 0FFh, 0F0h, 000h, 00Fh
	DB  0FFh, 0FFh, 000h, 000h, 0FFh, 0FFh, 000h, 000h, 0FCh, 000h
	DB  001h, 055h, 003h, 0FFh, 054h, 000h, 0FFh, 0FFh, 000h, 000h
	DB  0F3h, 0FFh, 004h, 000h, 0C0h, 0FFh, 015h, 000h, 0FFh, 0FFh
	DB  000h, 000h, 0CFh, 0FFh, 010h, 000h, 0F0h, 03Fh, 005h, 040h
	DB  0F3h, 0F3h, 00Ch, 00Ch, 03Fh, 0FFh, 040h, 000h, 0F0h, 00Ch
	DB  005h, 051h, 03Ch, 0CFh, 043h, 030h, 03Fh, 0FFh, 040h, 000h
	DB  0F0h, 003h, 005h, 054h, 0C0h, 03Fh, 015h, 0C0h, 03Fh, 0FFh
	DB  040h, 000h, 0C0h, 00Ch, 015h, 051h, 03Ch, 0CFh, 043h, 030h
	DB  000h, 000h, 055h, 055h, 000h, 03Fh, 055h, 040h, 0F3h, 0F3h
	DB  00Ch, 00Ch, 0C0h, 000h, 015h, 055h, 000h, 0FFh, 055h, 000h
	DB  0FFh, 0FFh, 000h, 000h, 0F0h, 000h, 005h, 055h, 003h, 0FFh
	DB  054h, 000h, 0FFh, 0FFh, 000h, 000h, 03Ch, 0FFh, 0C3h, 000h
	DB  0CFh, 03Fh, 030h, 0C0h, 0FFh, 0FFh, 000h, 000h, 0C0h, 000h
	DB  03Fh, 0FFh, 000h, 0FFh, 0FFh, 000h, 0FFh, 0FFh, 000h, 000h
bcopter_left1	label	byte
	DB  00Eh, 006h, 000h, 000h, 0FFh, 0FFh, 000h, 00Fh, 0FFh, 0F0h
	DB  0FFh, 0FFh, 000h, 000h, 0FFh, 0F0h, 000h, 00Fh, 000h, 00Fh
	DB  0FFh, 0F0h, 0FFh, 0FFh, 000h, 000h, 0FFh, 0F0h, 000h, 00Fh
	DB  0FFh, 0FFh, 000h, 000h, 0FFh, 0FFh, 000h, 000h, 0FCh, 000h
	DB  001h, 055h, 003h, 0FFh, 054h, 000h, 0FFh, 0FFh, 000h, 000h
	DB  0F3h, 0FFh, 004h, 000h, 0C0h, 0FFh, 015h, 000h, 0FFh, 03Fh
	DB  000h, 0C0h, 0CFh, 0FFh, 010h, 000h, 0F0h, 03Fh, 005h, 040h
	DB  0FFh, 03Fh, 000h, 0C0h, 03Fh, 0FFh, 040h, 000h, 0F0h, 00Ch
	DB  005h, 051h, 03Fh, 03Fh, 040h, 0C0h, 03Fh, 0FFh, 040h, 000h
	DB  0F0h, 003h, 005h, 054h, 0C0h, 000h, 03Fh, 0FFh, 03Fh, 0FFh
	DB  040h, 000h, 0C0h, 00Ch, 015h, 051h, 03Fh, 03Fh, 040h, 0C0h
	DB  000h, 000h, 055h, 055h, 000h, 03Fh, 055h, 040h, 0FFh, 03Fh
	DB  000h, 0C0h, 0C0h, 000h, 015h, 055h, 000h, 0FFh, 055h, 000h
	DB  0FFh, 03Fh, 000h, 0C0h, 0F0h, 000h, 005h, 055h, 003h, 0FFh
	DB  054h, 000h, 0FFh, 0FFh, 000h, 000h, 03Ch, 0FFh, 0C3h, 000h
	DB  0CFh, 03Fh, 030h, 0C0h, 0FFh, 0FFh, 000h, 000h, 0C0h, 000h
	DB  03Fh, 0FFh, 000h, 0FFh, 0FFh, 000h, 0FFh, 0FFh, 000h, 000h
bcopter_right0	label	byte
	DB  00Eh, 006h, 0FFh, 0FFh, 000h, 000h, 0F0h, 000h, 00Fh, 0FFh
	DB  000h, 000h, 0FFh, 0FFh, 0FFh, 0FFh, 000h, 000h, 0FFh, 0FFh
	DB  000h, 000h, 000h, 000h, 0FFh, 0FFh, 0FFh, 0FFh, 000h, 000h
	DB  0FFh, 0FFh, 000h, 000h, 00Fh, 0FFh, 0F0h, 000h, 0FFh, 0FFh
	DB  000h, 000h, 0FFh, 0C0h, 000h, 015h, 000h, 03Fh, 055h, 040h
	DB  0FCh, 0FFh, 003h, 000h, 0FFh, 003h, 000h, 054h, 0FFh, 0CFh
	DB  000h, 010h, 0FCh, 0FFh, 003h, 000h, 0FCh, 00Fh, 001h, 050h
	DB  0FFh, 0F3h, 000h, 004h, 0FCh, 0FCh, 003h, 001h, 030h, 00Fh
	DB  045h, 050h, 0FFh, 0FCh, 000h, 001h, 000h, 003h, 0FFh, 0FCh
	DB  0C0h, 00Fh, 015h, 050h, 0FFh, 0FCh, 000h, 001h, 0FCh, 0FCh
	DB  003h, 001h, 030h, 003h, 045h, 054h, 0FFh, 0FCh, 000h, 001h
	DB  0FCh, 0FFh, 003h, 000h, 0FCh, 000h, 001h, 055h, 000h, 000h
	DB  055h, 055h, 0FCh, 0FFh, 003h, 000h, 0FFh, 000h, 000h, 055h
	DB  000h, 003h, 055h, 054h, 0FFh, 0FFh, 000h, 000h, 0FFh, 0C0h
	DB  000h, 015h, 000h, 00Fh, 055h, 050h, 0FFh, 0FFh, 000h, 000h
	DB  0FCh, 0F3h, 003h, 00Ch, 0FFh, 03Ch, 000h, 0C3h, 0FFh, 0FFh
	DB  000h, 000h, 0FFh, 000h, 000h, 0FFh, 000h, 003h, 0FFh, 0FCh
bcopter_right1	label	byte
	DB  00Eh, 006h, 0FFh, 0FFh, 000h, 000h, 0F0h, 000h, 00Fh, 0FFh
	DB  000h, 000h, 0FFh, 0FFh, 0FFh, 0FFh, 000h, 000h, 0F0h, 000h
	DB  00Fh, 0FFh, 00Fh, 0FFh, 0F0h, 000h, 0FFh, 0FFh, 000h, 000h
	DB  0FFh, 0FFh, 000h, 000h, 00Fh, 0FFh, 0F0h, 000h, 0FFh, 0FFh
	DB  000h, 000h, 0FFh, 0C0h, 000h, 015h, 000h, 03Fh, 055h, 040h
	DB  0FFh, 0FFh, 000h, 000h, 0FFh, 003h, 000h, 054h, 0FFh, 0CFh
	DB  000h, 010h, 0CFh, 0CFh, 030h, 030h, 0FCh, 00Fh, 001h, 050h
	DB  0FFh, 0F3h, 000h, 004h, 0F3h, 03Ch, 00Ch, 0C1h, 030h, 00Fh
	DB  045h, 050h, 0FFh, 0FCh, 000h, 001h, 0FCh, 003h, 003h, 054h
	DB  0C0h, 00Fh, 015h, 050h, 0FFh, 0FCh, 000h, 001h, 0F3h, 03Ch
	DB  00Ch, 0C1h, 030h, 003h, 045h, 054h, 0FFh, 0FCh, 000h, 001h
	DB  0CFh, 0CFh, 030h, 030h, 0FCh, 000h, 001h, 055h, 000h, 000h
	DB  055h, 055h, 0FFh, 0FFh, 000h, 000h, 0FFh, 000h, 000h, 055h
	DB  000h, 003h, 055h, 054h, 0FFh, 0FFh, 000h, 000h, 0FFh, 0C0h
	DB  000h, 015h, 000h, 00Fh, 055h, 050h, 0FFh, 0FFh, 000h, 000h
	DB  0FCh, 0F3h, 003h, 00Ch, 0FFh, 03Ch, 000h, 0C3h, 0FFh, 0FFh
	DB  000h, 000h, 0FFh, 000h, 000h, 0FFh, 000h, 003h, 0FFh, 0FCh
balloon label	byte
	DB  014h, 004h, 0FFh, 0C0h, 000h, 03Fh, 003h, 0FFh, 0FCh, 000h
	DB  0FCh, 000h, 003h, 0EAh, 000h, 03Fh, 057h, 0C0h, 0F0h, 000h
	DB  00Dh, 06Ah, 000h, 00Fh, 056h, 0B0h, 0C0h, 000h, 035h, 06Ah
	DB  000h, 003h, 056h, 0ACh, 0C0h, 000h, 035h, 0AAh, 000h, 000h
	DB  055h, 0ABh, 000h, 000h, 0D5h, 0AAh, 000h, 000h, 055h, 0ABh
	DB  000h, 000h, 0D5h, 0AAh, 000h, 000h, 055h, 0ABh, 000h, 000h
	DB  0D5h, 0AAh, 000h, 000h, 055h, 0ABh, 0C0h, 000h, 035h, 0AAh
	DB  000h, 003h, 055h, 0ACh, 0C0h, 000h, 035h, 06Ah, 000h, 003h
	DB  056h, 0ACh, 0C0h, 000h, 035h, 06Ah, 000h, 003h, 056h, 0ACh
	DB  0F0h, 000h, 00Fh, 0EAh, 000h, 00Fh, 057h, 0F0h, 0F3h, 0C0h
	DB  00Ch, 03Fh, 003h, 0CFh, 0FCh, 030h, 0FCh, 0FFh, 003h, 000h
	DB  0FFh, 03Fh, 000h, 0C0h, 0FCh, 0FFh, 003h, 000h, 0FFh, 03Fh
	DB  000h, 0C0h, 0FFh, 03Fh, 000h, 0C0h, 0FCh, 0FFh, 003h, 000h
	DB  0FFh, 03Fh, 000h, 0C0h, 0FCh, 0FFh, 003h, 000h, 0FFh, 0C0h
	DB  000h, 03Fh, 003h, 0FFh, 0FCh, 000h, 0FFh, 0C0h, 000h, 03Fh
	DB  003h, 0FFh, 0FCh, 000h, 0FFh, 0F0h, 000h, 00Fh, 00Fh, 0FFh
	DB  0F0h, 000h
;
;Below is a form for a crescent moon in a form suitable for a BYTE-MOVE
; driver. The format is:
;	byte 0 - height in lines (h)
;	byte 1 - width in bytes  (w)
;	followed by w X h image bytes
;
moon	label	byte
	DB	014h, 004h, 000h, 000h, 03Fh, 0FCh
	DB	000h, 00Fh, 0FFh, 0FFh, 000h, 0FFh, 0FFh, 000h
	DB	003h, 0FFh, 0F0h, 000h, 00Fh, 0FFh, 0C0h, 000h
	DB	03Fh, 0FFh, 000h, 000h, 03Fh, 0FFh, 000h, 000h
	DB	0FFh, 0FFh, 000h, 000h, 0FFh, 0FCh, 000h, 000h
	DB	0FFh, 0FCh, 000h, 000h, 0FFh, 0FCh, 000h, 000h
	DB	0FFh, 0FCh, 000h, 000h, 0FFh, 0FFh, 000h, 000h
	DB	03Fh, 0FFh, 000h, 000h, 03Fh, 0FFh, 000h, 000h
	DB	00Fh, 0FFh, 0C0h, 000h, 003h, 0FFh, 0F0h, 000h
	DB	000h, 0FFh, 0FFh, 000h, 000h, 00Fh, 0FFh, 0FFh
	DB	000h, 000h, 03Fh, 0FCh, 000h, 000h, 000h, 000h
	DB	03Fh, 0FFh, 000h, 000h, 000h, 000h, 00Fh, 0FFh
	DB	0C0h, 000h, 000h, 000h, 003h, 0FFh, 0F0h, 000h
	DB	000h, 000h, 000h, 0FFh, 0FFh, 000h, 000h, 000h
	DB	000h, 00Fh, 0FFh, 0FFh, 0C0h, 000h, 000h, 000h
;
;The tables below define the x,y and color of pixels which represent
; stars in a night sky.
;
starx	label	byte
	db     10, 50, 39, 22, 41,  2, 50, 33, 65, 41, 15, 19, 19, 54
	db     34, 61, 19, 41, 22, 55, 23, 68,	8, 29, 51, 71, 39, 30
	db     41,  9, 21, 13, 68, 61, 43, 70, 40, 17, 39, 19, 29, 45
num_stars	equ	$-starx
stary	label	byte
	db	7, 33, 90,100, 80, 35, 92,172,106, 97,123,168, 42, 88
	db    150, 34, 29, 90,170, 65, 39, 99,145,163,109, 78,127,166
	db    169, 84, 15, 65, 99,155, 89, 58, 25, 80, 76,168, 98, 99
star_color label   byte
	db	1,  2,	3,  1,	2,  3,	1,  2,	3,  1,	2,  3,	1,  2
	db	3,  1,	2,  3,	1,  2,	3,  1,	2,  3,	1,  2,	3,  1
	db	2,  3,	1,  2,	3,  1,	2,  3,	1,  2,	3,  1,	2,  3
;
start	proc	near
	cld			;count up
	push	cs		;most data is kept in code segment
	pop	ds		;
;set 320x200x4 graphics mode
	mov	ax,0004h	;graphics mode 4 is supported by both
	int	10h		; the EGA and CGA
;select palette 0
	mov	ah,0bh		;set color palette function
	mov	bh,1		;select palette to be used subfunction
	mov	bl,0		;select palette 0 (green/red/yellow)
	int	10h		;
;put stars into background buffer
	mov	ax,background_segment
	mov	es,ax
	mov	bx,num_stars-1
	mov	dl,80		    ;lines are 80 bytes long
next_star:
	sub	di,di		    ;calculate star's screen buffer
	mov	al,[stary+bx]	    ; address based on line number
	shr	al,1		    ; and byte position from tables
	jnc	calc_y_offset	    ;
	mov	di,2000h	    ;odd lines in second bank
calc_y_offset:
	mul	dl		    ;number of even lines * 80
	mov	cl,[starx+bx]	    ; plus byte position in line
	sub	ch,ch		    ; plus odd line offset
	add	ax,cx		    ; is screen buffer offset
	add	di,ax		    ;
	mov	al,[star_color+bx]  ;get the star image byte (all are
	or	es:[di],al	    ; single pixels) and OR it into
	dec	bx		    ; the background buffer.
	jns	next_star	    ;
;put moon into background buffer
	mov	ax,background_segment
	mov	es,ax		    ;put forms into background buffer
	mov	bx,88		    ;put moon image on line 88
	mov	cx,37		    ; and byte 37
	mov	si,offset moon	    ;
	call	byte_move_form_driver
;put horizon into background buffer
	mov	ax,background_segment  ;horizon is two consecutive
	mov	es,ax		       ; red lines
	mov	ax,0aaaah	       ;8 red pixels
	mov	di,92*80	       ;point to scan line 184
	mov	cx,40		       ;width of screen in words
	rep stosw
	mov	di,92*80+2000h	       ;point to scan line 185
	mov	cx,40		       ; and draw it
	rep stosw
;copy background to display memory
	mov	ax,screen_buffer_adr   ;
	mov	es,ax		       ;
	mov	ax,background_segment  ;
	mov	ds,ax		       ;
	sub	si,si		       ;
	sub	di,di		       ;
	mov	cx,2000h	       ;
	rep movsw		       ;
;
;Initialize the object services routine
;
	call	initialize
;
;Orchestrate the objects' movements
;
	push	cs		  ;object data is kept in
	pop	ds		  ; code segment
iteration_loop: 		  ;sequence all objects once
	mov	di,((num_objects-1) * 2) ;start with last object
next_object:
;see if it's time to manipulate object
	dec	[delay+di]	  ;each delay count is 1/60 second
	jnz	done_with_object  ; so long as program can keep up
;see if it's time to get next set of control variables
	dec	[repeat+di]	  ;each count is the number of
	jnz	reset_delay	  ; movements using the present set
				  ; of control values
;get next set of control parameters
	mov	si,[control+di]   ;get the addr of the parameter list
	lodsw			  ;get the number of bytes to move
	mov	[xinc+di],ax	  ; horizontally each time delay
				  ; counts down to zero
	lodsw			  ;get the number of lines to move
	mov	[yinc+di],ax	  ; vertically each count down
	lodsw			  ;get pointer to the table of
	mov	[form+di],ax	  ; form addres to be sequenced though
	mov	[formbase+di],ax  ;set to repeat with starting form
	lodsw			  ; when the end of the table is hit
	mov	[formmax+di],ax   ;save end of table marker
	lodsw			  ;get next delay count which controls
	mov	[delaybase+di],ax ; the speed
	lodsw			  ;get the number of times to use
	mov	[repeat+di],ax	  ; this new set of control parameters
	cmp	[controlmax+di],si;point to next list of control
	ja	save_control_base ; parameters to be used.
	mov	si,[controlbase+di] ; reycle when end of list hit
save_control_base:
	mov	[control+di],si   ;next control list entry address
;
reset_delay:
	mov	ax,[delaybase+di] ;reset iteration count until
	mov	[delay+di],ax	  ; next manipulation of this object
;find object's new position
	mov	cx,[x+di]	  ;calculate new x and y positions
	add	cx,[xinc+di]	  ; and store them
	mov	[x+di],cx	  ;
	mov	bx,[y+di]	  ;
	add	bx,[yinc+di]	  ;
	mov	[y+di],bx	  ;
;point to new form for object so that it appears to move internally
	mov	si,[form+di]	  ;each time an object is counted down
	inc	si		  ; the form used is taken from the
	inc	si		  ; next address in table
	cmp	[formmax+di],si   ;
	ja	setform 	  ;
	mov	si,[formbase+di]  ;
setform:
	mov	[form+di],si	;cycle to the next form for the object
	mov	si,[si] 	;put pointer to object's form in SI
	shr	di,1		;object number in DI
				;BX holds line number, CX byte number
	call	object_services ;register change in object's status
	shl	di,1		;turn object number into object index
;point to next object
done_with_object:
	dec	di
	dec	di
	js	check_for_keystroke ;see if finished with iteration
	jmp	next_object	    ; if not process next object
;
;Check for keystroke; if so, clear key & emd.
;
check_for_keystroke:
	mov	ah,1			 ;see if a char is waiting
	int	16h			 ;get keyboard status
	jnz	getkey			 ;if zero no key waiting
;
;Wait for new vertical sync (CGA) or retrace (EGA) before putting
; objects on screen to avoid undesirable screen breakup and blinking
; effects. Waiting also keeps the objects moving a constant rate.
;
if cga
	mov	dx,3dah 	       ;point to cga status register
wait_for_not_vert_sync:
	in	al,dx		       ;wait for begining of vertical
	and	al,08h		       ; sunc by starting search from
	jnz	wait_for_not_vert_sync ; outside of sync pulse
wait_for_vert_sync:
	in	al,dx		       ;wait for start of sync
	and	al,08h		       ;
	jz	wait_for_vert_sync     ;
;
	pushf			       ;push flags to simulate an
	call	put_objects_on_screen  ; interrupt
endif
if ega
	mov	ax,[old_vert_count]	   ;synchronize animation loop
wait_for_after_interrupt:		   ; to vert interrupt so it
	cmp	ax,[vert_int_modulo_count] ; will run at a fixed
	je	wait_for_after_interrupt   ; smooth rate
	mov	ax,[vert_int_modulo_count] ;save new as old for next
	mov	[old_vert_count],ax	   ; time
endif
	jmp	iteration_loop		   ;

;
;Run is completed.
;
getkey:
	sub	ah,ah	   ;get key that was hit
	int	16h	   ;
done:
	call	terminate  ;do any clean up required by the sprite
;			   ; routines
;Set to text mode
;
	mov	ax,0002h   ;set the adapter to video mode 2
	int	10h	   ;
;
;Return to DOS
;
	mov	ax,4c00h   ;terminate program with return code of zero
	int	21h	   ;
start	endp
cseg	ends
	end	start	   ;program execution will start at start
