{ ATBIOS -- PC Tech Journal AT BIOS Information Display Program  }
{                                                                }
{ Version 1.00                                                   }
{ Last modified 05/23/86                                         }
{ Copyright (c) 1986, PC Tech Journal                            }
{ Program by: Paul Pierce, Ted Forgeron, Steven Armbrust         }
{                                                                }
{ Displays pertinent information from the BIOS code and data     }
{ areas.                                                         }
{                                                                }
{ This program is written in Turbo Pascal.  However, it can      }
{ be easily ported to any Pascal compiler that allows absolute   }
{ addressing.                                                    }

PROGRAM at_bios_info ;

  CONST
    at_id = $fc ;
    printer_mask = $c000 ;
    game_mask = $1000 ;
    serial_mask = $0e00 ;
    dma_mask = $0100 ;
    drive_num_mask = $00c0 ;
    video_mask = $0030 ;
    ndp_mask = $0002 ;
    drive_mask = $0001 ;
    co40 = $0010 ;
    co80 = $0020 ;
    mono = $0030 ;

  VAR
    i : integer ;
    romdate : ARRAY [1..9] OF char absolute $f000:$fff5 ;
    machine_id : byte absolute $f000:$fffe ;
    copyright : ARRAY [1..80] OF char absolute $f000:$e000 ;
    equip_flag : integer absolute $40:$10 ;
    mem_size : integer absolute $40:$13 ;
    key_buf : ARRAY [1..32] OF char absolute $40:$1e ;
    video_mode : byte absolute $40:$49 ;

  BEGIN
    clrscr;
    write('ATBIOS -- PC Tech Journal AT BIOS Information ') ;
    writeln('Display');
    writeln('Version 1.00, Copyright (c) 1986 PC Tech Journal') ;
    writeln;
    writeln('ROM BIOS date is                       ',romdate) ;
    IF machine_id = at_id THEN
      writeln('Machine ID is                          AT COMPATIBLE')
    ELSE
      writeln('Machine ID is                          NOT AT') ;
    write('Copyright Statement is ') ;
    window(40,6,80,7);
    gotoxy(1,1);
    write(copyright) ;
    window(1,1,80,25) ;
    gotoxy(1,8);
    write('Diskette Drives Installed              ') ;
    if (equip_flag and drive_mask) <> 0
    then writeln(((drive_num_mask and equip_flag) div 64) + 1)
    else writeln('0');
    write('80287 Math Coprocessor                 ') ;
    if (equip_flag and ndp_mask) <> 0
    then writeln('YES')
    else writeln('NO');
    write('Initial Video Mode                     ') ;
    case (equip_flag and video_mask) of
      co40: writeln('CGA 40x25 B/W text');
      co80: writeln('CGA 80x25 B/W text');
      mono: writeln('Monochrome 80x25 text');
    end;
    write('Current Video Mode                     ') ;
    case video_mode of
      00: writeln('CGA 40x25 B/W text');
      01: writeln('CGA 40x25 16-color text');
      02: writeln('CGA 80x25 B/W text');
      03: writeln('CGA 80x25 16-color text');
      04: writeln('CGA 320x200 4-color graphics');
      05: writeln('CGA 320x200 4-gray graphics');
      06: writeln('CGA 640x200 B/W graphics');
      07: writeln('Monochrome 80x25 text');
      08: writeln('JR 160x200 16-color graphics');
      09: writeln('JR 320x200 16-color graphics');
      10: writeln('EGA 640x200 4/64-color graphics');
      13: writeln('EGA 320x200 16-color graphics');
      14: writeln('EGA 640x200 16-color graphics');
      15: writeln('EGA 640x350 4-color graphics');
    end;
    write('DMA Present                            ');
    if (equip_flag and dma_mask) <> 0
    then writeln('NO')
    else writeln('YES');
    writeln('RS-232 Serial Ports                    ',
             (equip_flag and serial_mask) div 512);
    write('Game Adapter Present                   ');
    if (equip_flag and game_mask) <> 0
    then writeln('YES')
    else writeln('NO');
    writeln('Parallel Printer Ports                 ',
             abs((equip_flag and printer_mask) div 16384));
    writeln('Memory Size in K Bytes                 ',mem_size);
    write('Keyboard Buffer Contents               ');
    i := 1;
    while i <= 32 do
    begin
      if (key_buf[i] < '!') or (key_buf > '}') then
        write('.')
      else write(key_buf[i]);
      i := i + 2 ;
    end;
    writeln;
  END.
