PROGRAM GPoker;
USES Crt, Cards, Graph, Drivers, Fonts, GCards, poker;
TYPE
  GraphicPoker = OBJECT (PokerGame)
    CONSTRUCTOR Init(iTC : Byte);
    DESTRUCTOR Done; virtual;
    PROCEDURE Display; Virtual;
    PROCEDURE ClearBottom; virtual;
    PROCEDURE ShowStake; virtual;
    PROCEDURE HoldButton(B : Byte); virtual;
    PROCEDURE Tell(M1, M2 : message); virtual;
  END;

  CONSTRUCTOR GraphicPoker.Init(iTC : Byte);
  VAR
    grDriver : Integer;
    grMode   : Integer;
    ErrCode  : Integer;

    PROCEDURE ErrorOut(what : String);
    BEGIN WriteLn('Error in ', what, ' loading.'); Halt(1); END;

  BEGIN
    PokerGame.Init(iTC);
    TableColor := iTC;
    grDriver := EGA; grMode := EGAhi;
    IF RegisterBGIDriver(@EGAVGAdriverProc) < 0 THEN
      ErrorOut('EGAVGA driver');
    IF RegisterBGIFont(@TriplexFontProc) < 0 THEN
      ErrorOut('Triplex font');
    IF RegisterBGIFont(@SmallFontProc) < 0 THEN
      ErrorOut('Small font');
    IF RegisterBGIFont(@SansSerifFontProc) < 0 THEN
      ErrorOut('SansSerif font');
    InitGraph(grDriver, grMode, '');
    ErrCode := GraphResult;
    IF ErrCode <> grOk THEN
      BEGIN
        WriteLn('Graphics error : ', GraphErrorMsg(ErrCode));
        Halt(1);
      END;
    D := New(GDeckP, Init(0, 0, tableColor));
    D^.shuffle;
    margin := 30; tab := 120; topmargin := 120;
  END;

  PROCEDURE GraphicPoker.Display;
  BEGIN
    SetBkColor(tableColor);
    SetPalette(brown, black);
    SetColor(white);
    Rectangle(0, 0, 639, 349);
    SetTextStyle(TriplexFont, HorizDir, 7);
    SetTextJustify(CenterText, BottomText);
    OutTextXY(320, 50, 'VIDEO POKER');
    SetTextJustify(LeftText, BottomText);
    SetColor(brown);
    rectangle(320, 265, 633, 346);
    SetFillStyle(solidfill, white);
    SetTextStyle(SmallFont, HorizDir, 4);
    SetColor(brown);
    bar(321, 266, 632, 345);
    OutTextXY(325, 288, 'Jacks or better');
    OutTextXY(325, 299, 'Two pair');
    OutTextXY(325, 310, 'Three of a kind');
    OutTextXY(325, 321, 'Straight');
    OutTextXY(480, 288, 'Flush');
    OutTextXY(480, 299, 'Full house');
    OutTextXY(480, 310, 'Four of a kind');
    OutTextXY(480, 321, 'Straight flush');
    OutTextXY(480, 332, 'Royal flush');
    SetTextJustify(RightText, BottomText);
    SetColor(LightRed);
    OutTextXY(470, 288, '1-1');
    OutTextXY(470, 299, '2-1');
    OutTextXY(470, 310, '3-1');
    OutTextXY(470, 321, '4-1');
    OutTextXY(622, 288, '6-1');
    OutTextXY(622, 299, '9-1');
    OutTextXY(622, 310, '25-1');
    OutTextXY(622, 321, '50-1');
    OutTextXY(622, 332, '250-1');
  END;

  DESTRUCTOR GraphicPoker.Done;
  BEGIN PokerGame.Done; CloseGraph; END;

  PROCEDURE GraphicPoker.ClearBottom;
  BEGIN
    SetFillStyle(solidFill, GetBkColor);
    BAR(1, 265, 319, 348);
  END;

  PROCEDURE GraphicPoker.ShowStake;
  VAR S : String[40];
  BEGIN
    Str(0.25*stake:1:2, S);
    SetFillStyle(SolidFill, Brown);
    Bar(180, 60, 460, 100);
    SetColor(white);
    SetTextStyle(TriplexFont, HorizDir, 4);
    Rectangle(180, 60, 460, 100);
    SetTextJustify(RightText, BottomText);
    OutTextXY(450, 90, '$'+S);
    SetTextStyle(TriplexFont, HorizDir, 2);
    SetTextJustify(LeftText, TopText);
  END;

  PROCEDURE GraphicPoker.HoldButton(B : Byte);
  BEGIN
    IF Hold[B] THEN
      BEGIN
        SetFillStyle(SolidFill, white);
        SetColor(Red);
        Bar(30+B*120, 230, 130+B*120, 255);
        Rectangle(30+B*120, 230, 130+B*120, 255);
        OutTextXY(40+B*120, 232, 'H O L D');
        SetColor(white);
      END
    ELSE
      BEGIN
        SetFillStyle(solidFill, GetBkColor);
        Bar(30+B*120, 230, 130+B*120, 255);
      END;
  END;

  PROCEDURE GraphicPoker.Tell(M1, M2 : message);
  BEGIN OutTextXY(10, 280, M1); OutTextXY(10, 310, M2); END;

VAR
  V     : GraphicPoker;
  again : boolean;
BEGIN
  V.Init(blue);
  V.Display;
  REPEAT
    V.Play(again);
  UNTIL NOT again;
  V.Done;
END.