{$A+,B-,D-,E-,F-,I+,L-,N-,O-,R-,S-,V-}
{$M 16384,0,655360}
UNIT GCards;
{Graphic Cards, assumes EGA Hi-Res mode}
(**********************)
(**)   INTERFACE    (**)
(**********************)
USES Crt, Graph, Cards;

TYPE
  GCardP = ^GCard;
  GDeckP = ^GDeck;

  AllSettings = RECORD
    FI : FillSettingsType;
    FP : FillPatternType;
    CO : Word;
    TS : TextSettingsType;
    LI : LineSettingsType;
  END;

  pipLocation = array[0..9] of ARRAY[0..1] of byte;

  GCard = OBJECT (Card)
    BigPip, SmPip : Pointer;
    PL            : ^PipLocation;
    CONSTRUCTOR Init(iValue:Word;iTC:byte;iFaceUp:Boolean);
    CONSTRUCTOR InitXY(iValue,iX,iY:Word;
		       iTC:Byte;iFaceUp:Boolean);
    DESTRUCTOR Done; virtual;
  {-next 4 routines locate card where you say}
    PROCEDURE DrawAt(vX,vY:word); Virtual;
    PROCEDURE HideAt(vX,vY:Word); Virtual;
    PROCEDURE PointTo(vX,vY:Word;dire:direction); Virtual;
    PROCEDURE UnPoint(vX,vY:Word;dire:direction); Virtual;
  END;

  GDeck = OBJECT (Deck)
    CONSTRUCTOR Init(iX,iY:Word;iTC:Byte);
    DESTRUCTOR Done; virtual;
  END;

(**********************)
(**) IMPLEMENTATION (**)
(**********************)
CONST
  {pip locations on the cards}
  {reason for math is: first number is place of CENTER
   of pip.  Second is adjust for PUTIMAGE}
  R=20-12; S=25-13; T=30-12; U=40-12; V=50-13;
  W=60-12; X=70-12; Y=75-13; Z=80-12;
  pLocs : array[0..12] of PipLocation =
{A}(((0,0),(V,V),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0)),
{2} ((V,R),(0,0),(V,Z),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0)),
{3} ((V,R),(V,V),(V,Z),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0)),
{4} ((S,R),(0,0),(S,Z),(0,0),(0,0),(Y,R),(0,0),(Y,Z),(0,0),(0,0)),
{5} ((S,R),(0,0),(S,Z),(V,V),(0,0),(Y,R),(0,0),(Y,Z),(0,0),(0,0)),
{6} ((S,R),(S,V),(0,0),(S,Z),(0,0),(0,0),(Y,R),(Y,V),(0,0),(Y,Z)),
{7} ((S,R),(S,V),(0,0),(S,Z),(V,T),(0,0),(Y,R),(Y,V),(0,0),(Y,Z)),
{8} ((S,R),(S,V),(0,0),(S,Z),(V,T),(V,X),(Y,R),(Y,V),(0,0),(Y,Z)),
{9} ((S,R),(S,U),(S,W),(S,Z),(V,V),(0,0),(Y,R),(Y,U),(Y,W),(Y,Z)),
{T} ((S,R),(S,U),(S,W),(S,Z),(V,T),(V,X),(Y,R),(Y,U),(Y,W),(Y,Z)),
{J} ((T,S),(X,Y),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0)),
{Q} ((T,S),(X,Y),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0)),
{K} ((T,S),(X,Y),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0),(0,0)));


  {OBJ files contain bitmaps for the pips}
  {$L Heart}    PROCEDURE Heart;    External;
  {$L Diamond}  PROCEDURE Diamond;  External;
  {$L Club}     PROCEDURE Club;     External;
  {$L Spade}    PROCEDURE Spade;    External;
  {$L LHeart}   PROCEDURE LHeart;   External;
  {$L LDiamond} PROCEDURE LDiamond; External;
  {$L LClub}    PROCEDURE LClub;    External;
  {$L LSpade}   PROCEDURE LSpade;   External;

  {$L CardBack} PROCEDURE CardBack; External;

  CONSTRUCTOR GCard.Init(iValue:Word;iTC:Byte;iFaceUp:Boolean);
  BEGIN
    Card.Init(iValue,iTC,iFaceUp);
    IF value >=26 THEN PipColor := brown;
    CASE getSuit OF
      0:BEGIN BigPip := @Heart;   SmPip := @LHeart;   END;
      1:BEGIN BigPip := @Diamond; SmPip := @LDiamond; END;
      2:BEGIN BigPip := @Club;    SmPip := @LClub;    END;
      3:BEGIN BigPip := @Spade;   SmPip := @LSpade;   END;
    END;
    PL := @PLocs[GetRank];
  END;

  CONSTRUCTOR GCard.InitXY(iValue,iX,iY:Word;
			   iTC:Byte;iFaceUp:Boolean);
  BEGIN Init(iValue,iTC,iFaceUp); PutInPlace(iX,iY); END;

  DESTRUCTOR GCard.Done; BEGIN Card.done; END;

  PROCEDURE SaveAll(VAR AS : AllSettings);
  BEGIN
    WITH AS DO
      BEGIN
        CO := GetColor;
        GetFillSettings(FI);
        IF FI.pattern = UserFill THEN GetFillPattern(FP);
        GetTextSettings(TS);
        GetLineSettings(LI);
      END;
  END;

  PROCEDURE RestoreAll(VAR AS : AllSettings);
  BEGIN
    WITH AS DO
      BEGIN
        WITH TS DO
          BEGIN
            SetTextJustify(Horiz, Vert);
            SetTextStyle(Font, Direction, CharSize);
          END;
        SetFillStyle(FI.pattern,FI.color);
        IF FI.pattern = UserFill THEN SetFillPattern(FP,FI.color);
        SetColor(CO);
        WITH LI DO SetLineStyle(LineStyle, Pattern,Thickness);
      END;
  END;

  PROCEDURE GCard.DrawAt(vX,vY:word);
  VAR A : AllSettings;

    PROCEDURE CardAt(X,Y,valu:Word);
    VAR N : Byte;
    BEGIN
      {--- draw the white playing card ---}
      SetColor(White);
      SetFillStyle(solidfill,White);
      Bar(X,Y,X+100,Y+100);
      {--- put the rank in the corner ---}
      SetTextJustify(LeftText,TopText);
      SetTextStyle(SansSerifFont,HorizDir,1);
      SetColor(PipColor);
      OutTextXY(X+2,Y+2,pips[GetRank]);
      PutImage(X+2,Y+21,SmPip^,AndPut);
      {--- draw diagonal swatch for face cards ---}
      IF GetRank > 9 THEN
        BEGIN
          Rectangle(x+12,Y+12,x+88,Y+88);
          FOR N := 1 to 12 DO line(x+12,y+64+2*N,x+64+2*n,Y+12);
          FOR N := 1 to 12 DO line(x+12+2*N,Y+88,x+88,y+12+2*N);
        END;
      {--- put the pips in place ---}
      FOR N := 0 to 9 DO
        IF PL^[N][0] > 0 THEN
          PutImage(X+PL^[N][0],Y+PL^[N][1],BigPip^,AndPut);
    END;

    PROCEDURE CardBackAt(X,Y:Word);
    BEGIN PutImage(X,Y,@CardBack^,CopyPut); END;

  BEGIN
    SaveAll(A);
    IF FaceUp THEN CardAt(vX,vY,Value)
    ELSE CardBackAt(vX,vY);
    RestoreAll(A);
  END;

  PROCEDURE GCard.HideAt(vX,vY:word);
  VAR A : AllSettings;
  BEGIN
    SaveAll(A);    SetFillStyle(solidFill,GetBkColor);
    Bar(vX,vY,vX+100,vY+100);           RestoreAll(A);
  END;

  PROCEDURE GCard.PointTo(vX,vY:Word;dire:direction);
  VAR A : AllSettings;
  BEGIN
    SaveAll(A);                       SetColor(white);
    Rectangle(vX-2,vY-2,vX+102,vY+102); RestoreAll(A);
  END;

  PROCEDURE GCard.UnPoint(vX,vY:Word;dire:direction);
  VAR A : AllSettings;
  BEGIN
    SaveAll(A);                  SetColor(TableColor);
    Rectangle(vX-2,vY-2,vX+102,vY+102); RestoreAll(A);
  END;

  CONSTRUCTOR GDeck.Init(iX,iY:Word;iTC:Byte);
  VAR valu : Word;
  BEGIN
    Pile.Init(iX,iY,no);
    FOR valu := 0 to 51 DO AddCard(New(GCardP,Init(valu,iTC,false)));
  END;

  DESTRUCTOR GDeck.done; BEGIN Deck.Done; END;

END.