;----------------------------------------------------------------------
; STRINGS2.ASM --- MASM String Package #2
; Copyright (c), 1988 Ziff Communications Co.
; PC Magazine * Ray Duncan * November 29, 1988
;----------------------------------------------------------------------
bufsize equ     1024            ; size of buffer for temporary strings

_DATA   segment word public 'DATA'

lctab   dw      26              ; 'strlwr' translation table
        dw      'A'
        db      'abcdefghijklmnopqrstuvwxyz'

uctab   dw      26              ; 'strupr' translation table
        dw      'a'
        db      'ABCDEFGHIJKLMNOPQRSTUVWXYZ'

strbuf  db      bufsize dup (?) ; temporary string buffer
strptr  dw      strbuf          ; current buffer pointer

_DATA   ends

_TEXT   segment word public 'CODE'
        assume  cs:_TEXT
;----------------------------------------------------------------------
; STRCAT:       string concatenation routine
;
; Call with:    DS:SI = address of string1
;               BX    = length of string1
;               ES:DI = address of string2
;               DX    = length of string2
;
; Returns:      DS:SI = address of result string
;                       in temporary storage
;               BX    = length of result string
;
; Uses:         DI, ES
;----------------------------------------------------------------------
        public  strcat
strcat  proc    near

        push    cx              ; save register
        push    di              ; save string2 address
        push    es
        mov     cx,bx           ; save string1 length
        add     bx,dx           ; BX = result string length
        call    strmem          ; get temporary storage for result string

        cld                     ; copy string1 to result
        rep movsb

        pop     ds              ; get string2 address
        pop     si
        mov     cx,dx
        rep movsb               ; copy string2 to result

        push    es              ; let DS:SI = address of
        push    di              ; result string
        pop     si
        pop     ds
        sub     si,bx           ; correct for bytes moved

        pop     cx              ; restore register
        ret                     ; back to caller

strcat  endp
;----------------------------------------------------------------------
; STRDUP:       string duplication routine
;
; Call with:    DS:SI = address of string
;               BX    = length of string
;
; Returns:      DS:SI = address of string copy
;                       in temporary storage
;               BX    = length of string copy
;
; Uses:         nothing
;----------------------------------------------------------------------
        public  strdup
strdup  proc    near

        push    cx              ; save registers
        push    di
        push    es

        call    strmem          ; get temporary storage to hold string copy

        mov     cx,bx           ; make copy of string
        cld
        rep movsb               

        push    es              ; let DS:SI = address
        push    di              ; of copy
        pop     si
        pop     ds
        sub     si,bx           ; correct for bytes moved

        pop     es              ; restore registers
        pop     di
        pop     cx
        ret                     ; back to caller

strdup  endp
;----------------------------------------------------------------------
; STRXTR:       string extraction routine
;
; Call with:    DS:SI = address of string
;               BX    = length of string
;               CX    = offset of substring
;               DX    = length of substring
;
; Returns:      DS:SI = address of substring
;                       in temporary storage
;               BX    = clamped length of substring
;
;               If BX = 0, then substring offset
;               was invalid and DS:SI is unchanged.
;
; Uses:         nothing
;----------------------------------------------------------------------
        public  strxtr
strxtr  proc    near

        push    cx              ; save register

        add     si,cx           ; point to substring
        sub     bx,cx           ; adjust string length
        jnb     sxtr1           ; length OK, proceed

        xor     bx,bx           ; bad substring,
        jmp     sxtr3           ; return length = 0

sxtr1:  cmp     bx,dx           ; clamp length?
        jb      sxtr2           ; yes, jump
        mov     bx,dx           ; no, set substring length

sxtr2:  call    strdup          ; make copy of substring in temporary storage

sxtr3:  pop     cx              ; restore register
        ret                     ; back to caller

strxtr  endp
;----------------------------------------------------------------------
; STRXLT:       string translation routine
;
; Call with:    DS:SI = address of text string
;               BX    = length of text string
;               ES:DI = address of translation table
;
;               The translation table has the 
;               following format:
;
;               dw   number of character codes in table (n)
;               dw   character code of first position (m)
;               db   translation value for character (m)
;               db   translation value for character (m+1)
;               .
;               .
;               db   translation value for character (m+n-1)
;
;               Any character positions in the table which 
;               contain zero are ignored.  Any characters
;               in the text string falling outside the range 
;               defined by the table are unchanged.
;
; Returns:      DS:SI = address of translated string
;                       in temporary storage
;               BX    = length of translated string
;               ES:DI = translation table address (unchanged)
;----------------------------------------------------------------------
        public  strxlt
strxlt  proc    near

        call    strdup          ; make copy of string to be translated

        push    bx              ; save registers
        push    cx
        push    si
        mov     cx,bx           ; use CX for loop count
        jcxz    sxlt3           ; exit if zero length

sxlt1:  mov     bl,[si]         ; next character
        xor     bh,bh
        sub     bx,es:[di+2]    ; correct for table base
        js      sxlt2           ; jump, outside table
        cmp     bx,es:[di]
        jae     sxlt2           ; jump, outside table

        mov     bl,es:[bx+di+4] ; get translation value
        or      bl,bl           ; is it zero?
        jz      sxlt2           ; yes, ignore it
        mov     [si],bl         ; store translated value

sxlt2:  inc     si              ; bump text string pointer
        loop    sxlt1           ; process next character

sxlt3:  pop     si              ; restore registers
        pop     cx
        pop     bx
        ret                     ; back to caller        

strxlt  endp
;----------------------------------------------------------------------
; STRLWR:       convert string to lower case
;
; Call with:    DS:SI = address of string
;               BX    = length of string
;
; Returns:      DS:SI = address of lower-cased 
;                       string in temporary storage
;               BX    = length of lower-cased string
;
; Uses:         nothing
;----------------------------------------------------------------------
        public  strlwr
strlwr  proc    near

        push    di              ; save registers
        push    es

        mov     di,seg lctab    ; ES:DI = address of lower
        mov     es,di           ; case translation table
        mov     di,offset lctab

        call    strxlt          ; translate the string

        pop     es              ; restore registers
        pop     di
        ret                     ; back to caller

strlwr  endp
;----------------------------------------------------------------------
; STRUPR:       convert string to upper case
;
; Call with:    DS:SI = address of string
;               BX    = length of string
;
; Returns:      DS:SI = address of upper-cased 
;                       string in temporary storage
;               BX    = length of upper-cased string
;
; Uses:         nothing
;----------------------------------------------------------------------
        public  strupr
strupr  proc    near

        push    di              ; save registers
        push    es

        mov     di,seg uctab    ; ES:DI = address of upper
        mov     es,di           ; case translation table
        mov     di,offset uctab

        call    strxlt          ; translate the string

        pop     es              ; restore registers
        pop     di
        ret                     ; back to caller

strupr  endp
;----------------------------------------------------------------------
; STRMEM:       allocate temporary storage for string
;
; Call with:    BX    = length needed
;
; Returns:      ES:DI = address of temporary storage
;               BX    = length (unchanged)
;----------------------------------------------------------------------
strmem  proc    near

        mov     di,seg strptr   ; ES:DI = address within
        mov     es,di           ; temporary string buffer
        assume  es:_DATA
        mov     di,strptr
        add     strptr,bx       ; update buffer pointer

        cmp     strptr,offset (strbuf+bufsize)  ; check for buffer overflow
        jb      smem1           ; jump if no overflow

        mov     di,offset strbuf; reset buffer pointer
        mov     strptr,di
        add     strptr,bx
        assume  es:NOTHING

smem1:  ret                     ; back to caller

strmem  endp

_TEXT   ends
        end
