/*----------------------------------------
   EZTEST4.C -- EZFONT Test Program # 4
                (c) Charles Petzold, 1994
  ----------------------------------------*/

#include <windows.h>
#include <string.h>
#include "ezfont.h"

char szClass [] = "EzTest4" ;
char szTitle [] = "EzTest4:  EZFONT Test Program # 4" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     CHAR       szBuffer [64] ;
     HFONT      hFont ;
     INT        i ;
     TEXTMETRIC tm ;

     SetBkMode (hdc, TRANSPARENT) ;
     SetMapMode (hdc, MM_ANISOTROPIC) ;
     SetWindowExtEx (hdc, 720, 720, NULL) ;
     SetViewportExtEx (hdc, GetDeviceCaps (hdc, LOGPIXELSX),
                           -GetDeviceCaps (hdc, LOGPIXELSY), NULL) ;

     SetViewportOrgEx (hdc, 0, cyArea, NULL) ;
     SetTextAlign (hdc, TA_LEFT | TA_BASELINE) ;

     hFont = EzCreateFont (hdc, "Times New Roman Bold", 360, 0, 0, TRUE) ;

     SelectObject (hdc, hFont) ;
     GetTextMetrics (hdc, &tm) ;

     for (i = 0 ; i < 10 ; i++)
          {
          wsprintf (szBuffer, "Line %d", i) ;

          TextOut (hdc, 0, i * (tm.tmHeight - tm.tmInternalLeading),
                   szBuffer, strlen (szBuffer)) ;
          }

     SelectObject (hdc, GetStockObject (SYSTEM_FONT)) ;
     DeleteObject (hFont) ;

     for (i = 0 ; i < 10 ; i++)
          {
          MoveToEx (hdc,    0, 360 * i, NULL) ;
          LineTo   (hdc, 1440, 360 * i) ;
          }
     }
