*********************************************************************
* GENCDX.PRG                                             FoxPro 2.5
*
* Generate code to create a CDX file, one tag for each field. The
* field names are used for the tag names.
* Sample call: DO GENCDX WITH cGentable, cGencdx, cGenprg
* where cGentable is the DBF whose fields will provide the tags
*       cGencdx is the CDX file where the tags will reside
*       cGenprg is the file for the generated source code
*
*********************************************************************
PARAMETER cGentable, cGencdx, cGenprg
IF EMPTY(cGentable) OR EMPTY(cGencdx) OR EMPTY(cGenprg)
   ? "GENCDX - Generate code to create index tags, one for each field"
   ? "Example: DO GENCDX WITH cGentable, cGencdx, cGenprg"
   RETURN
ENDIF

SET TEXTMERGE ON                 && Turn textmerge on
SET TEXTMERGE TO (cGenprg)       && Send merged output to prgfile
SET TEXTMERGE NOSHOW

nWorkarea = SELECT(0)            && Save the current work area number
SELECT 0                         && Select a work area
USE (cGentable) AGAIN            && Open table

\\*******************************************************************
\* <<cGenprg>>
\* Program to create index tags for fields in the table
\* named <<cGentable>>, and store them in the CDX file
\* named <<cGencdx>>
\********************************************************************
\USE <<cGentable>> EXCLUSIVE     && Open table
*
* For each field in the table, output an INDEX command
* to create an index tag
*
FOR x = 1 TO FCOUNT()
  cField = FIELD(x)
  IF !INLIST(TYPE(cField),'G','M','P')
    \INDEX ON << cField >> TAG << cField >> OF <<cGencdx>>
  ENDIF
ENDFOR
\FLUSH
\USE                             && Close table
\RETURN

USE                              && Close table and cdx file
SET TEXTMERGE OFF                && Turn textmerge off
SET TEXTMERGE TO
FLUSH
SELECT (nWorkarea)               && Return to the proper work area
RETURN
