	name	WinAsm
	page	60,132
	title	WINASM.EXE--Sample Windows assembly language program
;
; WINASM.EXE: demonstrates a simple Windows program written
;             in assembly language.
;
; Copyright 1993, Douglas Boling
;
memS	=	1		;Define Small Model program
?PLM	=	1		;Define Pascal calling convention
?WIN	=	1		;Define Windows prolog and epilog code
?386	=	0		;Don't use 386 instructions

include CMACROS.INC		;Required Windows includes
include WINDOWS.INC
;
; Windows APIs used by program
;
externA  __acrtused
;
; Windows APIs used
;
externFP	LoadIcon
externFP	LoadCursor
externFP	RegisterClass
externFP	CreateWindow
externFP	ShowWindow
externFP	UpdateWindow
externFP	GetMessage
externFP	TranslateMessage
externFP	DispatchMessage

externFP	BeginPaint
externFP	GetClientRect
externFP	DrawText
externFP	EndPaint
externFP	PostQuitMessage
externFP	DefWindowProc
;
; External entry points to the program
;
public		WinMain
public		WndProc
;
; Code segment
;
_TEXT	segment	word public 'CODE'
	assume	cs:_TEXT,ds:_DATA
	.8086
;---------------------------------------------------------------
; WinMain - Standard Windows program entry point
;---------------------------------------------------------------
hInstance	equ	word ptr ss:[bp+12]
hPrevInstance	equ	word ptr ss:[bp+10]
lpCmdLine	equ	dword ptr ss:[bp+6]
nCmdShow	equ	word ptr ss:[bp+4]

hWnd 		equ	word ptr ss:[bp-4]

WinMain	proc	near
	push	bp
	mov	bp,sp
	sub	sp,4			;Make room for local variables
	push	di
	push	si
	
;cProc	WinMain, <PUBLIC>, <DI,SI>
;	parmW	hInstance
;	parmW	hPrevInstance
;	parmD	lpCmdLine
;	parmW	nCmdShow

;	LocalW	hWnd			;Local variables

	
;cBegin	WinMain	
;
; If only instance running, Register the Window class
;	
	cmp	hPrevInstance,0		;See if we need to register the
	jne	WinMain_1		;  window class.
	
	mov	wc.clsStyle,CS_HREDRAW OR CS_VREDRAW
	mov	word ptr wc.clsLpfnWndProc,offset WndProc
	mov	word ptr wc.clsLpfnWndProc+2,cs
	xor	ax,ax
	mov	wc.clsCbClsExtra,ax
	mov	wc.clsCbWndExtra,ax
	mov	ax,hInstance
	mov	wc.clsHInstance,ax

	push	hInstance		;hInst for LoadIcon call
	mov	ax,offset AppName
	push	ds			;Ptr to Icon resource name string
	push	ax	
	call	LoadIcon
	mov	wc.clsHIcon,ax
	
	xor	ax,ax
	push	ax			;hInst = 0 because we are loading
	push	ax			;  a stock object.  The second
	mov	ax,IDC_ARROW		;  parameter is a 32 bit value.
	push	ax
	call	LoadCursor
	mov	wc.clsHCursor,ax
	mov	wc.clsHbrBackground, COLOR_WINDOW + 1

	xor	ax,ax
	mov	word ptr wc.clsLpszMenuName,ax
	mov	word ptr wc.clsLpszMenuName+2,ax

	mov	word ptr wc.clsLpszClassName,offset AppName
	mov	word ptr wc.clsLpszClassName+2,seg AppName
	
	lea	ax,wc
	push	ds
	push	ax
	call	RegisterClass
	or	ax,ax
	jne	WinMain_1
	mov	ax,1
	jmp	MainWinLoopExit
WinMain_1:	
;
; Create the Window
;
	xor	bx,bx			;BX = 0 for NULL pushes
	push	ds			;Far Ptr to Class Name
	mov	ax,offset AppName
	push	ax
	push	ds			;Far Ptr to title text
	mov	ax,offset ttltext
	push	ax
	mov	ax,WS_OVERLAPPEDWINDOW	;Window Style
	push	ax
	push	bx
	mov	ax,CW_USEDEFAULT
	push	ax			;Window Pos x
	push	ax			;Window Pos y
	push	ax			;Window Size cx
	push	ax			;Window Size cy
	push	bx			;Parent Window handle
	push	bx			;Menu handle
	push	hInstance		;Program instance handle
	push	bx			;Far Ptr to Creation data
	push	bx
	call	CreateWindow

	or	ax,ax
	je	MainWinLoopExit		
	mov	hWnd,ax			;Save Window handle

	push	ax			;Save hWnd for UpdateWin call
	
	push	ax			;hWnd
	push	nCmdShow		;Show parameters
	call	ShowWindow

	call	UpdateWindow		;hWnd already pushed
;
; The classic Windows message loop
;	
MainWinLoop:
	lea	di,msg			;Use DI since that reg is 
					;  saved across Win calls.
	push	ds			;Far Ptr to Msg structure
	push	di
	xor	ax,ax
	push	ax			;Handle 0 -> all Windows
	push	ax			;Low msg num
	push	ax			;High msg num
	call	GetMessage
	or	ax,ax			;If WM_QUIT, do so.
	je	MainWinLoopExit
	push	ds			;Far Ptr to Msg structure
	push	di
	call	TranslateMessage
	push	ds			;Far Ptr to Msg structure
	push	di
	call	DispatchMessage
	jmp	short MainWinLoop
MainWinLoopExit:	
	xor	ax,ax			;Set return code 0
MainExit:
	pop	si
	pop	di
	mov	sp,bp
	pop	bp
	ret
WinMain	endp	

;---------------------------------------------------------------
; WndProc - Main Window Callback Function
;---------------------------------------------------------------
hWnd	equ	word ptr ss:[bp+14]
wMsg	equ	word ptr ss:[bp+12]
wParam	equ	word ptr ss:[bp+10]
lParam	equ	dword ptr ss:[bp+6]
lParamh	equ	word ptr ss:[bp+8]	;Redef of lParam for word
lParaml	equ	word ptr ss:[bp+6]	;  addressing.

hdc	equ	word ptr ss:[bp-4]

WndProc	proc	far

	mov	ax,ds			;Windows external entry point
	nop				;  code.  Necessary for all
	inc	bp			;  exported functions.  See
	push	bp			;  Petzold's chapter on memory
	mov	bp,sp			;  managment for details.
	push	ds
	mov	ds,ax
	sub	sp,2
	push	di
	push	si

;cProc	WndProc, <FAR,PUBLIC>, <SI,DI>
;	parmW	hWnd
;	parmW	wMsg
;	parmW	wParam
;	parmD	lParam
;
;	LocalW	hdc
;	
;cBegin	WndProc


	cmp	wMsg,WM_PAINT
	jne	WinProc_1
	push	hWnd			;Window Handle
	lea	ax,ps
	push	ds			;Far Ptr to PaintStruct
	push	ax
	call	BeginPaint
	mov	hdc,ax			;Save handle to DC

	push	hWnd			;Window Handle
	lea	ax,rectC
	push	ds			;Far Ptr to rect structure
	push	ax
	call	GetClientRect
	
	push	hdc			;Handle to DC
	lea	ax,HiText
	push	ds			;Far Ptr to text
	push	ax
	mov	ax,-1			;String length
	push	ax
	lea	ax,rectC
	push	ds			;Far Ptr to rect structure
	push	ax
	mov	ax,DT_SINGLELINE OR DT_CENTER OR DT_VCENTER
	push	ax
	call	DrawText
	
	push	hWnd			;Window Handle
	lea	ax,ps
	push	ds			;Far Ptr to PaintStruct
	push	ax
	call	EndPaint
	xor	ax,ax
	jmp	short WinProc_exit
	
WinProc_1:
	cmp	wMsg,WM_DESTROY
	jne	WinProc_2
	xor	ax,ax
	push	ax
	call	PostQuitMessage
	xor	ax,ax
	jmp	short WinProc_exit
	
WinProc_2:
	push	hWnd
	push	wMsg
	push	wParam

;	push	word ptr lParam+2
;	push	word ptr lParam
	
	push	lParamh 
	push	lParaml
	call	DefWindowProc
WinProc_exit:		
	pop	si			;Windows end procedure
	pop	di			;  code.
	lea	sp,ss:[bp-2]
	pop	ds
	pop	bp
	dec	bp
	retf	10			;Remove caller params
WndProc	endp
;cEnd

_TEXT	ends

_DATA	segment word public 'DATA'

AppName	db	'WinAsm',0		;WinAsm Window class name
ttltext	db	'ASM Program',0		;WinAsm Window title bar text
HiText	db	'Hello Windows',0	;WinAsm Window Text

wc	WNDCLASS	<>
rectC	RECT		<>
ps	PAINTSTRUCT	<>
msg	MSGSTRUCT	<>

_DATA	ends
	end	

