/*----------------------------------------
   UNITYPE.C -- Type Unicode Characters
                (c) Charles Petzold, 1993
  ----------------------------------------*/

#include <windows.h>
#include <commdlg.h>
#include <stdio.h>
#include <string.h>
#include <wchar.h>
#include <tchar.h>
#include "unitype.h"

long APIENTRY WndProc (HWND, UINT, UINT, LONG) ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     static TCHAR szAppName[] = TEXT ("UniType") ;
     HWND         hwnd ;
     MSG          msg ;
     WNDCLASS     wndclass ;

     if (!hPrevInstance) 
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }
     hwnd = CreateWindow (szAppName, TEXT ("Type Unicode Characters"),
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

long APIENTRY WndProc (HWND hwnd, UINT message, UINT wParam, LONG lParam)
     {
     static CHOOSEFONT cf ;
     static LOGFONT    logfont ;
     static TCHAR      ch ;
     HDC               hdc ;
     PAINTSTRUCT       ps ;
     TCHAR             szBuffer [8] ;

     switch (message)
          {
          case WM_CREATE:
               _tcscpy (logfont.lfFaceName, TEXT ("Lucida Sans Unicode")) ;

               cf.lStructSize      = sizeof (CHOOSEFONT) ;
               cf.hwndOwner        = hwnd ;
               cf.lpLogFont        = &logfont ;
               cf.Flags            = CF_INITTOLOGFONTSTRUCT | CF_EFFECTS |
                                     CF_SCREENFONTS ;
               return 0 ;

          case WM_SIZE:
               logfont.lfHeight = HIWORD (lParam) ;
               return 0 ;

          case WM_COMMAND:
               switch (wParam)
                    {
                    case IDM_FONT:
                         if (ChooseFont (&cf))
                              InvalidateRect (hwnd, NULL, TRUE) ;

                         break ;
                    }
               return 0 ;

          case WM_CHAR:
               ch = (TCHAR) wParam ;
               InvalidateRect (hwnd, NULL, TRUE) ;
               return 0 ;

          case WM_PAINT:
               hdc = BeginPaint (hwnd, &ps) ;

               SetTextAlign (hdc, TA_UPDATECP) ;
               MoveToEx (hdc, 0, 0, NULL) ;

               SelectObject (hdc, CreateFontIndirect (&logfont)) ;
               SetTextColor (hdc, cf.rgbColors) ;

               TextOut (hdc, 0, 0, &ch, 1) ;

               DeleteObject (SelectObject (hdc, GetStockObject (SYSTEM_FONT)));
               _stprintf (szBuffer, TEXT ("%X"), ch) ;

               TextOut (hdc, 0, 0, szBuffer, _tcslen (szBuffer)) ;

               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_DESTROY:
               PostQuitMessage (0) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
