/*----------------------------------------
   UNICHAR.C -- Unicode Character Set
                (c) Charles Petzold, 1993
  ----------------------------------------*/

#include <windows.h>
#include <commdlg.h>
#include <string.h>
#include "unichar.h"

long APIENTRY WndProc (HWND, UINT, UINT, LONG) ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     static   char szAppName[] = "UniChar" ;
     HWND     hwnd ;
     MSG      msg ;
     WNDCLASS wndclass ;

     if (!hPrevInstance) 
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }
     hwnd = CreateWindow (szAppName, "Unicode Character Set",
                          WS_OVERLAPPEDWINDOW | WS_VSCROLL,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

long APIENTRY WndProc (HWND hwnd, UINT message, UINT wParam, LONG lParam)
     {
     static CHOOSEFONT cf ;
     static int        iPos ;
     static LOGFONT    logfont ;
     char              szBuffer [8] ;
     HDC               hdc ;
     int               cxChar, cyChar, x, y, i, cxLabels ;
     PAINTSTRUCT       ps ;
     SIZE              size ;
     TEXTMETRIC        tm ;
     WCHAR             ch ;

     switch (message)
          {
          case WM_CREATE:
               hdc = GetDC (hwnd) ;
               logfont.lfHeight = - GetDeviceCaps (hdc, LOGPIXELSY) / 6 ;
               strcpy (logfont.lfFaceName, "Lucida Sans Unicode") ;
               ReleaseDC (hwnd, hdc) ;

               cf.lStructSize      = sizeof (CHOOSEFONT) ;
               cf.hwndOwner        = hwnd ;
               cf.lpLogFont        = &logfont ;
               cf.Flags            = CF_INITTOLOGFONTSTRUCT | CF_EFFECTS |
                                     CF_SCREENFONTS ;

               SetScrollRange (hwnd, SB_VERT, 0, 255, FALSE) ;
               SetScrollPos   (hwnd, SB_VERT, iPos,   TRUE ) ;
               return 0 ;

          case WM_COMMAND:
               switch (wParam)
                    {
                    case IDM_FONT:
                         if (ChooseFont (&cf))
                              InvalidateRect (hwnd, NULL, TRUE) ;

                         break ;
                    }
               return 0 ;

          case WM_VSCROLL:
               switch (LOWORD (wParam))
                    {
                    case SB_LINEUP:         iPos -=  1 ;  break ;
                    case SB_LINEDOWN:       iPos +=  1 ;  break ;
                    case SB_PAGEUP:         iPos -= 16 ;  break ;
                    case SB_PAGEDOWN:       iPos += 16 ;  break ;
                    case SB_THUMBPOSITION:  iPos = HIWORD (wParam) ;  break ;

                    default:
                         return 0 ;
                    }

               iPos = max (0, min (iPos, 255)) ;

               SetScrollPos (hwnd, SB_VERT, iPos, TRUE) ;
               InvalidateRect (hwnd, NULL, TRUE) ;
               return 0 ;

          case WM_PAINT:
               hdc = BeginPaint (hwnd, &ps) ;

               SelectObject (hdc, CreateFontIndirect (&logfont)) ;
               SetTextColor (hdc, cf.rgbColors) ;

               GetTextMetrics (hdc, &tm) ;
               cxChar = tm.tmMaxCharWidth ;
               cyChar = tm.tmHeight + tm.tmExternalLeading ;

               cxLabels = 0 ;

               for (i = 0 ; i < 16 ; i++)
                    {
                    wsprintf (szBuffer, " 000%1X: ", i) ;
                    GetTextExtentPoint (hdc, szBuffer, 7, &size) ;

                    cxLabels = max (cxLabels, size.cx) ;
                    }

               for (y = 0 ; y < 16 ; y++)
                    {
                    wsprintf (szBuffer, " %03X_: ", 16 * iPos + y) ;
                    TextOut (hdc, 0, y * cyChar, szBuffer, 7) ;

                    for (x = 0 ; x < 16 ; x++)
                         {
                         ch = (WCHAR) (256 * iPos + 16 * y + x) ;
                         TextOutW (hdc, x * cxChar + cxLabels,
                                        y * cyChar, &ch, 1);
                         }
                    }

               DeleteObject (SelectObject (hdc, GetStockObject (SYSTEM_FONT)));
               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_DESTROY:
               PostQuitMessage (0) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
