PROGRAM TestCdr;
{File to test action of CrtLog.  Compile for Windows and
 rename EXE to TESTCDRW.  Compile for (real mode) DOS and
 rename EXE to TESTCDRD.}
USES Strings,
{$IFDEF Windows}
  WinDos, WinCrt, WinProcs, WinTypes;
{$ELSE}
  Dos;
{$ENDIF}
CONST
  DirName        = 'MKDIR.39H';
  NewDirName     = 'RENDIR.56H';
  CreateFileName = 'CREATE.3CH';
  RenameFileName = 'RENAME.56H';
  GetFattrName   = 'GET_ATTR.43H';
  SetFattrName   = 'SET_ATTR.43H';
  GetFTimeName   = 'GET_TIME.57H';
  SetFTimeName   = 'SET_TIME.57H';
  NewFileName    = 'NEW_FILE.5AH';
  ExtFileName    = '\EXT_OPEN.6CH';
VAR
  F, GetAttrFile,
  SetAttrFile,
  GetTimeFile,
  SetTimeFile         : File;
  buff1, buff2, BuffU : ARRAY[0..79] OF Char;
  Att                 : Word;
  Tim                 : LongInt;
BEGIN
  {$IFDEF Windows}
  ScreenSize.X := 50;
  ScreenSize.Y := 32;
  cmdShow := sw_Maximize;
  {$ENDIF}
  WriteLn('TEST PROGRAM for CrtLog');
  WriteLn('-----------------------');
  WriteLn('Every event line in this program''s output window');
  WriteLn('should have a matching line in the CrtLog window');
  WriteLn('EXCEPT lines beginning with an asterisk.');
  WriteLn;
  {$IFNDEF Windows}
  WriteLn('Press Alt+Enter make the program run in a window,');
  WriteLn('then press Enter to continue.');
  ReadLn;
  {$ENDIF}
  WriteLn('Creating directory (39h) ', DirName);
  MkDir(DirName);
  WriteLn('Renaming directory (56h) ', DirName, ' to ', NewDirName);
  StrCopy(buff1, DirName);
  StrCopy(buff2, NewDirName);
  ASM
    MOV AH,56h
    LEA DX,buff1
    PUSH DS
    POP ES
    LEA DI,buff2
    INT 21h
  END;
  ChDir(NewDirName);
  WriteLn('Creating file (3Ch) ', CreateFileName);
  Assign(F, CreateFileName);
  Rewrite(F);
  Close(F);
  WriteLn('Creating file (3Ch) ', GetFAttrName);
  Assign(GetAttrFile, GetFAttrName);
  Rewrite(GetAttrFile);
  Close(GetAttrFile);
  WriteLn('Creating file (3Ch) ', SetFAttrName);
  Assign(SetAttrFile, SetFAttrName);
  Rewrite(SetAttrFile);
  Close(SetAttrFile);
  WriteLn('Creating file (3Ch) ', GetFTimeName);
  Assign(GetTimeFile, GetFTimeName);
  Rewrite(GetTimeFile);
  WriteLn('Creating file (3Ch) ', SetFTimeName);
  Assign(SetTimeFile, SetFTimeName);
  Rewrite(SetTimeFile);
  Write('Creating unique file (5Ah) ');
  ASM
    MOV AH,5Ah
    SUB CX,CX
    LEA DX,BuffU
    INT 21h
    MOV BX,AX
    MOV AH,3Eh
    INT 21h
  END;
  WriteLn(BuffU);
  WriteLn('Creating new file (5Bh) ', NewFileName);
  StrCopy(buff1, NewFileName);
  ASM
    MOV AH,5Bh
    MOV CX,0
    LEA DX,buff1
    INT 21h
    MOV BX,AX
    MOV AH,3Eh
    INT 21h
  END;
  StrCopy(buff1, ExtFileName);
  {$IFNDEF Windows}
  Write('* ');
  {$ENDIF}
  WriteLn('Extended open file (6Ch) ', ExtFileName);
  ASM
    MOV AX,6C00h
    MOV BX,0000000001000010b
    MOV CX,0
    MOV DX,0000000000010010b
    LEA SI,buff1
    INT 21h
    MOV BX,AX
    MOV AH,3Eh
    INT 21h
  END;
  WriteLn('Renaming file (56h) ',
    CreateFileName,' to ', RenameFileName);
  {$I-} Rename(F, RenameFileName); {$I+}
  IF IOresult <> 0 THEN
    WriteLn('*** RENAME FAILED ***');
  {$IFDEF Windows}
  Write('* ');
  {$ENDIF}
  WriteLn('Getting file attributes (43h) of ', GetFAttrName);
  GetFAttr(GetAttrFile, Att);
  Att := 0;
  WriteLn('Setting file attributes (43h)of ', SetFAttrName);
  SetFAttr(SetAttrFile, Att);
  WriteLn('* Getting file time (57h) of ', GetFTimeName);
  GetFTime(GetTimeFile, Tim);
  Close(GetTimeFile);
  Inc(Tim);
  WriteLn('* Setting file time (57h) of ', SetFTimeName);
  SetFTime(SetTimeFile, Tim);
  Close(SetTimeFile);
  WriteLn('Deleting file (41h) ', RenameFileName);
  Erase(F);
  WriteLn('Deleting file (41h) ', GetFAttrName);
  Erase(GetAttrFile);
  WriteLn('Deleting file (41h) ', SetFAttrName);
  Erase(SetAttrFile);
  WriteLn('Deleting file (41h) ', GetFTimeName);
  Erase(GetTimeFile);
  WriteLn('Deleting file (41h) ', SetFTimeName);
  Erase(SetTimeFile);
  WriteLn('Deleting file (41h) ', ExtFileName);
  StrCopy(buff1, ExtFileName);
  ASM
    MOV AH,41h
    LEA DX,buff1
    INT 21h
  END;
  WriteLn('Deleting file (41h) ', NewFileName);
  StrCopy(buff1, NewFileName);
  ASM
    MOV AH,41h
    LEA DX,buff1
    INT 21h
  END;
  WriteLn('Deleting file (41h) ', BuffU);
  ASM
    MOV AH,41h
    LEA DX,BuffU
    INT 21h
  END;
  ChDir('..');
  WriteLn('Removing directory (3Ah) ', NewDirName);
  {$I-} RmDir(NewDirName); {$I+}
  IF IOresult <> 0 THEN
    WriteLn('*** RMDIR FAILED ***');
  Write('Press Enter to quit');
  ReadLn;
  {$IFDEF Windows} DoneWinCrt; {$ENDIF}
END.
