;---------------------------------------------------------------    
;drvinit.asm - Supporting init routines for DRVLOAD Utility    |
;--------------------------------------------------------------|
;DRVLOAD Copyright (c) 1993                                    |
;                                                              |
;Rick Knoblaugh All rights reserved.                           |
;First Appeared in PC MAGAZINE, US Edition,                    |
;November 9, 1993                                              |
;--------------------------------------------------------------|
; 7/04/93                      Rick Knoblaugh                  |
;--------------------------------------------------------------|
;include files                                                 |
;---------------------------------------------------------------    
                include drvequ.inc
                include drvstruc.inc

code            segment public  'CODE'
                assume cs:code, ds:code, es:code
;--------------------------------------------------------------
;Externals                                                    |
;--------------------------------------------------------------

                extrn   driver_file:byte, dos_ver:word
                extrn   driver_p_off:word, drv_stack_ptr:word
;--------------------------------------------------------------
;Publics                                                      |
;--------------------------------------------------------------
                public  get_driver, get_parms 
                public  check_driver, relocate
                public  look_win


;--------------------------------------------------------------
;check_driver - Use DOS find first file function to           |
;               determine if file exists and also get size.   |
;                                                             |
;             Enter:                                          |
;             driver_file=driver name from command line.      |
;                      ds=local data segment                  |
;             Exit:                                           |
;                   dx:ax=size of driver file                 |
;                      CY=set if error accessing driver       |
;                                                             |
;--------------------------------------------------------------
check_driver    proc    near
                xor     cx, cx                  ;normal attributes
                mov     dx, offset driver_file  ;file spec
                mov     ah, DOS_FIND_FIRST 
                int     21h
                jnc     check_dr100             ;if found
                mov     cx, 1                   ;else try read only        
                mov     ah, DOS_FIND_FIRST 
                int     21h
                jc      check_dr999
check_dr100:
                mov     bx, psp_cmd_len         ;default DTA area
                mov     dx, [bx].file_size.d_segment ;get high order portion
                mov     ax, [bx].file_size.d_offset
check_dr999:
                ret
check_driver    endp

;--------------------------------------------------------------
;get_driver   - Attempt to retrieve device driver name from   |
;               command line.                                 |
;                                                             |
;             Enter:                                          |
;                      cx=number of bytes to search           |
;                   ds:si=ptr to string to search             |
;                      es=local data segment                  |
;             Exit:                                           |
;                      cx=bytes remaining in cmd line         |
;                      si=position just after parm            |
;             driver_file=driver name from command line.      |
;                      CY=set if no driver found              |
;            driver_p_off=first byte past driver name         |
;                                                             |
;--------------------------------------------------------------
get_driver      proc    near
                call    skip_white_sp
                jcxz    get_drv_900
                mov     di, offset driver_file
get_drv_100:
                cmp     byte ptr [si], ' '      ;hit the end?
                jbe     get_drv_800
                movsb                           ;move it into our area
                loop    get_drv_100
get_drv_800:
                xor     al, al
                stosb                           ;terminate the string
                mov     cs:driver_p_off, di     ;save end of file name
                mov     al, LF                  ;default to no parms
                stosb
                ret                             ;ret with carry clear
get_drv_900:
                stc                             ;indicate not found
                ret
get_driver      endp

;--------------------------------------------------------------
;get_parms    - Attempt to retrieve device driver parms       |
;               command line.                                 |
;                                                             |
;             Enter:                                          |
;                      cx=number of bytes remaining in cmd    |
;                         line                                |
;                   ds:si=ptr to string                       |
;                      es=local data segment                  |
;            driver_p_off=offset of parm hold buffer          |
;                                                             |
;             Exit:                                           |
;                                                             |
;            drv_cmd_line=driver parms from command line.     |
;                                                             |
;--------------------------------------------------------------
get_parms       proc    near
                jcxz    get_parm_800
                call    skip_white_sp
                jcxz    get_parm_800
                inc     cx                      ;include the CR
                mov     di, cs:driver_p_off
                rep movsb
get_parm_800:

                ret
get_parms       endp

;--------------------------------------------------------------
;look_win  - Determine if we're running in DOS box under      |
;            Windows.                                         |
;                                                             |
;             Enter:                                          |
;                                                             |
;             Exit:                                           |
;                                                             |
;             CY set if Windows present.                      |
;                                                             |
;--------------------------------------------------------------
look_win        proc    near
                mov     ax, 160ah               ;Windows 3.1 check
                int     2fh
                or      ax, ax
                jz      look_w999               ;found
;
;Not running under Windows 3.1.  Look for Windows 3.0
;

                mov     ax, 1600h
                int     2fh
                test    al, 7fh
                jnz     look_w999               ;Windows 3.0 enhanced

                mov     ax, 4680h
                int     2fh
                or      ax, ax
                jz      look_w999               ;Windows 3.0         
                

                clc
                ret
look_w999:
                stc   
                ret
look_win        endp

;--------------------------------------------------------------
;get_cmd_line - look for command line parameters              |
;                                                             |
;             Enter:                                          |
;                      cx=number of bytes to search           |
;                   ds:si=ptr to string to search             |
;                                                             |
;             Exit:                                           |
;                      cx=bytes remaining after switch        |
;                      si=position just after parm            |
;--------------------------------------------------------------
get_cmd_line    proc    near
                jcxz    get_cmd_800
                call    skip_white_sp
get_cmd_800:     
                ret
get_cmd_line    endp

skip_white_sp   proc    near
                cmp     byte ptr [si], ' '
                je      skip_w200
                cmp     byte ptr [si], TAB
                jne     skip_w900

skip_w200:
                inc     si
                loop    skip_white_sp
skip_w900:
                ret
skip_white_sp   endp

;--------------------------------------------------------------
;relocate - Move driver loader up to top of memory.  Change   |
;           segment registers and continue execution at       |
;           line after caller, but everything will now be     |
;           running at the new high memory location.          |
;                                                             |
;             Enter:                                          |
;                      ds=psp segment                         |
;                      bp=target segment                      |
;                      di=size in paragraphs                  |
;             Exit:                                           |
;          cs, ds, es, ss= new segment                        |
;                      sp= new stack ptr                      |
;--------------------------------------------------------------
relocate        proc    near
                pop     ax                      ;return address
                mov     es, bp
                mov     cl, 3
                shl     di, cl
                mov     cx, di                  ;size in words
                xor     si, si
                xor     di, di
                rep     movsw
                cli
                mov     ss, bp                  ;change stack seg
                mov     sp, offset drv_stack_ptr
                sti
                push    bp                      ;segment
                push    ax                      ;offset
                mov     ds, bp
                mov     es, bp
                retf

relocate        endp



code            ends
                end


