;---------------------------------------------------------------    
;drvdata.inc data for DRVLOAD Utility                          |
;--------------------------------------------------------------|
;DRVLOAD Copyright (c) 1993                                    |
;                                                              |
;Rick Knoblaugh All rights reserved.                           |
;First Appeared in PC MAGAZINE, US Edition,                    |
;November 9, 1993                                              |
;--------------------------------------------------------------|
; 7/4/93                       Rick Knoblaugh                  |
;--------------------------------------------------------------|

dos_ver         dw      0               
psp_seg         dw      ?
driver_size     dw      0       ;hold size of driver
cds_ptr         dd      ?       ;ptr to CDS
dpb_ptr         dd      ?       ;ptr to DPB
nul_dev_ptr     dd      ?       ;pointer to NUL device
cds_size        dw      ?       ;sizes of these data areas
dpb_size        dw      ?       ;based on DOS version
dpb_para        dw      ?       ;DPB size in paragraphs
prev_dpb_ptr    dd      ?       ;hold ptr to DPB
drv_head_offset dw      ?       ;hold offset of device driver header        
last_drive      db      ?       ;LASTDRIVE value
max_avail_units db      ?       ;maximum drive letters left
num_blk_devices db      ?       ;number of devices before install

dpb_drv_off     dw      ?       ;DOS ver specific offset for device driver
                                ;header entry in DPB 

dpb_link_off    dw      ?       ;DOS ver specific offset for link to next
                                ;DPB 

num_blk_off     dw      ?       ;DOS ver specific offset for number of
                                ;block devices in list of lists

mem_to_keep     dw      ?       ;# paragraphs of memory requested by driver
over_args       over_lay <>
init_cmd_blk    init_req <>

driver_file     db      (MAX_PATHLEN  + MAX_NAMELEN + 1) dup(0)
driver_parms    db      (MAX_CMD_LINE + 2) dup(0)   ;max plus cr, lf
driver_p_off    dw      offset ?




dos30_ver_off   ver_spec_off <cds_ptr30,dpb_ptr30,nul_dev30,last_drv30>
dos31_ver_off   ver_spec_off <cds_ptr31,dpb_ptr31,nul_dev31,last_drv31>


nodriver_msg    db      "Device driver must be specified", CR, LF, BEEP, DOS_STR_TERM
invalid_dos_msg db      "DRVLOAD requires DOS 3.0 or later", CR, LF, BEEP, DOS_STR_TERM
no_win_msg      db      "DRVLOAD can't be used under Windows", CR, LF, BEEP, DOS_STR_TERM
cant_open_msg   db      "Device driver not found", CR, LF, BEEP, DOS_STR_TERM
too_big_msg     db      "Driver too large to load", CR, LF, BEEP, DOS_STR_TERM
no_drives_msg   db      "No drive letter available for block driver.  Use the LASTDRIVE", CR, LF, \
                        "statement in CONFIG.SYS (e.g. LASTDRIVE=G).", CR, LF, BEEP, DOS_STR_TERM
corrupt_msg     db      "DOS internal data bad.", CR, LF, BEEP, DOS_STR_TERM
warning_msg     db      "Fatal error finishing processing", CR, LF, "Reboot you computer immediately!", \
                        CR, LF, DOS_STR_TERM
err_load_msg    db      "Error loading driver", CR, LF, BEEP, DOS_STR_TERM
init_fail_msg   db      "Driver initialization failed.", CR, LF, BEEP, DOS_STR_TERM
bad_drv_msg     db      "Not a valid driver", CR, LF, BEEP, DOS_STR_TERM
tsr_ok_msg      db      "Driver successfully installed.", CR, LF, DOS_STR_TERM

units_msg       db      "Not enough drive letters available to accommodate", CR, LF,  \
                        "number of units supported by device driver.  Use the", CR, LF,  \
                        "LASTDRIVE statement in CONFIG.SYS (e.g. LASTDRIVE=G).", CR, LF, BEEP, DOS_STR_TERM

sign_on_msg     db      CR, LF,"DRVLOAD Version 1.0  Copyright (c) 1993", CR, LF, \
                        "Rick Knoblaugh  All rights reserved.", CR, LF, \
                        "First Appeared in PC MAGAZINE, US Edition,", CR, LF, \                  
                        "November 9, 1993", CR, LF, CR, LF, DOS_STR_TERM

;------end of drvdata.inc
