{$X+,V-}
UNIT Meter;
(**) INTERFACE (**)
USES Dialogs, Drivers, Objects, Views;
TYPE
  PMeter = ^TMeter;
  TMeter = OBJECT(TView)
    low, high,  (* low and high limit of values     *)
    meterlen,   (* length of the meter display      *)
    currperc,   (* current percentage of completion *)
    currfilled, (* currently filled boxes           *)
    TxColor,    (* Colors for Text and Meter        *)
    MtColor    : WORD;
    theMsg     : PString; (* string to display w/ meter *)
    (* constructor initializes the meter control and
       sets low/high values and the message; warning:
       the rectangle 'R' needs to be exactly 2 rows
       high and at least 10 columns wide *)
    CONSTRUCTOR Init(R : TRect; Message : STRING;
                      lowbound, highbound : WORD);
    DESTRUCTOR  Done; VIRTUAL;
    PROCEDURE Draw; VIRTUAL;
    (* set a given value to be used in the display;
       the meter control calculates the current percentage
       and the number of boxes to be filled and redraws
       the control, if there's been a change *)
    PROCEDURE SetValue(value: WORD);
        (* set the colors for the text and meter control *)
    PROCEDURE SetColor(TextColor, MeterColor : WORD);
  END;
(**) IMPLEMENTATION (**)
CONSTRUCTOR TMeter.Init(R : TRect; Message : STRING;
                         lowbound, highbound : WORD);
BEGIN
  (* check if rectangle is big enough to hold meter control *)
  IF(R.B.Y - R.A.Y <> 2) OR (R.B.X - R.A.X < 10) THEN FAIL;
  TView.Init(R);
  Options    := Options AND (NOT ofSelectable) AND (NOT ofTileable)
                        AND (NOT ofFramed);
  GrowMode   := 0;
  State      := State AND NOT sfShadow;
  (* calculate meter length and set default values *)
  meterlen   := R.B.X - R.A.X - 1;
  currfilled := 0;
  currperc   := 0;
  low        := lowbound;
  high       := highbound;
  (* initialize message *)
  theMsg     := NewStr(Message);
  (* get default colors *)
  TxColor := $70;
  MtColor := $7F;
END;

DESTRUCTOR TMeter.Done;
BEGIN
  DisposeStr(theMsg);
  TView.Done;
END;

PROCEDURE TMeter.Draw;
 (* Draw method; fills two string buffers, one
   with the message and the currently achieved
   percentage, the other one with the actual meter
   with partly unfulfilled and partly filled "boxes" *)
VAR
  percstr : STRING;
  B       : TDrawBuffer;
BEGIN
  (* fill first string buffer *)
  MoveChar(B, ' ', TxColor, Size.X);
  MoveStr(B[1], TheMsg^, TxColor);
  Str(currperc:3, percstr);
  MoveStr(B[meterlen-3], percstr, TxColor);
  MoveStr(B[meterlen], '%', TxColor);
  WriteLine(0, 0, Size.X, 1, B);
  (* fill second string buffer *)
  MoveChar(B, ' ', TxColor, Size.X);
  IF currfilled <= meterlen THEN
    BEGIN
      MoveChar(B[1], #219, MtColor, currfilled);
      MoveChar(B[currfilled+1], #176, MtColor,
        meterlen-currfilled+1);
    END
  ELSE MoveChar(B[1], #219, MtColor, meterlen);
  WriteLine(0, 1, Size.X, 1, B);
END;

PROCEDURE TMeter.SetValue(value: WORD);
 (* set the new value; we then calculate the new
   percentage and number of filled boxes to be
   drawn, and redraw the view *)
VAR perc : REAL;
BEGIN
  IF (value < low) OR (value > high) THEN Exit;
  perc := (value-low)/(high - low);
  currperc := WORD(Round(perc*100.0));
  currfilled := WORD(Round(perc*meterlen));
  DrawView;
END;

PROCEDURE TMeter.SetColor(TextColor, MeterColor : WORD);
BEGIN
  TxColor := TextColor;
  MtColor := MeterColor;
END;

END.
