/* Program to see what mode PC Timer/Counters are in and set Timer0 to mode 3 */
/* Run this program before running Poor Man's Packet, or Pktmon12 */
/* Note: Some motherboards boot up in Timer0 mode 2, and won't work */
/* with the above programs unless this program is run first, because */
/* mode 2 count slows down about twice as much as mode 3 when read on-the-fly */
/* Jim Olson, KM6PI 03/18/95 */
#include <dos.h>
#include <stdio.h>

unsigned char result0,result1,result2,m0,m1,m2;
void modechk(void)
{
  outportb(0x43,0xEE); /* Latch status of counters */
  result0 = inportb(0x40); /* Read in status of timer 0 */
  result1 = inportb(0x41); /* Read in status of timer 1 */
  result2 = inportb(0x42); /* Read in status of timer 2 */
  m0 = (result0 & 0x0E)/2; /* mask off mode bits and convert to a number */
  m1 = (result1 & 0x0E)/2;
  m2 = (result2 & 0x0E)/2;
  printf("status byte of Timer0: %XH. Timer1: %XH. Timer2: %XH.\n",
	result0,result1,result2);
  printf("Timer0 mode: %X. Timer1 mode: %X. Timer2 mode: %X.\n",m0,m1,m2);
}
void main(void)
{
  printf("\nOld ");
  modechk();
  if(m0 != 3)
  {
  outportb(0x43,0x36); /* Program timer 0 for mode 3 */
  outportb(0x40,0x0); /* 0000 sets maximum count */
  outportb(0x40,0x0);
  printf("\nNew ");
  modechk();
  if(m0 == 3)
    {
    printf("\nTimer0 was changed to mode 3.\n");
    }
    else
    {
    printf("\nError, cannot change Timer0 to mode 3.");
    printf("\nProgram won't work from a DOS Shell.\n");
    }
  }
  else
  {
  printf("\n Timer0 is already in mode 3 ... no changes made.\n");
  }
}
