
/*
 *  MBCONV.C - 9/19/87 Mail and User file conversion.
 */

#include "mb.h"

/*
 *  Message header record.
 */

#define o_m_read   0x01  /* Message has been read by recipient	  */
#define o_m_fwd    0x02  /* Message has been forwarded		  */

#define o_mhtitl 80	 /* Length of title. */

typedef struct o_m_s
{
  word next;	      /* Next message header record			 */
  word prev;	      /* Previous message header record 		 */
  word ext;	      /* Header extension record, or zero		 */
  word number;	      /* Message number 				 */
  word size;	      /* Size in bytes					 */
  char type;	      /* Message type					 */
  byte stat;	      /* Message status, see bit definitions above	 */
  char to  [ln_call]; /* Destination call				 */
  char from[ln_call]; /* Originator call				 */
  char date[ln_date]; /* Entry date					 */
  char time[ln_time]; /* Entry time					 */
  word rn;	      /* Record number of this record			 */
  word read;	      /* # times the message has been read		 */
  word unu3;	      /* Available					 */
  char bbs [ln_call]; /* Destination BBS, or distribution list		 */
  word unu2;	      /* Available					 */
  char title[o_mhtitl];
} O_M;

/*
 *  Message header extension item.
 */

#define ommesn 17  /* Max calls in distribution list */

typedef struct o_m_ext_s
{
  word next;		     /* Next extension item, or free item   */
  char call[ommesn][ln_call]; /* Calls to send it to		     */
  byte flag[ommesn];	      /* TRUE if need to send, FALSE if sent */
  byte count;		     /* Number of calls in list 	    */
  word unu1;
  word unu2;
  word unu3;
} O_M_EXT;

/*
 *  Mail file header record.
 */

typedef struct o_m_hdr_s
{
  word next;	      /* Next record to allocate	 */
  word first;	      /* First message header record	 */
  word last;	      /* Last message header record	 */
  word ffree;	      /* First record in free chain	 */
  word lfree;	      /* Last record in free chain	 */
  word next_msg;      /* Next message number		 */
  byte version;       /* File format version number	 */
  word free;	      /* Number of records in free chain */
  word count;	      /* Number of messages		 */
  char date[ln_date]; /* Date of last untangle		 */
  char time[ln_time]; /* Time of last untangle		 */
  word unt_msg;       /* next_msg at last untangle	 */
  char unused[99];
} O_M_HDR;

/*
 *  User file header record.
 */

typedef struct o_u_hdr_s
{
  word count;	      /* Number of users in file	 */
  char version;       /* File version			 */
  char date[ln_date]; /* Date of last compress		 */
  char time[ln_time]; /* Time of last compress		 */
  word lmnr;	      /* Last message # at last compress */
  char dirty;	      /* True if anything changed	 */
  char wpdate[ln_date];
  char free[106];     /* Ain't used at all, yet          */
} O_U_HDR;

/*
 *  User file user record.
 */

/*
 *  User record options.
 */

#define o_u_local    0x01
#define o_u_bbs      0x02
#define o_u_expert   0x04
#define o_u_delete   0x08
#define o_u_sysop    0x10
#define o_u_exclude  0x20

/*
 *  User record state.
 */

#define o_u_sent     0x01
#define o_u_name     0x02
#define o_u_home     0x04

#define o_pathl 81

typedef struct o_u_s
{
  char call[ln_call];	  /* Users call 			 */
  char date[ln_date];	  /* Date of last logout		 */
  char time[ln_time];	  /* Time of last logout		 */
  word msg_number;	  /* Last message # at last login	 */
  byte ssid;		  /* First character of ssid		 */
  byte state;		  /* Got name? Got home? Sent to WP?	 */
  char handle[ln_handle]; /* Users name 			 */
  byte options; 	  /* Permissions and stuff like that	 */
  char port;		  /* Port user last connected, L if link */
  char path[o_pathl];	    /* NULL terminated string		   */
  word log_count;	  /* Number of times user has connected  */
  char home_bbs[ln_call]; /* Users home bbs			 */
  word rn;		  /* Record number, zero if not valid	 */
  char unu2[3];
} O_U;

char *mbfile, *mbbfile, *msgdir;
int mfl, mflb;

char *ufwd, *bfwd;
short ufwdm, ufwdn, bfwdm, bfwdn;
char wpcall[ln_call];

/*
 *  Prompts associated with message commands.
 */

char *mm[num_mm];

MAIL_HDR *mfhs;
MSG_HDR  *mmhs;
MSG_EXT  *mmes;

char  *usfile, *usbfile;
int    ufl, uflb;
char tcall[ln_call];  /* Used all over as temp */

USER_HDR *ufhs;
USER	 *tuser;

char *um[num_um];


main(argc, argv)
int argc;
char *argv[];
{
  convmsg();

  convuser();
}

/*
 *  Copy LJSF string to C string.
 */

unbl(to, from, size)
char *to, *from;
int size;
{
  while (size--)
  {
    if (*from <= ' ') { *to = '\0'; return; }
    *to++ = *from++;
  }
  *to = '\0';
}

/*
 *  Remove new line from end of string.
 */

remnl(p)
char *p;
{
  for (; *p; p++) if (*p is '\n') { *p = '\0'; return; }
}

/*
 *  Fill some memory with a character.
 */

fill(adr, ch, len)
char *adr;
char ch;
int len;
{
  while (len--) *adr++ = ch;
}

convmsg()
{
  register word i;
  register char *p;

  O_M_HDR  *omfhs;
  O_M	   *ommhs;
  O_M_EXT  *ommes;

  O_U_HDR  *oufhs;
  O_U	   *otuser;

/*
 *  Allocate space for the mail file records.
 */

  omfhs = (O_M_HDR *)  malloc(sizeof(O_M_HDR));
  ommhs = (O_M *)      malloc(sizeof(O_M));
  ommes = (O_M_EXT *)  malloc(sizeof(O_M_EXT));

  mfhs	= (MAIL_HDR *) malloc(sizeof(MAIL_HDR));
  mmhs	= (MSG_HDR *)  malloc(sizeof(MSG_HDR));
  mmes	= (MSG_EXT *)  malloc(sizeof(MSG_EXT));

  if ((mflb = open("MAIL.DAT", O_RDONLY | O_BINARY)) < 0)
  {
    printf("MAIL.DAT not found.\n");
    return;
  }

/*
 *  Read the mail file header.
 */

  read128(mflb, 0, (char *)omfhs);

  if ((omfhs->version < 1) or (omfhs->version > 7))
  {
    printf("MAIL.DAT is version %d, unrecognized version.\n", omfhs->version);
    return;
  }

  printf("Creating the new message file MAIL.NEW\n");

  mfl = open("MAIL.NEW", O_CREAT | O_RDWR | O_BINARY, pmode);

  printf("%d messages in MAIL.DAT\n", omfhs->count);

/*
 *  Convert the file header record.
 */

  fill(mfhs, '\0', 256);

  mfhs->next	 = omfhs->next;
  mfhs->first	 = omfhs->first;
  mfhs->last	 = omfhs->last;
  mfhs->ffree	 = omfhs->ffree;
  mfhs->lfree	 = omfhs->lfree;
  mfhs->next_msg = omfhs->next_msg;
  mfhs->version  = mb_version;
  mfhs->free	 = omfhs->free;
  mfhs->count	 = omfhs->count;
  mfhs->unt_msg  = omfhs->unt_msg;

  strncpy(mfhs->date, omfhs->date, ln_date);
  strncpy(mfhs->time, omfhs->time, ln_time);

/*
 *  Write the V8 file header.
 */

  write256(mfl, 0, (char *)mfhs);

/*
 *  Convert the free record chain (lazy ...)
 */

  for (i = omfhs->ffree; i; i = ommhs->next)
  {
    read128(mflb, i, (char *)ommhs);
    fill(mmhs, '\0', 256);
    mmhs->next = ommhs->next;
    write256(mfl, i, (char *)mmhs);
  }

/*
 *  Convert the message headers.
 */

  for (i = omfhs->first; i; i = ommhs->next)
  {
    read128(mflb, i, (char *)ommhs);
    printf("%5u %5u %5u %6.6s %6.6s\n",
      i, ommhs->rn, ommhs->number, ommhs->to, ommhs->from);
/*
 *  First bring the old message header record up to V 7.
 */

    if (omfhs->version < 3) remnl(ommhs->title);

    if (omfhs->version < 4)
    {
      ommhs->ext = 0;
      switch (ommhs->stat)
      {
	case 'F' : ommhs->stat = m_fwd;  break;
	case 'N' : ommhs->stat = 0;      break;
	case 'Y' : ommhs->stat = m_read; break;
      }
    }

    if (omfhs->version < 6)
    {
      ommhs->next = ommhs->ext;
      ommhs->prev = ommhs->unu3;
      ommhs->ext  = ommhs->unu2;
    }

    if (omfhs->version < 7) ommhs->rn = i;

/*
 *  Now build the V8 record.
 */

    fill(mmhs, '\0', 256);

    mmhs->next	 = ommhs->next;
    mmhs->prev	 = ommhs->prev;
    mmhs->ext	 = ommhs->ext;
    mmhs->number = ommhs->number;
    mmhs->size	 = ommhs->size;
    mmhs->type	 = ommhs->type;
    mmhs->stat	 = ommhs->stat;
    mmhs->rn	 = ommhs->rn;
    mmhs->read	 = ommhs->read;

    strncpy(mmhs->to,	   ommhs->to,	ln_call);
    strncpy(mmhs->from,    ommhs->from, ln_call);
    strncpy(mmhs->bbs,	   ommhs->bbs,	ln_call);
    strncpy(mmhs->date,  ommhs->date, ln_date);
    strncpy(mmhs->time,  ommhs->time, ln_time);

    fill(mmhs->bid, ' ', 12);

    strcpy(mmhs->title, ommhs->title);

/*
 *  Write the new record in the new file.
 */

    write256(mfl, i, (char *)mmhs);

/*
 *  Convert the header extension record, if there is one.
 */

    if (mmhs->ext)
    {
      read128(mflb, mmhs->ext, (char *)ommes);
      mmes->next = ommes->next; 		/* Next extension item, or free item   */
      for (i = 0; i < ommes->count; i++)
      {
	strncpy(mmes->call[i], ommes->call[i], ln_call); /* Calls to send it to 		*/
	mmes->flag[i] = ommes->flag[i]; 	 /* TRUE if need to send, FALSE if sent */
      }
      mmes->count = ommes->count;		 /* Number of calls in list		*/
      write256(mfl, mmhs->ext, (char *)mmes);
    }
  }
  close (mfl);
  close (mflb);


  printf("Deleting the old mail file MAIL.DAT\n");
  unlink("MAIL.DAT");
  printf("Renaming MAIL.NEW to MAIL.DAT\n");
  rename("MAIL.NEW", "MAIL.DAT");
}

/*
 *  Now do the user file.
 */

convuser()
{
  register int i;

  O_U_HDR  *oufhs;
  O_U	   *otuser;

/*
 *  Allocate space for the user file records.
 */

  oufhs  = (O_U_HDR *)	malloc(sizeof(O_U_HDR));
  otuser = (O_U *)	malloc(sizeof(O_U));

  ufhs	 = (USER_HDR *) malloc(sizeof(USER_HDR));
  tuser  = (USER *)	malloc(sizeof(USER));

  if ((uflb = open ("USER.DAT", O_RDONLY | O_BINARY)) < 0)
  {
    printf("USER.DAT not found.\n");
    return;
  }

/*
 *  Read the old user file header.
 */

  read128(uflb, 0, (char *)oufhs);
  if ((oufhs->version < 1) or (oufhs->version > 7))
  {
    printf("USER.DAT is version %d, unrecognized version.\n", oufhs->version);
    return;
  }

  printf("%d users in USER.DAT\n", oufhs->count);

  printf("Creating the new user file USER.NEW\n");

  ufl = open("USER.NEW", O_CREAT | O_RDWR | O_BINARY, pmode);

/*
 *  Update the file header to V8
 */

  fill(ufhs, '\0', 256);

  ufhs->count	= oufhs->count;
  ufhs->version = us_version;
  ufhs->lmnr	= oufhs->lmnr;
  ufhs->dirty	= false;

  strncpy(ufhs->date,	oufhs->date,   ln_date);
  strncpy(ufhs->time,	oufhs->time,   ln_time);
  strncpy(ufhs->wpdate, oufhs->wpdate, ln_date);

/*
 *  Write the new file header.
 */

  write256(ufl, 0, (char *)ufhs);

/*
 *  Read each user record and update.
 */

  for (i = 1; i <= oufhs->count; i++)
  {
    read128(uflb, i, (char *)otuser);

/*
 *  First bring the record up to V8
 */

    if (oufhs->version < 6) remnl(otuser->path);
    if (oufhs->version < 7) otuser->ssid = otuser->ssid - '0';

/*
 *  Build the V8 user record.
 */

  fill(tuser, '\0', 256);

  tuser->msg_number = otuser->msg_number;
  tuser->ssid	    = otuser->ssid;
  tuser->state	    = otuser->state;
  tuser->options    = otuser->options;
  tuser->port	    = otuser->port;
  tuser->log_count  = otuser->log_count;
  tuser->rn	    = otuser->rn;

  strncpy(tuser->call,	   otuser->call,     ln_call);
  strncpy(tuser->handle,   otuser->handle,   ln_handle);
  strncpy(tuser->home_bbs, otuser->home_bbs, ln_call);
  strncpy(tuser->date, otuser->date, ln_date);
  strncpy(tuser->time, otuser->time, ln_time);

  strcpy(tuser->path,  otuser->path);

/*
 *  Write the V8 record to the new user file.
 */
    write256(ufl, i, (char *)tuser);
  }

  close (ufl);
  close (uflb);

  printf("Deleting the old user file USER.DAT\n");
  unlink("USER.DAT");
  printf("Renaming USER.NEW to USER.DAT\n");
  rename("USER.NEW", "USER.DAT");
}

/*
 *  Read random 128 byte record.
 */

read128(fid, rec, buf)
int  fid;
word rec;
char *buf;
{
  long lseek();
  long offs;

  offs = (long)rec * 128l;
  lseek(fid, offs, 0);
  return (read(fid, buf, 128) is 128);
}

/*
 *  Write random 256 byte record.
 */

write256(fid, rec, buf)
int  fid;
word rec;
char *buf;
{
  long lseek();
  long offs;

  offs = (long)rec * 256l;
  lseek(fid, offs, 0);
  return (write(fid, buf, 256) is 256);
}
