;  HAND.ASM  10/26/88

;  Manager for common share of data between mailboxes.

;  Call with port number (15) in DL.
;  Flags are sent or returned in AH.
;  Commands are sent and returned in BX.


everything SEGMENT PUBLIC

      ASSUME CS: everything           ; These assumptions are for the
      ASSUME DS: everything           ; assembler's benefit.  The code
      ASSUME ES: nothing              ; jerks things around as it pleases
      ASSUME SS: nothing

; Program start and buffer declares

          ORG     100H
foo:      JMP     start               ; Entry point


; Area where things are declared

comnumber  db     15                  ; Comm number - Port P
portflag   db     0
cmdflag    db     0                   ; Command flag
busyflag   db     0                   ; Busy flag
command    dw     0

; Static variables

old_bios_vector   dw  ?               ; Save previous interrupt vector
                  dw  ?

; Our BIOS handler

rsint:

        ASSUME DS: NOTHING         ; Don't use DS
        ASSUME ES: NOTHING         ; Don't use ES
        ASSUME SS: NOTHING         ; Don't use SS

; See if this is our vector.

        push    bp
        cmp     dl,cs:comnumber     ; Source port?
        je      ours                ; Yes...

;  Source port not found. Call next handler

        pop     bp
        jmp     cs:dword ptr old_bios_vector

ours:
        push    cx
        push    dx

        or      ah,ah               ; 0
        je      init_jmp            ; Initialize.

        dec     ah
        dec     ah
        dec     ah
        dec     ah                  ; 4
        jz      inquiry_jmp         ; Inquiry?

        dec     ah
        dec     ah
        dec     ah
        dec     ah                  ; 8
        jz      fuct_8_jmp              ; Set busy.

        dec     ah                  ; 9
        jz      fuct_9_jmp              ; Clear busy.

        dec     ah                  ; 10
        jz      fuct_10             ; Put portflag.

        dec     ah                  ; 11
        jz      fuct_11             ; Put cmdflag.

        dec     ah                  ; 12
        jz      fuct_12             ; Get portflag.

        dec     ah                  ; 13
        jz      fuct_13             ; Get cmdflag

        dec     ah                  ; 14
        jz      fuct_14             ; Get Command.

        dec     ah                  ; 15
        jz      fuct_15             ; Put Command.

        jmp     fuct_exit           ; Unknown function, ignore.

init_jmp:
        jmp     init

inquiry_jmp:
        jmp     inquiry

fuct_8_jmp:
        jmp     fuct_8

fuct_9_jmp:
        jmp     fuct_9


;  Call with DL = port number. Fill portflag with AL.

fuct_8:
        or      busyflag,al           ; Set busy flag.
        jmp     fuct_exit

fuct_9:
        xor     al,11111111B          ; Complement al.
        and     busyflag,al           ; Clear busy flag.
        jmp     fuct_exit

fuct_10:
        mov     portflag,al            ; Into portflag
        jmp     fuct_exit


;  Call with DL = port number. Fill cmd flag with BL.

fuct_11:
        mov     cmdflag,bl            ; Into cmdflag.
        jmp     fuct_exit


;  Call with DL = port number. Return portflag in AL.

fuct_12:
        mov     al,portflag            ; portflag out.
        jmp     fuct_exit


;  Call with DL = port number. Return cmd-busy flag in BX.

fuct_13:
        mov     bl,cmdflag            ; cmdflag out.
        mov     bh,busyflag           ; busyflag out.
        jmp     fuct_exit

fuct_14:
        mov     bx,command            ; Get command.
        jmp     fuct_exit

fuct_15:
        mov     command,bx            ; Put command.
        jmp     fuct_exit


;  Reset flags to zero.

init:
        mov     ax,0
        mov     portflag,al         ; Set flag1 to zero.
        mov     busyflag,al         ; Set busyflag to zero.
        mov     cmdflag,al          ; Set flag2 to zero.
        mov     command,ax          ; Set command to zero.
        jmp     fuct_exit


;  Return AA55H in ax - To tell if driver is loaded.

inquiry:
        mov     ax,0AA55h
        jmp     fuct_exit

; Interrupt exit.

fuct_exit:

        pop     dx                  ; Restore registers.
        pop     cx
        pop     bp
        sti                         ; Turn interrupts back on
        iret                        ;      and leave

program_end:


; Main line to initialize.

      ASSUME DS: everything

; Constants only needed by initialization

cr      equ     0dh
lf      equ     0ah

hello   db      cr,lf
        db      'HAND device driver 1.3, OCTOBER 26, 1988', cr, lf, '$'

bye     db      cr,lf
        db      'Driver Installed OK.',cr,lf,'$'

loaded  db      'Already Loaded.', cr, lf, '$'

; Initialize routine

start:  mov     ax,cs                 ; Point DS in the right place
        mov     ds,ax

        lea     dx,hello              ; Print signon message
        mov     ah,9
        int     21h

        mov     dx,15                 ; Check to see if support already loaded
        mov     ah,04
        int     14h
        cmp     ax,0AA55h
        jz      exit                  ; Must be loaded

; Now snatch the BIOS comm vector  (Int 14)

        mov     al,14h
        mov     ah,35h
        int     21h
        mov     old_bios_vector,BX     ;      save old vector
        mov     old_bios_vector+2,ES

        mov     dx,offset rsint         ; Replace with our vector
        mov     al,14h
        mov     ah,25h
        int     21h


        lea     dx,bye                 ; Print signoff message
        mov     ah,9
        int     21h

        mov     al,0                   ; set exit code
        mov     dx,offset program_end
        mov     cl,4
        shr     dx,cl
        inc     dx
        mov     ah,31h
        int     21h                    ; Terminate but stay resident

exit:   lea     dx,loaded
        mov     ah,9
        int     21h
        mov     al,0                   ; set exit code = Ok
        mov     ah,4ch
        int     21h                    ; Terminate and return


everything ENDS

        END foo
