#include "userinfo.h"

void getspaceused(int);

void main(int argc, char *argv[])
{  int numgroups, loop, servercount, serversattached, loop2;

  clrscr();
  initmainnwcalls();
  strcpy(searchObjectName,strupr(argv[1]));
  if (argc == 1)
	{  clrscr();
	   printf("\nUSERINFO: Return group and login information on a user.");
	   printf("\n\nSyntax: userinfo USERNAME");
	   printf("\nUSERNAME is a valid user on the network, otherwise NOT FOUND");
	   printf("\nis returned, along with a list of similar user names, if any.");
	   printf("\nUserinfo will return: ");
	   printf("\nSERVER NAME, date/time of last login, and group info.");
	}
  else
	{  printf("Scanning for servers. . .");
	   servercount = scanforservers();
	   for (loop=0;loop<=servercount;loop++)
		 serversattached = getserverinfo(loop);
	   printf("\nNumber of servers to scan: %d\tUser: %s",serversattached,searchObjectName);
	   printf("\nServer        Date      Time      Groups");
	   printf("\n------      --------  --------    ------");
	   for (loop=0;loop<serversattached;loop++)
		 {  if ((getuserinfo(serverinfo[loop].yourconnHandle)) == 1)
			  {  if ((propertyValue[57]+ propertyValue[58]+ propertyValue[56]+
					 propertyValue[59]+ propertyValue[60]+ propertyValue[61]) != 0)
				   {  printf("\n%-10s  %02d/%02d/%02d  %02d:%02d:%02d ",serverinfo[loop].name,
							  propertyValue[57],propertyValue[58],propertyValue[56],propertyValue[59],propertyValue[60],propertyValue[61]);
					  numgroups = getgroupinfo(serverinfo[loop].yourconnHandle);
					  for (loop2=0;loop2<=numgroups;loop2++)
						printf("%s  ",thegroups[loop2].group);
				   } // if
				 else
				   {    printf("\n%-10s      Never logged in  ",serverinfo[loop].name);
						numgroups = getgroupinfo(serverinfo[loop].yourconnHandle);
						for (loop2=0;loop2<=numgroups;loop2++)
						  printf("%s  ",thegroups[loop2].group);
				   } // else
			  } // if
			else
			  {  printf("\n%-10s  NOT FOUND",serverinfo[loop].name);
				 scanforusers(serverinfo[loop].yourconnHandle);
			  }
		 } // for
	   getspaceused(serversattached);
	} // else
} // main

// Get information on a user
int getuserinfo(NWCONN_HANDLE chandle)
{ int dataSetIndex = 1;
  char objectName[48], buff[48], searchPropertyName[16], propertyName[16];
  char propertyFlags, propertySecurity,propertyHasValue, moreProperties;
  NWOBJ_TYPE searchObjectType, objectType;
  NWFLAGS hasPropertiesFlag, objectFlag, objectSecurity, objectHasProperties;
  BYTE moreSegments;
  NWOBJ_ID objectID = -1;
  long sequenceNumber = -1;
  int FOUNDUSER = 0;
  WORD nwrc;

  searchObjectType = OT_USER;
  strcpy(searchPropertyName,"LOGIN_CONTROL");

  if (! NWScanObject(chandle,searchObjectName,searchObjectType,&objectID,
	objectName,&objectType,&objectHasProperties,&objectFlag,&objectSecurity))
	{ FOUNDUSER = 1;
	  if (objectHasProperties)
		{  sequenceNumber = -1;
		   if (! NWScanProperty(chandle,objectName,objectType,searchPropertyName,&sequenceNumber,
				 propertyName,&propertyFlags,&propertySecurity,&propertyHasValue,&moreProperties))
		   if ((strcmp(propertyName,"LOGIN_CONTROL")) == 0)
			 if (propertyHasValue)
			   NWReadPropertyValue(chandle,objectName,objectType,propertyName,dataSetIndex,propertyValue,&moreSegments,&propertyFlags);
		} /* if */
	} /* while */
  userid = NWLongSwap(objectID);
  if (FOUNDUSER == 0)
	return(0);
  else
	return(1);
} //getuserinfo

// Scan for usernames
void scanforusers(NWCONN_HANDLE chandle)
{
  char objectName[48], searchName[48];
  NWOBJ_TYPE searchObjectType, objectType;
  NWFLAGS objectFlag, objectSecurity, objectHasProperties;
  NWOBJ_ID objectID = -1;

  searchObjectType = OT_USER;
  strcpy(searchName,searchObjectName);
  strncat(searchName,"*",2);

  printf("  Scanning:");
  while (!(NWScanObject(chandle,searchName,searchObjectType,&objectID,
	objectName,&objectType,&objectHasProperties,&objectFlag,&objectSecurity)))
	printf("  %s",objectName);

} // scanforusers

int getgroupinfo(NWCONN_HANDLE chandle)
//Get the groups a user is a member of
{ int groupcounter = 1, dataSetIndex, J, I, rc;
  char objectName[48], buff[48], searchPropertyName[16], propertyName[16];
  char propertyFlags, propertySecurity,propertyHasValue, moreProperties;
  NWOBJ_TYPE searchObjectType, objectType;
  NWFLAGS hasPropertiesFlag, objectFlag, objectSecurity, objectHasProperties;
  BYTE propertyValue[128], moreSegments;
  NWOBJ_ID objectID = -1;
  long id2, sequenceNumber = -1;
  NWOBJ_TYPE tmpType;

  searchObjectType = OT_USER;

 while (! NWScanObject(chandle,searchObjectName,searchObjectType,&objectID,objectName,&objectType,
			   &objectHasProperties,&objectFlag,&objectSecurity))
  {
	   if (objectHasProperties)
		{
		  sequenceNumber = -1;
		  strcpy(searchPropertyName,"*");
		  while (! NWScanProperty(chandle,objectName,objectType,searchPropertyName,&sequenceNumber,
			   propertyName,&propertyFlags,&propertySecurity,&propertyHasValue,&moreProperties))
				 {  if (((strcmp(propertyName,"GROUPS_I'M_IN")) == 0) ||
						 (strcmp(propertyName,"IDENTIFICATION") == 0))
					  {  if (propertyHasValue)
						   {  dataSetIndex = 1;
				  do {
					  if (! (rc = NWReadPropertyValue(chandle,objectName,objectType,propertyName,dataSetIndex,propertyValue,&moreSegments,&propertyFlags)))
						  {
						  if ((strcmp(propertyName,"IDENTIFICATION") == 0) || (strcmp(propertyName,"HOMEDIRPATH") == 0))
							 strcpy(fullname,propertyValue);
						  else
							 if (propertyFlags & 2)
							  {
								 for (J = 0, I = 0; I < 32; I++)
								  {
									id2 = *(long *)&propertyValue[I * 4];
									if (id2)
									 {
										rc = NWGetObjectName(chandle,id2,buff,&tmpType);
										if (rc != 0x0000)
										  {  printf(buff,"NWGetObjectName failed: %x\n",rc);
											  buff[0]= NULL;
										  }

									  strcpy(thegroups[groupcounter].group,buff);groupcounter++;
									  if (++J > 2)
										{
										  J = 0;
										} // if
									 } // if
								  } // for
							  }  // if
						  else
							{
							  for (J = 0, I = 0; I < 128; I++)
								{
								  printf("%02x ",propertyValue[I]);
								  if (++J > 15)
									{
									  J = 0;
									}
								} // for
							 } // else
						 dataSetIndex++;    // advance for next set
						 } /* if */
					  } /* do */
				  while (moreSegments && !rc);
				  } /* if */
			  } /* while */
		  } /* if */
	  } /* while */
  }
  return(groupcounter);
} //getgroupinfo

int scanforservers()
//scan the bindery for other servers
 {  int binerror = 0, counter=0;
	WORD nwrc;
	char searchName[48], objectName[48];
	NWOBJ_TYPE searchType = OT_FILE_SERVER, objectType;
	NWOBJ_ID objectID = -1;
	NWFLAGS hasPropertiesFlag, objectFlags, objectSecurity;

	strcpy(searchName,"*");
	while (binerror == 0)
	  {  nwrc = (NWScanObject(connHandle, (char NWFAR *)searchName, searchType, (NWOBJ_ID NWFAR *)&objectID,
			(char NWFAR *)&objectName, (NWOBJ_TYPE NWFAR *)&objectType, (NWFLAGS NWFAR *)&hasPropertiesFlag,
			(NWFLAGS NWFAR *)&objectFlags, (NWFLAGS NWFAR *)&objectSecurity));
		 if (nwrc != 0x0000)
		   {  //printf("\nNWScanObject failed: %x",nwrc);
			  binerror = 1;   //getch(); exit(1);
		   }
		 else
		   {  binerror = 0;
			  strcpy(serverlist[counter].name,objectName);
			  counter++;
		   }
	   } // while
	 return(counter);
} //scanforservers

int getserverinfo(servernum)
//get information on a server
{  int error = 0;  WORD nwrc;
   VERSION_INFO fsinfotemp;
   static unsigned int servercount;
   NWCONN_HANDLE tempconnHandle;
   int tempconnNumber;

	nwrc = (NWGetConnectionHandle((BYTE NWFAR *)&serverlist[servernum].name, 0,(NWCONN_HANDLE NWFAR *)&tempconnHandle, NULL));
	if (nwrc != 0x0000)
	   error = 1;
	if (error == 0)
	  {
		 nwrc = (NWGetConnectionNumber(tempconnHandle, &tempconnNumber));
		 if (nwrc != 0x0000)
			{  printf("\nNWGetConnectionNumber failed: %x",nwrc);
			   exit(1);
			}

	nwrc = (NWGetFileServerVersionInfo(tempconnHandle, (VERSION_INFO FAR *)&fsinfotemp));
	if (nwrc != 0x0000)
	  { printf("\nNWGetFileServerVersionInfo: failed %04x",nwrc);
		exit(1);
	  }

	strcpy(serverinfo[servercount].name,fsinfotemp.serverName);
	serverinfo[servercount].connsinuse = fsinfotemp.connectionsInUse;
	serverinfo[servercount].yourconnNumber = tempconnNumber;
	serverinfo[servercount].yourconnHandle = tempconnHandle;
	servercount++;
  } //if error
  return(servercount);
} //getserverinfo

// find the space used by the user. . .
void getspaceused(int serversattached)
{  char username[48], serverName[48], volName[48], space2[48];
   WORD nwrc;
   NWSERVICE_VERSION majorVersion, minorVersion, revision;
   NWNUMBER maxConnections, maxConnectionsUsed, connectionsInUse, numVolumes;
   NWSUPPORT_LEVEL SFTLevel, TTSLevel;
   NWVOL_NUM volNum=0;
   int loop, volcounter=0, mainloop=0;
   NWOBJ_ID objectID;
   NWDISK_SPACE restriction, inUse;

for (mainloop=0;mainloop<serversattached;mainloop++)
 { volcounter = 0;
   nwrc = NWGetFileServerInformation(serverinfo[mainloop].yourconnHandle, (char NWFAR *)&serverName,
   (NWSERVICE_VERSION NWFAR *)&majorVersion,(NWSERVICE_VERSION NWFAR *)&minorVersion,
   (NWSERVICE_VERSION NWFAR *)&revision,(NWNUMBER NWFAR *)&maxConnections,
   (NWNUMBER NWFAR *)&maxConnectionsUsed,(NWNUMBER NWFAR *)&connectionsInUse,
   (NWNUMBER NWFAR *)&numVolumes, (NWSUPPORT_LEVEL NWFAR *)&SFTLevel,(NWSUPPORT_LEVEL NWFAR *)&TTSLevel);

   for (loop=0;loop<numVolumes;loop++)
	 {  nwrc =  NWGetVolumeName(serverinfo[mainloop].yourconnHandle, loop, (char NWFAR *)&volName);
		if ((nwrc != 0x89FF) && (strlen(volName) > 0))
		  {  strcpy(serverinfo[mainloop].volinfo[loop].volname,volName);
			 volcounter++;
		  } // if
	 } // for
   NWGetObjectID(serverinfo[mainloop].yourconnHandle, searchObjectName, OT_USER, (NWOBJ_ID NWFAR *)&objectID);
   for (loop=0;loop<volcounter;loop++)
	 {
		nwrc = NWGetObjDiskRestrictions(serverinfo[mainloop].yourconnHandle, loop, objectID,
				(NWDISK_SPACE NWFAR *)&restriction,
				(NWDISK_SPACE NWFAR *)&inUse);

		if (nwrc == 0x0000)
		  serverinfo[mainloop].volinfo[loop].spaceused = (unsigned long int) inUse * 4;
		else
		  printf("\nnwrc = %04x\t\tID: %lx",nwrc,objectID);
	 } // for
// since this is for WMD, modify to display what I want. . .
//   printf("\nServer: %s\nVolume\tSpace",serverinfo[mainloop].name);
  if (mainloop == 0)
	{
	printf("\n\nSpace Allocation table (in KB):");
	printf("\nSERVER    ");
	for (loop=0;loop<volcounter;loop++)
	  printf("%s\t",serverinfo[mainloop].volinfo[loop].volname);
    printf("\n------   -----  -----   -----");
	} // if
	printf("\n%s",serverinfo[mainloop].name);
   for (loop=0;loop<volcounter;loop++)
	  printf("\t%7lu",serverinfo[mainloop].volinfo[loop].spaceused);
 } // for
} // getspaceused