PROGRAM SemList(INPUT, OUTPUT);
{$I Options}
{$M 16384,0,0}

{
  Copyright (C) 1991 Julian Byrne. All rights reserved.

  Title:        Get Semaphore
  File name:    SEMLIST.PAS
  Version:      1.00
  Usage:        SEMLIST [SemaphoreName]
  Description:  Continuously lists all users of a semaphore until any key
                is pressed.
  Dependencies: See USES statement
  Author:       Julian Byrne
  Address:      Electrical and Computer Systems Engineering Department
                Monash University, Wellington Road, Clayton, Victoria, 3168
                Australia
  Internet:     julian.byrne@monash.edu.au.
  Other nets:   Quaterman & Hoskins "Notable Computer Networks"
                CACM Oct'86 pp932-971
  History:      90/ 5/ 1 Initial version
  Notes:
}

USES
  CRT,
  DOS,
  Country,
  CheckIO,
  NOS;

{$I Site}

CONST
  ConMax       = 100;
  TicksPerSec  = 18.2;      { System heartbeat interrupt (SysTime) }

TYPE
  ConnectType  = STRING[ConMax];
  ConInfoType  = ARRAY[1..ConMax] OF GCIReplyType;
  SemTableType = ARRAY[1..ConMax] OF RECORD
                                        Name      : STRING127;
                                        Value     : SHORTINT;
                                        OpenCount : BYTE;
                                        Connect   : ConnectType;
                                      END;

VAR
  SysTime     : LONGINT ABSOLUTE $0040:$006C; { Increments at 18.2/Sec }
  ISDcode     : BYTE;
  CDD         : CDI;
  ConInfo     : ConInfoType;
  SemN        : WORD;
  SemTable    : SemTableType;
  Server      : STRING47;
  Semaphore   : STRING127;
  Dir         : DirStr;
  Name        : NameStr;
  Ext         : ExtStr;

PROCEDURE KeyDelay(ms : WORD);

  VAR
    AbsTime : LONGINT;

  BEGIN { KeyDelay }
    AbsTime := SysTime + ROUND(ms*(TicksPerSec*1e-3));
    REPEAT
    UNTIL KeyPressed OR (SysTime >= AbsTime);
  END { KeyDelay };


PROCEDURE GetSemaphoreList(VAR Server      : STRING47;
                           VAR Semaphore   : STRING127;
                           VAR ConInfo     : ConInfoType;
                           VAR N           : WORD;
                           VAR SemTable    : SemTableType);

  VAR
    I, J, K   : WORD;
    GFSIReply : GFSIReplyType;
    GCSReply  : GCSReplyType;
    P         : ^GCSEntryType;

  BEGIN { GetSemaphoreList }
    GetFileServerInformation(GFSIReply);
    Server := StrName48(GFSIReply.ServerName);
    N := 0;
    FOR I := 1 TO Swap(GFSIReply.ConnectPeak) DO
      WITH GCSReply DO
        BEGIN
          GetConnectionInformation(I, ConInfo[I]);
          NextRequest := 0;
          IF (ConInfo[I].ObjID <> 0) THEN
            BEGIN
              REPEAT
                GetConnectionSemaphores(I, NextRequest, GCSReply); 
                P := @List;
                FOR J := 1 TO Records DO
                  BEGIN
                    IF (Semaphore = '') OR (Semaphore = P^.Name) THEN
                      BEGIN
                        K := 1;
                        WHILE (K <= N) AND (SemTable[K].Name <> P^.Name) DO
                          INC(K);
                        IF K > N THEN
                          WITH SemTable[K] DO
                            BEGIN
                              INC(N);
                              Name      := P^.Name;
                              OpenCount := SHORTINT(Swap(P^.OpenCount));
                              Value     := P^.SemaphoreValue;
                              Connect   := '';
                            END;
                        WITH SemTable[K] DO
                          Connect := Connect + CHR(I);
                      END;
                    P := PTR(SEG(P^),OFS(P^.Name[1])+Length(P^.Name));
                  END;
              UNTIL NextRequest = 0; 
            END;
      END;
    FOR I := Swap(GFSIReply.ConnectPeak)+1 TO ConMax DO
      ConInfo[I].ObjID := 0;
  END { GetSemaphoreList };


PROCEDURE DisplaySemaphoreList(VAR Server      : STRING47;
                               VAR Semaphore   : STRING127;
                               VAR ConInfo     : ConInfoType;
                               VAR N           : WORD;
                               VAR SemTable    : SemTableType);
  VAR
    I, J, K : WORD; 
    Col,
    LenS,
    LenO    : BYTE;
    DT      : DateTimeWH;
    Names   : ARRAY[1..ConMax] OF STRING[50];

  BEGIN { DisplaySemaphoreList }
    FOR I := 1 TO ConMax DO
      WITH ConInfo[I] DO
        IF ObjID <> 0 THEN
          Names[I] := StrBYTE(I,2)+':'+StrName48(ObjName);
    LenS := 0;
    LenO := 0;
    FOR I := 1 TO N DO
      WITH SemTable[I] DO
        BEGIN
          IF Length(Name) > LenS THEN
            LenS := Length(Name);
          FOR J := 1 TO Length(Connect) DO
            BEGIN
              K := ORD(Connect[J]);
              IF Length(Names[K]) > LenO THEN
                LenO := Length(Names[K]);
            END;
        END;
    INC(LenO);
    IF LenS < 6 THEN
      LenS := 6;
    IF LenO < 8 THEN
      LenO := 8;
    ClrScr;
    HighVideo;
    IF SiteName <> '' THEN
      WriteLn('':(80-Length(SiteName)) DIV 2, SiteName);
    IF N = 0 THEN
      IF Semaphore = '' THEN
        Write('No semaphores in use')
      ELSE
        Write('Semaphore "',Semaphore, '" not in use')
    ELSE
      Write('Name':LenS, ' Val   N  Users');
    IF Server <> '' THEN
      Write(' on ', Server);
    Country.GetDateTime(DT);
    Write(' at ');
    WriteDateTimeAbs(CDD, DT);
    WriteLn('.');
    NormVideo;
    FOR I := 1 TO N DO
      WITH SemTable[I] DO
        BEGIN
          Write(Name:LenS, Value:4, OpenCount:4, '  ');
          Col := LenS + 11;
          FOR J := 1 TO Length(Connect) DO
            BEGIN
              IF (Col+LenO) > 80 THEN
                BEGIN
                  WriteLn;
                  Write('':LenS+10);
                  Col := LenS + 11;
                END;
              K := ORD(Connect[J]);
              Write(Names[K], '':LenO-Length(Names[K]));
              Col := Col + LenO;
            END; 
          WriteLn;
        END;
  END { DisplaySemaphoreList };


BEGIN { SemList }
  FSplit(ParamStr(0), Dir, Name, Ext);
  IF (ParamCount > 1) THEN
    BEGIN
      WriteLn('Usage: ', Name, ' [Semaphore]');
      WriteLn('Copyright 1st June 1991 Julian Byrne. All rights reserved.');
      Halt;
    END;
  IF (ParamCount > 0) THEN
    BEGIN
      Semaphore := ParamStr(1);
      IF Semaphore = '*' THEN
        Semaphore := '';
    END
  ELSE
    Semaphore := '';
  IF NOT NovellAPI THEN
    BEGIN
      WriteLn(Name, ': Novell Netware (tm) required.');
      Halt(0);
    END;
  IF NOT CheckConsolePrivileges THEN
    BEGIN
      WriteLn(Name, ': Console privileges required.');
      Halt(0);
    END;
  GetCountry(ISDcode, CDD);
  REPEAT
    GetSemaphoreList(Server, Semaphore, ConInfo, SemN, SemTable);
    DisplaySemaphoreList(Server, Semaphore, ConInfo, SemN, SemTable);
    KeyDelay(5000);
  UNTIL KeyPressed;
  KeyDiscard;
END { SemList }.
