PROGRAM ScanBindery(INPUT, OUTPUT);
{$I Options}
{$M 8192,0,0}

{
  Copyright (C) 1991 Julian Byrne. All rights reserved.

  Title:        Scan Bindery
  File name:    SCANBIND.PAS
  Version:      1.00
  Usage:        scanbind <ObjectType> <ObjectName> <PropertyName>
  Description:  Scans a Novell Netware (tm) bindery for the specified objects &
                object properties. -1 can be used as an <ObjectType> wildcard.
                '*' can be used as an <ObjectName> and <PropertyName> wildcard.
  Dependencies: See USES statement
  Author:       Julian Byrne
  Address:      Electrical and Computer Systems Engineering Department
                Monash University, Wellington Road, Clayton, Victoria, 3168
                Australia
  Internet:     julian.byrne@monash.edu.au.
  Other nets:   Quaterman & Hoskins "Notable Computer Networks"
                CACM Oct'86 pp932-971
  History:      90/ 5/ 1 Initial version
  Notes:
}
  USES
    DOS,
    CheckIO,
    NOS;

{$I Site}

  CONST
    Heading1 = 'Object  ID  Type                           '+
               '              Name Flag Sec HasProp';
    Heading2 = '  Property  Name    Flags Security HasValue';
    Heading3 = '     Object ID  Type                       '+
               '                 Name';

  VAR
    Heading,
    Code,
    I          : INTEGER;
    pSegment   : ^BYTE;
    pLastSeen  : ^LONGINT;
    pPropName  : ^STRING15;
    SORequest  : SORequestType;
    SOReply    : SOReplyType;
    SPRequest  : SPRequestType;
    SPReply    : SPReplyType;
    RPVRequest : RPVRequestType;
    RPVReply   : RPVReplyType;
    Dir        : DirStr;
    Name       : NameStr;
    Ext        : ExtStr;
    YN         : ARRAY[BOOLEAN] OF STRING[3];


  PROCEDURE DumpObjectList(VAR b : ObjectListType);

    VAR
      I : WORD;
      t : WORD;
      s : STRING47;

    BEGIN { DumpObjectList }
      IF Heading <> 3 THEN
        BEGIN
          Heading := 3;
          WriteLn(Heading3);
        END;
      I := 0;
      WHILE (I <= 31) AND (b[I] <> 0) DO
        BEGIN
          s := GetObjectName(b[I], t);
          WriteLn(Swap4(b[I]):13, Swap(t):6, s:49);
          INC(I);
        END;
    END { DumpObjectList };

  PROCEDURE DumpHex(VAR x : ObjectListType);

    VAR
      b : ARRAY[0..127] OF BYTE ABSOLUTE x;
      I, J : WORD;

    BEGIN { DumpHex }
      Heading := 0;
      I := 0;
      REPEAT
        Write('':4);
        FOR J := I TO I+15 DO
          Write(Hex2(b[J]), ' ');
        Write('  ');
        FOR J := I TO I+15 DO
          IF (CHR(b[J]) >= ' ') THEN
            Write(CHR(b[J]))
          ELSE
            Write('.'); 
        WriteLn;
        INC(I, 16);
      UNTIL (I > 127);
    END { DumpHex };

  BEGIN { ScanBindery }
    FSplit(ParamStr(0), Dir, Name, Ext);
    Assign(OUTPUT, ''); { So output can be redirected }
    ReWrite(OUTPUT);

    IF ParamCount <> 3 THEN
      BEGIN
        WriteLn('Usage: ', Name, ' <ObjectType> <ObjectName> <PropertyName>');
        WriteLn('Scan all: ', Name, ' -1 * *');
        Halt;
      END;
    Val(ParamStr(1), I, Code);
    IF Code <> 0 THEN
      BEGIN
        WriteLn(Name, ': <ObjectType> must be an integer');
        Halt;
      END;
    IF NOT NovellAPI THEN
      BEGIN
        WriteLn(Name, ': Novell Netware (tm) required.');
        Halt(0);
      END;
    IF NOT CheckConsolePrivileges THEN
      BEGIN
        WriteLn(Name, ': Console privileges required.');
        Halt(0);
      END;
    YN[FALSE]           := 'No';
    YN[TRUE]            := 'Yes';
    SORequest.LastObjID := -1;
    SORequest.ObjType   := Swap(I);
    SORequest.ObjName   := ParamStr(2); 
    Heading             := 0;
    REPEAT
      ScanObject(SORequest, SOReply);
      WITH SOReply DO
        IF BufLength <> 0 THEN
          BEGIN
            IF Heading <> 1 THEN
              BEGIN
                Heading := 1;
                WriteLn(Heading1);
              END;
            WriteLn(Swap4(ObjID):10, Swap(ObjType):5, StrName48(ObjName):49,
              ORD(ObjFlag):2, Hex2(ObjSecurity):4,
              YN[ORD(ObjProperties) <> 0]:6);
            IF ORD(SOReply.ObjProperties) <> 0 THEN
              BEGIN
                SPRequest.ObjType := SOReply.ObjType;
                SPRequest.ObjName := StrName48(SOReply.ObjName);
                pLastSeen         := PTR(SEG(SPRequest.ObjName[1]),
                  OFS(SPRequest.ObjName[1])+Length(SPRequest.ObjName));
                pLastSeen^        := -1;
                PPropName         := PTR(SEG(pLastSeen^),
                  OFS(pLastSeen^)+SIZEOF(LONGINT));
                pPropName^        := ParamStr(3);
                REPEAT
                  ScanProperty(SPRequest, SPReply);
                  WITH SPReply DO
                    IF BufLength <> 0 THEN
                      BEGIN
                        IF Heading <> 2 THEN
                          BEGIN
                            Heading := 2;
                            WriteLn(Heading2);
                          END;
                        WriteLn(StrName16(PropName):18, Hex2(PropFlags):5,
                          Hex2(PropSecurity):8,
                          YN[ORD(PropValue) <> 0]:9);
                        IF ORD(PropValue) <> 0 THEN
                          BEGIN
                            RPVRequest.ObjType := SPRequest.ObjType;
                            RPVRequest.ObjName := SPRequest.ObjName;
                            pSegment   := PTR(SEG(RPVRequest.ObjName[1]),
                              OFS(RPVRequest.ObjName[1])+
                              Length(RPVRequest.ObjName));
                            pSegment^  := 1;
                            pPropName  := PTR(SEG(pSegment^),
                              OFS(pSegment^)+SIZEOF(BYTE));
                            pPropName^ := StrName16(PropName);
                            REPEAT
                              ReadPropertyValue(RPVRequest, RPVReply);
                              IF (RPVReply.BufLength <> 0) AND
                                ((RPVReply.PropFlags AND $02) = $02) THEN
                                DumpObjectList(RPVReply.PropValue)
                              ELSE
                                DumpHex(RPVReply.PropValue);
                              INC(pSegment^);
                            UNTIL (RPVReply.BufLength = 0) OR
                              (NOT RPVReply.MoreSegments);
                          END;
                        pLastSeen^ := LastSeen;
                      END;
                UNTIL (SPreply.BufLength = 0);
              END;
            SORequest.LastObjID := SOReply.ObjID;
          END;
    UNTIL SOReply.BufLength = 0;
  END { ScanBindery }.

