PROGRAM PatchAny(INPUT, OUTPUT);
{$I Options}
{$M 8192,0,0}

{
  Copyright (C) 1991 Julian Byrne. All rights reserved.

  Title:        Patch ANY.EXE
  File name:    PATCHANY.PAS
  Version:      1.00
  Usage:        patchany any.exe application.exe
  Description:  Modifies the program any.exe to execute application.exe.
  Dependencies: See USES statement
  Author:       Julian Byrne
  Address:      Electrical and Computer Systems Engineering Department
                Monash University, Wellington Road, Clayton, Victoria, 3168
                Australia
  Internet:     julian.byrne@monash.edu.au.
  Other nets:   Quaterman & Hoskins "Notable Computer Networks"
                CACM Oct'86 pp932-971
  History:      90/ 5/ 1 Initial version
  Notes:
}
  USES
    DOS,
    CheckIO,
    NOS;

{$I Site}

  CONST
    HeaderSizeOffset = 8;
    JMPSIZE          = 3;
    JMPCODE          = $E9;

  VAR
    f       : FILE;
    JMP     : BYTE;
    Path,
    PathEnc : PathStr;
    Header  : EXEHeader;
    Dir     : DirStr;
    Name    : NameStr;
    Ext     : ExtStr;

  BEGIN { PatchAny }
    FSplit(ParamStr(0), Dir, Name, Ext);
    IF ParamCount <> 2 THEN
      BEGIN
        WriteLn('Usage: ', Name, ' <any.exe> <application>');
        Halt;
      END;
    AssignCheck(f, ParamStr(1));
    ResetCheck(f, 1);
    BlockReadCheck(f, Header, SIZEOF(Header));
    SeekCheck(f, Header.HeadSize SHL 4);
    BlockReadCheck(f, JMP, sizeof(JMP));
    WITH Header DO
      IF (StartCS <> 0) OR (StartIP <> 0) OR (HeadSize <> 32) OR
        (JMP <> JMPCODE) THEN
        BEGIN
          WriteLn(Name, ': "', ParamStr(1), '" not a copy of "ANY.EXE"');
          Halt;
        END;
    SeekCheck(f, (Header.HeadSize SHL 4) + JMPSIZE);
    Path    := ParamStr(2);
    PathEnc := EncodeSTRING(Path+CHR(0));
    BlockWriteCheck(f, PathEnc[1], Length(PathEnc));
    CloseCheck(f);
    WriteLn('"', Path, '" patched into "', ParamStr(1), '"');
  END { PatchAny }.

