PROGRAM EXEdump(INPUT, OUTPUT);
{$I Options} {$Q-}
{$M 8192,0,0}

{
  Copyright (C) 1991 Julian Byrne. All rights reserved.

  Title:	Executable Dump
  Usage:	exedump <EXEfile>
  Description:	Dump the header of an executable file
  Dependencies: See USES statement
  Author:	Julian Byrne
  Address:	Electrical and Computer Systems Engineering Department
		Monash University, Wellington Road, Clayton, Victoria, 3168
		Australia
  Internet:	julian.byrne@monash.edu.au.
  History:	89/11/20 Initial version
		91/ 5/19 Now uses CheckIO.
}

  USES
    Error,
    DOS,
    CheckIO;
{
  The EXE file header is described in the Microsoft Programmer's Reference
  Chapter 5
}
{$I Site}

  CONST
    ReadMax	  = $8000;
    ReadMax2	  = $4000;
    PageSize	  = 512;

  TYPE
    bType = ARRAY[1..ReadMax2] OF WORD;

  VAR
    I,
    SumCalc,
    ReadSize : WORD;
    Count    : LONGINT;
    MyDir,
    Dir      : DirStr;
    MyName,
    Name     : NameStr;
    MyExt,
    Ext      : ExtStr;
    f	     : FILE;
    Header   : EXEHeader;
    b	     : bType;

  BEGIN { EXEdump }
    FSplit(ParamStr(0), MyDir, MyName, MyExt);
    Assign(OUTPUT, '');
    ReWrite(OUTPUT);
    IF ParamCount <> 1 THEN
      BEGIN
	WriteLn('Usage: ', MyName, ' <EXEfile>');
	Halt;
      END;
    FSplit(ParamStr(1), Dir, Name, Ext);
    IF Ext = '' THEN
      Ext := '.EXE';
    Assign(f, Dir+Name+Ext);
    Reset(f, 1);
    BlockRead(f, Header, SIZEOF(Header));
    DumpHeader(f, Header);
    WITH Header DO
      BEGIN
	Reset(f, 1);
	Count := LONGINT(PageFileSize-1)*LONGINT(PageSize)+
		 LONGINT(LastPageSize);
	SumCalc := 0;
	WHILE Count > 0 DO
	  BEGIN
	    IF Count > ReadMax THEN
	      ReadSize := ReadMax
	    ELSE
	      ReadSize := Count;
	    BlockRead(f, b, ReadSize);
	    Count := Count - ReadSize;
	    FOR I := 1 TO ReadSize DIV SIZEOF(WORD) DO
	      SumCalc := SumCalc + b[I];
	  END;
	Close(f);
	SumCalc := CheckSum - SumCalc;
	WriteLn;
	IF SumCalc = CheckSum THEN
	  WriteLn(MyName, ': Checksum is okay')
	ELSE
	  WriteLn(MyName, ': Checksum is bad. Calculated: ', Hex4(SumCalc));
      END;
  END { EXEdump }.

