;
; Copyright (C) 1991 Julian Byrne. All rights reserved.
;
; Title:        Execute sub-process
; File name:    EXE.ASM
; Version:      1.00
; Usage:        EXE
; Description:  Executes a command line as a sub-process
; Dependencies: none
; Author:       Julian Byrne
; Address:      Electrical and Computer Systems Engineering Department
;               Monash University, Wellington Road, Clayton, Victoria, 3168
;               Australia
; Internet:     julian.byrne@monash.edu.au.
; Other nets:   Quaterman & Hoskins "Notable Computer Networks"
;               CACM Oct'86 pp932-971
; History:      91/ 5/ 1 Initial version
; Notes:
;
          .RADIX  10
          DOSSEG

STACKSIZE EQU     64
PSPSIZE   EQU     100H

PSP       STRUC                         ; Program Segment Prefix
INT20     DW      ?
TopOfMem  DW      ?
          DB      ?
CALLFAR   DB      ?
SegSize   DD      ?
pTerm     DD      ?
pBreak    DD      ?
pError    DD      ?
          DB       22 DUP (?)
pEnv      DW      ?           ; 2C
          DB       46 DUP (?)
FCB1      DB       16 DUP (?) ; 5C
FCB2      DB       20 DUP (?) ; 6C
Param     DB      128 DUP (?) ; 80
PSP       ENDS

CODE      SEGMENT BYTE 'CODE'
SEG_PSP   EQU     (SEG CODE)-10H
          ASSUME  CS:CODE, SS:CODE, DS:CODE, ES:CODE ; DS,ES really SEG_PSP
          ORG     0

EXE       PROC    FAR
          JMP     SHORT Start   ; Skip to initialization code
          DB      STACKSIZE DUP (?) ; Stack
StackTop:
;
; Parameter block used by Load and Execute Program
;
ParBlock:
          DW      0             ; Segment address of passed environment
ComLinOfs:DW      ?             ; Command line
          DW      SEG_PSP
          DW      OFFSET FCB1   ; FCB to be placed at 5CH
          DW      SEG_PSP
          DW      OFFSET FCB2   ; FCB to be placed at 6CH
          DW      SEG_PSP
Finish:
          INT     21H           ; Execute set block
          JC      SHORT Done

          MOV     AX, 4B00H     ; Load and execute program
          MOV     DX, OFFSET Param; DS: pointing at PSP
          MOV     BX, PSPSIZE + OFFSET ParBlock; ES: pointing at PSP
          INT     21H
          JC      SHORT Done

          MOV     AH, 4DH       ; Get return code of child process
          INT     21H
Done:
          MOV     AH, 4CH       ; End Process
          INT     21H
;
; All code after this mark is discarded before executing sub-process
;
          ASSUME  ES:SEG_PSP
Start:    MOV     AX, CS
          MOV     SS, AX
          MOV     SP, OFFSET StackTop ; Use stack lower in memory

          MOV     SI, OFFSET Param    ; Start parsing parameters
          MOV     CL, [SI]            ; DS: Program Segment Prefix
          MOV     CH, 0
          INC     SI

          CALL    SkipSpaces    ; ES:[SI], set DI

    REPNZ SCASB                 ; ES:[DI]. Scan non-spaces in 1st parameter

          JNZ     SHORT SkipBack; At end of all parameters? Yes, skip backup
          DEC     DI
          INC     CX
SkipBack:
          CLD
          PUSH    CX            ; Terminate 1st parameter with a null
          MOV     CX, DI        ;   without disturbing other parameters
          SUB     CX, SI
          MOV     DI, OFFSET Param
      REP MOVSB
          MOV     BYTE PTR [DI], 0 ; ES:
          POP     CX

          DEC     SI            ; Parse other parameters
          MOV     [SI], CL
          MOV     WORD PTR CS:[ComLinOfs], SI
          INC     SI

          CALL    SkipSpaces    ; ES:[SI], set DI

          MOV     AX, 2900H     ; Parse a file name
          MOV     DI, OFFSET FCB1; ES:
          INT     21H

          CALL    SkipSpaces    ; ES:[SI], set DI 

          MOV     AX, 2900H     ; Parse a file name
          MOV     DI, OFFSET FCB2; ES:
          INT     21H

          MOV     AH, 4AH       ; Set block. Frees memory for execute
          MOV     BX, (PSPSIZE+(OFFSET Start)-(OFFSET EXE)+0FH)/16

          JMP     SHORT Finish  ; Go lower in memory
EXE       ENDP

SkipSpaces PROC   NEAR
          CLD
          MOV     DI, SI
          MOV     AL, ' '
     REPZ SCASB           ; Skip till space ES:[DI] length CX
          DEC     DI
          INC     CX
          MOV     SI, DI
          RET
SkipSpaces ENDP

CODE      ENDS

STACKSEG  SEGMENT PARA STACK 'STACK'
          DB      STACKSIZE DUP (?)
STACKSEG  ENDS

          END     EXE

