{$I Options}
UNIT Error;

{
  Copyright (C) 1991 Julian Byrne. All rights reserved.

  Title:	Error Message
  File name:	ERROR.PAS
  Version:	1.00
  Usage:	USES Error;
  Description:	Given error number give error message. Causes a meaningful
		error message on abnormal program termination.
  Dependencies: See USES statement
  Author:	Julian Byrne
  Address:	Electrical and Computer Systems Engineering Department
		Monash University, Wellington Road, Clayton, Victoria, 3168
		Australia
  Internet:	julian.byrne@monash.edu.au.
  Other nets:	Quaterman & Hoskins "Notable Computer Networks"
		CACM Oct'86 pp932-971
  History:	91/ 5/ 1 Initial version
  Notes:
}

INTERFACE { Error }

  USES
    CRT,
    DOS;

  TYPE
    TextLine = STRING[80];
    pSTRING  = ^STRING;

  VAR
    OutName,
    InpName   : TextLine;
    QuietExit : BOOLEAN;
    FN	      : pSTRING;
    PErrorMsg : FUNCTION (ErrorCode : INTEGER) : STRING;
{ If this is non-NIL then it is a handler for negative error numbers.
  Typically it will be a graphics or overlay error message function
}
  FUNCTION  IOErrorMsg(IOresult  : INTEGER) : TextLine;
  FUNCTION NetErrorMsg(NetResult : INTEGER) : TextLine;
  FUNCTION ObjTypeName(Code	 : WORD   ) : TextLine;

IMPLEMENTATION { Error }

  FUNCTION IOerrorMsg(IOresult : INTEGER) : TextLine;

    VAR
      n,
      s : TextLine;

    BEGIN { IOerrorMsg }
      IF (IOResult < 0) AND (@PErrorMsg <> NIL) THEN
	s := PErrorMsg(IOResult)
      ELSE
      IF IOresult < 100 THEN
	CASE IOresult OF
	  00 : s := 'Successful';
	  01 : s := 'Invalid function code';
	  02 : s := 'File not found';
	  03 : s := 'Path not found';
	  04 : s := 'Too many open files (no open handles left)';
	  05 : s := 'Access denied';
	  06 : s := 'Invalid handle';
	  07 : s := 'Memory control blocks destroyed';
	  08 : s := 'Insufficient memory';
	  09 : s := 'Invalid memory block address';
	  10 : s := 'Invalid environment';
	  11 : s := 'Invalid format';
	  12 : s := 'Invalid access code';
	  13 : s := 'Invalid data';
	  15 : s := 'Invalid drive';
	  16 : s := 'Attempt to remove the current directory';
	  17 : s := 'Not same device';
	  18 : s := 'No more files';
	  19 : s := 'Disk is write-protected';
	  20 : s := 'Bad disk unit';
	  21 : s := 'Drive not ready';
	  22 : s := 'Invalid disk command';
	  23 : s := 'CRC error';
	  24 : s := 'Invalid length (disk operation)';
	  25 : s := 'Seek error';
	  26 : s := 'Not an MS-DOS disk';
	  27 : s := 'Sector not found';
	  28 : s := 'Out of paper';
	  29 : s := 'Write fault';
	  30 : s := 'Read fault';
	  31 : s := 'General failure';
	  32 : s := 'Sharing violation';
	  33 : s := 'Lock violation';
	  34 : s := 'Wrong disk';
	  35 : s := 'FCB unavailable';
	  50 : s := 'Network request not supported';
	  51 : s := 'Remote computer not listening';
	  52 : s := 'Duplicate name on network';
	  53 : s := 'Network name not found';
	  54 : s := 'Network busy';
	  55 : s := 'Network device no longer exists';
	  56 : s := 'Net BIOS command limit exceeded';
	  57 : s := 'Network adaptor hardware error';
	  58 : s := 'Incorrect response from network';
	  59 : s := 'Unexpected network error';
	  60 : s := 'Incompatible remote adapt';
	  61 : s := 'Print queue full';
	  62 : s := 'Queue not full';
	  63 : s := 'Not enough space for print file';
	  64 : s := 'Network name was deleted';
	  65 : s := 'Access denied';
	  66 : s := 'Network device type incorrect';
	  67 : s := 'Network name not found';
	  68 : s := 'Network name limit exceeded';
	  69 : s := 'Net BIOS session limit exceeded';
	  70 : s := 'Temporarily paused';
	  71 : s := 'Network request not accepted';
	  72 : s := 'Print or disk redirection is paused';
	  80 : s := 'File exists';
	  82 : s := 'Cannot make';
	  83 : s := 'Interrupt 24 failure';
	  84 : s := 'Out of structures';
	  85 : s := 'Already assigned';
	  86 : s := 'Invalid password';
	  87 : s := 'Invalid parameter';
	  88 : s := 'Net write fault';
	ELSE
	  s := 'DOS RESERVED';
	END { CASE x }
      ELSE
      IF IOResult < 150 THEN
	CASE IOResult OF
	  100 : s := 'Disk read error';
	  101 : s := 'Disk write error';
	  102 : s := 'File not assigned';
	  103 : s := 'File not open';
	  104 : s := 'File not open for input';
	  105 : s := 'File not open for output';
	  106 : s := 'Invalid numeric format';
	ELSE
	  s := 'Turbo Pascal RESERVED';
	END
      ELSE
      IF IOResult < 200 THEN
	CASE IOResult OF
	  150 : s := 'Attempt to write on write-protected disk';
	  151 : s := 'Unknown unit';
	  152 : s := 'Drive not ready';
	  153 : s := 'Unknown command';
	  154 : s := 'CRC error in data';
	  155 : s := 'Bad drive request structure length';
	  156 : s := 'Seek error';
	  157 : s := 'Unknown media type';
	  158 : s := 'Sector not found';
	  159 : s := 'Printer out of paper';
	  160 : s := 'Write fault';
	  161 : s := 'Read fault';
	  162 : s := 'General failure';
	ELSE
	  s := 'DOS Critical Error RESERVED';
	END
      ELSE
	CASE IOResult OF
	  200 : s := 'Division by zero';
	  201 : s := 'Range check error';
	  202 : s := 'Stack overflow error';
	  203 : s := 'Heap overflow error';
	  204 : s := 'Invalid pointer operation';
	  205 : s := 'Floating point overflow';
	  206 : s := 'Floating point underflow';
	  207 : s := 'Invalid floating point operation';
	  208 : s := 'Overlay manager not installed';
	  209 : s := 'Overlay file read error';
	  255 : s := 'Control/C';
	ELSE
	  s := 'Turbo Pascal Critical Error RESERVED';
	END;
      Str(IOResult, n);
      IOerrorMsg := 'Error '+n+': '+s;
    END { IOerrorMsg };


{
  Given a network error number return the corresponding error message.
  Some error numbers are also used by MSDOS.
  Some error numbers have many error messages. In these cases a
  'General failure' error message is returned. These are:
    0: SPX not installed
       SPX connection ok
       SPX connection started
       SPX connection established
       SPX packet successful
       Server not in use
       TTS not available
    1: Server in use
       Semaphore overflow
       TTS available
  252: Internet packet request cancelled
       Unknown file server
       Message queue full
       SPX listen cancelled
       No such object
  253: Bad station number
       Invalid packet length
       Unknown request
       SPX malformed packet
       SPX packet overflow
       Field already locked
       TTS disabled
  254: Bindery locked
       Directory locked
       Invalid semaphore name length
       Packet not deliverable
       Server bindery locked
       Socket table full
       Spool directory error
       Supervisor has disabled login
       Timeout failure
       Transaction ends record lock
       Implicit transaction active
  255: Bad printer error
       Bad record offset
       Close FCB error
       File extension error
       File name error
       Hardware failure
       Invalid drive number
       Invalid initial semaphore value
       Invalid semaphore handle
       IO bound error
       No files found error
       No response from server
       No such object or bad password
       Path not locatable
       Queue full error
       Request not outstanding
       Socket already open
       Transaction not yet written
       No more matching files
       Bindery failure
       SPX is installed
       SPX socket not opened
       Explicit transaction active
       No explicit transaction active
       Transaction not yet written
       No more matching files
       No record found
}
  FUNCTION NetErrorMsg(NetResult : INTEGER) : TextLine;

    VAR
      n, s : TextLine;

    BEGIN { NetErrorMsg }
      CASE NetResult OF
	128 : s := 'File in use';
	129 : s := 'No more file handles';
	130 : s := 'No open privileges';
	131 : s := 'Network disk hardware IO error';
	132 : s := 'No create privileges';
	133 : s := 'No create/delete privileges';
	134 : s := 'Create file exists read-only';
	135 : s := 'Wild cards in create file name';
	136 : s := 'Invalid file handle';
	137 : s := 'No search privileges';
	138 : s := 'No delete privileges';
	139 : s := 'No rename privileges';
	140 : s := 'No modify privileges';
	141 : s := 'Some files affected, in use';
	142 : s := 'No files affected, in use';
	143 : s := 'Some files affected, read-only';
	144 : s := 'No files affected, read-only';
	145 : s := 'Some files renamed, name exists';
	146 : s := 'No files renamed, name exists';
	147 : s := 'No read privileges';
	148 : s := 'No write privileges or read-only';
	149 : s := 'File detached';
	150 : s := 'Server out of memory';
	151 : s := 'No disk space for spool file';
	152 : s := 'Volume does not exist';
	153 : s := 'Directory full';
	154 : s := 'Renaming across volumes';
	155 : s := 'Bad directory handle';
	156 : s := 'Invalid path/No more trustees';
	157 : s := 'No more directory handles';
	158 : s := 'Invalid filename';
	159 : s := 'Directory active';
	160 : s := 'Directory not empty';
	161 : s := 'Directory hardware IO error';
	162 : s := 'Read file with record locked';
	193 : s := 'Login denied, no account balance';
	194 : s := 'Login denied, no credit';
	197 : s := 'Intruder detection lock';
	198 : s := 'Not console operator';
	208 : s := 'Queue error';
	209 : s := 'No queue';
	210 : s := 'No queue server';
	211 : s := 'No queue rights';
	212 : s := 'Queue full';
	213 : s := 'No queue job';
	214 : s := 'No job rights';
	215 : s := 'Password not unique/Queue servicing';
	216 : s := 'Password too short/Queue not active';
	217 : s := 'Login denied, no connection/Station not server';
	218 : s := 'Unauthorized login time/Queue halted';
	219 : s := 'Unauthorized login station/Maximum queue servers';
	220 : s := 'Account disabled';
	222 : s := 'Password has expired, no grace';
	223 : s := 'Password has expired';
	232 : s := 'Not item property/Write property to group';
	233 : s := 'Member already exists';
	234 : s := 'No such member';
	235 : s := 'Not group property';
	236 : s := 'No such segment/SPX terminated poorly';
	237 : s := 'Property already exists/SPX failure';
	238 : s := 'Object already exists/SPX invalid connection';
	239 : s := 'Invalid name/SPX connection table full';
	240 : s := 'Wild card not allowed/SPX not installed';
	241 : s := 'Invalid bindery security';
	242 : s := 'No object read privilege';
	243 : s := 'No object rename privilege';
	244 : s := 'No object delete privilege';
	245 : s := 'No object create privilege';
	246 : s := 'No property delete privilege/Not same local drive';
	247 : s := 'No property create privilege';
	248 : s := 'No property write privilege/(Not) attached to server';
	249 : s := 'No property read privilege/No free connection slots';
	250 : s := 'No more server slots/Temp remap error';
	251 : s := 'No such property/invalid parameters/Unknown request';
	252 : s := 'No such object/Unknown file server/General failure';
	253 : s := 'Badly formed request/General failure';
	254 : s := 'General failure';
	255 : s := 'General failure';
      ELSE
	s := 'Novell Netware (tm) network error RESERVED';
      END;
      Str(NetResult, n);
      NetErrorMsg := 'Network error '+n+': '+s;
    END { NetErrorMsg };
{
  Object type names - See also constant declarations in NOS.PAS.
}
  FUNCTION  ObjTypeName(Code : WORD) : TextLine;

    VAR
      n,
      s : TextLine;

    BEGIN { ObjTypeName }
      CASE INTEGER(Swap(Code)) OF
	-1 : s := 'WILD';
	 0 : s := 'UNKNOWN';
	 1 : s := 'USER';
	 2 : s := 'USERGROUP';
	 3 : s := 'PRINTQUEUE';
	 4 : s := 'FILESERVER';
	 5 : s := 'JOBSERVER';
	 6 : s := 'GATEWAY';
	 7 : s := 'PRINTSERVER';
	 8 : s := 'ARCHIVEQUEUE';
	 9 : s := 'ARCHIVESERVER';
	10 : s := 'JOBQUEUE';
	11 : s := 'ADMINISTRATION';
	33 : s := 'NASSNAGATEWAY';
	38 : s := 'REMOTEBRIDGESERVER';
	39 : s := 'TCPIPGATEWAY';
      ELSE
	s := 'Unknown';
      END;
      Str(Swap(Code), n);
      ObjTypeName := 'Object type '+n+': '+s;
    END { ObjTypeName };

  VAR
    ExitSave  : POINTER;

{$F+}
  PROCEDURE ExitHandler;

    VAR
      Dir  : DirStr;
      Name : NameStr;
      Ext  : ExtStr;

    BEGIN { ExitHandler }
      Close(OUTPUT); { Make sure output is not redirected to file }
      AssignCRT(OUTPUT);
      ReWrite(OUTPUT);
      ExitProc := ExitSave;
      IF (NOT QuietExit) OR (ExitCode <> 0) THEN
	BEGIN
	  NormVideo;
	  FSplit(ParamStr(0), Dir, Name, Ext);
	  Write(Name, ': ', IOErrorMsg(ExitCode));
	  IF FN <> NIL THEN
	    Write(' while accessing "', FN^, '"');
	  WriteLn('.');
	END;
    END { ExitHandler };
{$F-}

BEGIN { Error }
  OutName   := 'OUTPUT';
  InpName   := 'INPUT';
  QuietExit := TRUE;
  FN	    := NIL;
  @PErrorMsg:= NIL;
  ExitSave  := ExitProc;
  ExitProc  := @ExitHandler;
END { Error }.

