PROGRAM ErrMsg(INPUT, OUTPUT);
{$I Options}
{$M 4096,0,0}

{
  Copyright (C) 1991 Julian Byrne. All rights reserved.

  Title:        Error Message
  File name:    ERRMSG.PAS
  Version:      1.00
  Usage:        ERRMSG <ErrorNumber|Command>
  Description:  Display the error message associated with an MSDOS error number.
  Dependencies: See USES statement
  Author:       Julian Byrne
  Address:      Electrical and Computer Systems Engineering Department
                Monash University, Wellington Road, Clayton, Victoria, 3168
                Australia
  Internet:     julian.byrne@monash.edu.au.
  Other nets:   Quaterman & Hoskins "Notable Computer Networks"
                CACM Oct'86 pp932-971
  History:      90/ 5/ 1 Initial version
  Notes:
}

  USES
    Error,
    DOS;

{$I Site}

  TYPE
    STRING128  = STRING[128];

  VAR
    Parameters : ^STRING128;
    I, J,
    Code       : INTEGER;
    Status     : WORD; 
    Dir        : DirStr;
    Name       : NameStr;
    Ext        : ExtStr;

  BEGIN { ErrMsg }
    FSplit(ParamStr(0), Dir, Name, Ext);
    Parameters := PTR(PrefixSeg, $80);
    I := 1;
    WHILE (I <= Length(Parameters^)) AND (Parameters^[I] = ' ') DO
      INC(I);
    IF I > Length(Parameters^) THEN
      BEGIN
        WriteLn('Usage: ', Name, ' <ErrorNumber|Command>');
        Halt;
      END;
    IF (Parameters^[I] >= '0') AND (Parameters^[I] <= '9') THEN
      BEGIN
        Val(Copy(Parameters^, I, 255), Status, Code);
        IF Code <> 0 THEN
          BEGIN
            WriteLn(Name, ': <ErrorNumber> must be a decimal integer.');
            Halt;
          END;
      END
    ELSE
      BEGIN
        J := I;
        WHILE (J <= Length(Parameters^)) AND (Parameters^[J] > ' ') DO
          INC(J);
{$IFNDEF VER40}
        SwapVectors;
{$ENDIF}
        Exec(Copy(Parameters^, I, J-I), Copy(Parameters^, J, 255));
{$IFNDEF VER40}
        SwapVectors;
{$ENDIF}
        Status := DOSError;
        IF Status <> 0 THEN
          WriteLn(Name, ': Error attempting to execute: "',
            Copy(Parameters^, I, J-I), '"')
        ELSE
          Status := DosExitCode AND $FF;
      END;
    QuietExit := FALSE;
    Halt(Status);
  END { ErrMsg }.

