UNIT ASCII;
{$I Options}

{
  Copyright (C) 1991 Julian Byrne. All rights reserved.

  Title:        ASCII symbolic constants
  File name:    ASCII.PAS
  Version:      1.00
  Usage:        USES ASCII;
  Description:  List of ASCII and keyboard scan codes in symbolic constant
                form.
  Dependencies: See USES statement
  Author:       Julian Byrne
  Address:      Electrical and Computer Systems Engineering Department
                Monash University, Wellington Road, Clayton, Victoria, 3168
                Australia
  Internet:     julian.byrne@monash.edu.au.
  Other nets:   Quaterman & Hoskins "Notable Computer Networks"
                CACM Oct'86 pp932-971
  History:      91/ 5/ 1 Initial version
  Notes:
}

  INTERFACE { ASCII }

  CONST

{ Standard ASCII control codes }

    NUL = CHR($00); SOH = CHR($01); STX = CHR($02); ETX = CHR($03);
    EOT = CHR($04); ENQ = CHR($05); ACK = CHR($06); BEL = CHR($07);
    BS  = CHR($08); HT  = CHR($09); LF  = CHR($0A); VT  = CHR($0B);
    FF  = CHR($0C); CR  = CHR($0D); SO  = CHR($0E); SI  = CHR($0F);
    DLE = CHR($10); DC1 = CHR($11); DC2 = CHR($12); DC3 = CHR($13);
    DC4 = CHR($14); NAK = CHR($15); SYN = CHR($16); ETB = CHR($17);
    CAN = CHR($18); EM  = CHR($19); SUB = CHR($1A); ESC = CHR($1B);
    FS  = CHR($1C); GS  = CHR($1D); RS  = CHR($1E); US  = CHR($1F);

    DEL = CHR($7F);

{ Code returned by PC BIOS after returning 0 }

                                                    BT      = $0F;
    AltQ    = $10;  AltW    = $11;  AltE    = $12;  AltR    = $13;
    AltT    = $14;  AltY    = $15;  AltU    = $16;  AltI    = $17;
    AltO    = $18;  AltP    = $19; {        = $1A;          = $1B;
            = $1C;          = $1D;} AltA    = $1E;  AltS    = $1F;
    AltD    = $20;  AltF    = $21;  AltG    = $22;  AltH    = $23;
    AltJ    = $24;  AltK    = $25;  AltL    = $26; {        = $27;
            = $28;          = $29;          = $2A;          = $2B;}
    AltZ    = $2C;  AltX    = $2D;  AltC    = $2E;  AltV    = $2F;
    AltB    = $30;  AltN    = $31;  AltM    = $32; {        = $33;
            = $34;          = $35;          = $36;          = $37;
            = $38;          = $39;          = $3A;} F01     = $3B;
    F02     = $3C;  F03     = $3D;  F04     = $3E;  F05     = $3F;
    F06     = $40;  F07     = $41;  F08     = $42;  F09     = $43;
    F10     = $44; {        = $45;          = $46;} Home    = $47;
    UA      = $48;  PgUp    = $49; {        = $4A;} LA      = $4B;
   {        = $4C;} RA      = $4D; {        = $4E;} KEnd    = $4F;
    DA      = $50;  PgDn    = $51;  Ins     = $52;  KDel    = $53;
    ShfF01  = $54;  ShfF02  = $55;  ShfF03  = $56;  ShfF04  = $57;
    ShfF05  = $58;  ShfF06  = $59;  ShfF07  = $5A;  ShfF08  = $5B;
    ShfF09  = $5C;  ShfF10  = $5D;  CtrlF01 = $5E;  CtrlF02 = $5F;
    CtrlF03 = $60;  CtrlF04 = $61;  CtrlF05 = $62;  CtrlF06 = $63;
    CtrlF07 = $64;  CtrlF08 = $65;  CtrlF09 = $66;  CtrlF10 = $67;
    AltF01  = $68;  AltF02  = $69;  AltF03  = $6A;  AltF04  = $6B;
    AltF05  = $6C;  AltF06  = $6D;  AltF07  = $6E;  AltF08  = $6F;
    AltF09  = $70;  AltF10  = $71;  CtrlStar= $72;  CtrlLA  = $73;
    CtrlRA  = $74;  CtrlEnd = $75;  CtrlPgDn= $76;  CtrlHome= $77;
    Alt1    = $78;  Alt2    = $79;  Alt3    = $7A;  Alt4    = $7B;
    Alt5    = $7C;  Alt6    = $7D;  Alt7    = $7E;  Alt8    = $7F;
    Alt9    = $80;  Alt0    = $81;  AltMin  = $82;  AltEqu  = $83;
    CtrlPgUp= $84;

  IMPLEMENTATION { ASCII }

END { ASCII }.

