;
; Copyright (C) 1991 Julian Byrne. All rights reserved.
;
; Title:	Limit users of an EXE application
; File name:	APPLOCK.ASM
; Version:	1.20
; Usage:	{$O APPLOCK}
; Description:	Attached to an EXE file this restricts the number of
;		simultaneous copies that can be running, adds a password,
;		broadcasts a message and logs to file.
; Dependencies: Novell Netware 2.15
; Author:	Julian Byrne
; Address:	Electrical and Computer Systems Engineering Department
;		Monash University, Wellington Road, Clayton, Victoria, 3168
;		Australia
; Internet:	julian.byrne@monash.edu.au.
; Other nets:	Quaterman & Hoskins "Notable Computer Networks"
;		CACM Oct'86 pp932-971
; History:	91/ 5/ 1 Initial version
;		91/ 5/22 Password can now time out
;			 Now logs whether password entered correctly
;			 Broadcast moved after user limit/password checks
;			 Fixed potential interrupt window crash if application
;			   has stack between 2 and 2.5 K in size.
;		92/10/10 Added wait time after messages
;
; Notes:	This code assumes:
;
; All segment registers point to the same segment.
; Subroutines preserve all registers except AX and those used as arg's.
;
	  .RADIX  10	; Use decimal numbers
	  DOSSEG	; Put data after code
;
; Conditional long jump macros
;
JCL	  MACRO   Target
	  LOCAL   Skip
	  JNC	  SHORT Skip
	  JMP	  Target
Skip:	  ENDM

JNCL	  MACRO   Target
	  LOCAL   Skip
	  JC	  SHORT Skip
	  JMP	  Target
Skip:	  ENDM

JZL	  MACRO   Target
	  LOCAL   Skip
	  JNZ	  SHORT Skip
	  JMP	  Target
Skip:	  ENDM

JNZL	  MACRO   Target
	  LOCAL   Skip
	  JZ	  SHORT Skip
	  JMP	  Target
Skip:	  ENDM

NUL	  EQU	  00H	; ASCII Null character
BEL	  EQU	  07H	; ASCII Bell
BS	  EQU	  08H	; ASCII Back space
LF	  EQU	  0AH	; ASCII Line Feed
CR	  EQU	  0DH	; ASCII Carriage Return
CTRLC	  EQU	  03H	; MSDOS Break
CTRLZ	  EQU	  1AH	; MSDOS End Of File
PassTime  EQU	  546	; Clock ticks to wait for password entry
LogRetry  EQU	  20	; Number of times to retry log file access
LockEndMark EQU   0AAH	; Used to check code link is okay

BIOSDATA  SEGMENT AT 40H
	  ORG	  6CH
SysTime   DW	  ?, ?	; BIOS time counter - a long word which
			;   increments 18.2 times/second
BIOSDATA  ENDS

ALL	  GROUP CODE, DATA
;
; Data specifying what lock actions are to be performed.
; Added in by NETLOCK.PAS at LD: (end of data segment)
; This structure must match LockDataType in NETLOCK.PAS.
;
LockDataType STRUC
DataSize  DW ?	  ; Total size of lock data
Filler	  DB ?
JmpByte   DB ?	  ; JMP [DWORD PTR Chain]
		  ;   Used to overlay exit code
		  ;   for jump to application
Chain	  DW ?, ? ; User program start address
UStack	  DW ?, ? ; User program stack
SizeMin   DW ?	  ; Original user program sizes - used when unlocking app
SizeMax   DW ?
SizeLP	  DW ?
SizePF	  DW ?
SizeLSW   DW ?
SizeMSW   DW ?
Limit	  DB ?	  ; Maximum number of users
LogMode   DB ?	  ; Share restrictions when accessing log file
LogAttr   DW ?	  ; Attributes when creating log file
SemServer DW ?, ? ; File server for semaphore (H to L order)
		  ; Pointers to program messages
WaitTime  DW ?	  ; Clock ticks to wait when displaying messages
pSemName  DW ?	  ;   Novell semaphore name
pLogName  DW ?	  ;   Log file name
pPassword DW ?	  ;   Program password
pMesPQues DW ?	  ;   Password question
pBroName  DW ?	  ;   Broadcast target name
pMesBroa  DW ?	  ;   Broadcast target message
pMesSBad  DW ?	  ;   Error accessing file server
pMesABad  DW ?	  ;   Error accessing semaphore
pMesLBad  DW ?	  ;   Error accessing log file
pMesUBad  DW ?	  ;   Error, user limit exceeded
pMesPBad  DW ?	  ;   Error in password
pMesOk	  DW ?	  ;   Ok, user program started
LockDataType ENDS

DATA	  SEGMENT BYTE 'DATA'
LimData:
K10	  DW	  10		; For DIV instruction
LogHead   DB	  "Lock log v1.1", CR, LF, CTRLZ ; Must match NETLOCK.PAS
LogHeadEnd:
CRLFMes   DB	  2, CR, LF
BELMes	  DB	  1, BEL
SBMMes1   DB	  5, "From "
SBMMes2   DB	  1, "["
SBMMes3   DB	  3, "]: "
MapBMode  DB	  3, 2, 2, 3	; Broadcast mode mapping

PrefCon   DB	  ?		; Preferred connection ID when program started
BroMode   DB	  ?		; Broadcast mode	   "
ErrMode   DB	  ?		; Network error mode	   "
OnCtrlC   DB	  ?		; Ctrl/C intercept state   "
LimitOk   DB	  ?		; True if haven't exceeded user limit
DoFS	  DB	  ?		; True if need to access file server
LogHandle DW	  ?		; Log file handle
OpenTries DW	  ?		; Count of log file open attempts
MesStart  DW	  ?		; Pointer to start of broadcast message
pPSP	  DW	  ?		; Segment pointer to PSP
NewStack  DW	  ?, ?		; Stack to use once lock done
pError	  DW	  ?, ?		; Saved abort handler address
pBreak	  DW	  ?, ?		; Saved break handler address
PassBuf   DB	  80		; Password buffer
	  DB	  ?
	  DB	  80 DUP (?)

GIALen	  DW	  2		; Request packet for "GetInternetAddress"
	  DB	  13H		; Subfunction
GIACon	  DB	  ?		; Connection number

GCILen	  DW	  2		; Request packet for "GetConnectionInformation"
	  DB	  16H		; Subfunction
GCICon	  DB	  ?		; Connection number

GOCNLen   DW	  ?		; Request packet for "GetObjectConnectionNumbers"
	  DB	  15H		; Subfunction
	  DB	  0, 1		; USER in HiLo order
GOCNUser  DB	  ?		; Object length (eg. 10)
	  DB	  47 DUP (?)	; Object name	(eg. "SUPERVISOR")

SBMLen	  DW	  ?		; Request packet for "SendBroadcastMessage"
	  DB	  00H		; SubFunction
SBMData   DB	  101 DUP (?)	; Connection list (eg. 4, 2,4,6,17)
	  DB	  56 DUP (?)	; Message	  (eg. 11, "EXE started")

OCNLen	  DW	  101		; Filled by "GetObjectConnectionNumbers"
OCNCount  DB	  ?
	  DB	  100 DUP (?)

LogData:

LogNum	  DB	  ?		; Current number of program users
LogLim	  DB	  ?		; Maximum number of program users

LogCon	  DB	  ?		; Filled by "GetConnectionNumber"

FSDAT	  DB	  7 DUP (?)	; Filled by "GetFileServerDateAndTime

IALen	  DW	  12		; Filled by "GetInternetAddress"
	  DB	  12 DUP (?)

CILen	  DW	  62		; Filled by "GetConnectionInformation"
	  DB	  6 DUP (?)
CIName	  DB	  55 DUP (?)
PassOk	  DB	  ?		; True if user password okay

LogDataEnd:

	  DB	  LockEndMark	; Lock data end marker
				;   Used to check object link is ok.
;
; This section (LD) is appended to by the NETLOCK program.
; It is right at the end of the binary - see DOSSEG above.
;
LD	  LABEL   LockDataType

DATA	  ENDS

CODE	  SEGMENT BYTE 'CODE'

	  ASSUME  CS:ALL, DS:ALL, ES:ALL, SS:ALL

	  ORG	  0

AppLock   PROC	  FAR

	  DW	  OFFSET ALL:LD 	 ; Size of code segment

	  DB	  "Application Lock  v1.1", CTRLZ, NUL; Must match NETLOCK.PAS
Start:					 ; Marker, not used
	  MOV	  BX, DS		 ; Save program offset

	  MOV	  AX, CS		 ; Initialize segments for MOVSB
	  MOV	  DS, AX		 ;   and lock data area.
	  MOV	  ES, AX
	  CLD

	  MOV	  [pPSP], BX		 ; Save starting values
	  MOV	  [NewStack+2], SS
	  MOV	  [NewStack  ], SP
;
; Make sure code won't abort (leaving password/semname/logname in memory)
;
	  MOV	  AX, 3300H		 ; Save ^C check state
	  INT	  21H
	  MOV	  [OnCtrlC], DL

	  MOV	  DL, 0 		 ; Turn off ^C checking
	  MOV	  AX, 3301H
	  INT	  21H

	  PUSH	  ES			 ; Get break vector
	  MOV	  AX, 3523H
	  INT	  21H
	  MOV	  [pBreak+2], ES
	  MOV	  [pBreak  ], BX
	  POP	  ES

	  MOV	  AX, 2523H		 ; Set break vector to null routine
	  MOV	  DX, OFFSET ALL:BreakHandler
	  INT	  21H

	  PUSH	  ES			 ; Get error vector
	  MOV	  AX, 3524H
	  INT	  21H
	  MOV	  [pError+2], ES
	  MOV	  [pError  ], BX
	  POP	  ES

	  MOV	  AX, 2524H		 ; Set error vector to null routine
	  MOV	  DX, OFFSET ALL:ErrorHandler
	  INT	  21H
;
; Skip all file server access?
;
	  MOV	  AX, [LD.SemServer  ]
	  OR	  AX, [LD.SemServer+2]
	  OR	  AL, AH
	  MOV	  [DoFS], AL
	  CMP	  AL, 0
	  JZ	  SkipFS1		 ; Yes
;
; Get file server data
;
	  PUSH	  ES			 ; Novell API present?
	  MOV	  AX, 7A00H
	  INT	  2FH			 ;   Multiplex interrupt
	  POP	  ES
	  CMP	  AL, 0FFH
	  JZ	  SHORT SkipAPI 	 ;   Yes
	  MOV	  [DoFS], 0		 ;   No, fail
	  JMP	  ExitSBad
SkipAPI:
	  MOV	  AH, 0DEH		 ; Get broadcast mode
	  MOV	  DL, 4
	  INT	  21H
	  MOV	  [BroMode], AL

;	  JCL	  ExitSBad		 ; Error?

	  MOV	  AH, 0DEH		 ; Set broadcast mode
	  MOV	  BH, 0 		 ; 0->3, 1->2, 2->2, 3->3
	  MOV	  BL, AL
	  MOV	  DL, MapBMode[BX]	 ; Store/Reject and don't display
	  INT	  21H

;	  JCL	  ExitSBad		 ; Error?

	  MOV	  AH, 0DDH		 ; Set/get error mode
	  MOV	  DL, 1 		 ; All I/O errors returned in AL
	  INT	  21H
	  MOV	  [ErrMode], AL

;	  JCL	  ExitSBad		 ; Error?

	  MOV	  AX, 0F001H		 ; Get preferred connection ID
	  INT	  21H
	  MOV	  [PrefCon], AL

;	  JCL	  ExitSBad		 ; Error?

	  CALL	  GetExeCon		 ; Get connection ID of executable's
					 ;   fileserver into AX
	  MOV	  DL, AL		 ; Record connection index
	  MOV	  [GIACon], AH		 ; Record connection number
	  MOV	  [GCICon], AH
	  MOV	  [LogCon], AH

	  MOV	  AX, 0F000H		 ; Set preferred connection index
	  INT	  21H

;	  JCL	  ExitSBad		 ; Error?

	  MOV	  AH, 0E3H		 ; Get internet address
	  MOV	  SI, OFFSET ALL:GIALen
	  MOV	  DI, OFFSET ALL:IALen
	  INT	  21H

	  CMP	  AL, 0 		 ; Error?
	  JNZL	  ExitSBad

	  MOV	  AH, 0E7H		 ; Get file server current date & time
	  MOV	  DX, OFFSET ALL:FSDAT
	  INT	  21H

;	  JCL	  ExitSBad		 ; Error?

	  MOV	  AH, 0E3H		 ; Get connection information
	  MOV	  SI, OFFSET ALL:GCILen
	  MOV	  DI, OFFSET ALL:CILen
	  INT	  21H

	  CMP	  AL, 0 		 ; Error?
	  JNZL	  ExitSBad
SkipFS1:
;
; Do user limit lock
;
	  MOV	  AL, 0FFH		 ; Set LimitOk flag TRUE
	  MOV	  [LimitOk], AL

	  MOV	  DX, [LD.pSemName]	 ; Skip lock?
	  CMP	  DX, 0
	  JZ	  SHORT SkipLock	 ;   Yes

	  MOV	  AX, 0BB01H		 ; Set End Of Job Status processing on
	  INT	  21H			 ;   Makes sure sem. will be released

;	  JCL	  ExitABad		 ; Error?

	  MOV	  AX, 0C500H		 ; Open Novell semaphore
	  MOV	  CL, [LD.Limit]
	  MOV	  [LogLim], CL
	  INT	  21H

	  CMP	  AL, 0 		 ; Error?
	  JNZL	  ExitABad

	  MOV	  [LogNum], BL		 ; Save semaphore current open count

	  MOV	  AL, [LD.Limit]	 ; Do user limit check?
	  CMP	  AL, 0
	  JZ	  SHORT SkipLock	 ;   No

	  CMP	  AL, BL		 ; User limit exceeded?
	  JNC	  SHORT SkipLock	 ;   No

	  MOV	  AL, 0 		 ; Set LimitOk flag FALSE
	  MOV	  [LimitOk], AL

	  MOV	  AX, 0C504H		 ; Close semaphore (Handle in CX:DX)
	  INT	  21H

	  CMP	  AL, 0 		 ; Error?
	  JNZL	  ExitABad
SkipLock:
;
; Do password
;
	  MOV	  AL, 0FFH		 ; Set PassOk flag TRUE
	  MOV	  [PassOk], AL

	  MOV	  AX, [LD.pPassword]	 ; Skip password?
	  CMP	  AX, 0
	  JZ	  SHORT SkipPass	 ;   Yes

	  MOV	  AL, [LimitOk] 	 ; Don't bother with password?
	  CMP	  AL, 0
	  JZ	  SHORT SkipPass	 ;   Yes

	  MOV	  BX, [LD.pMesPQues]	 ; Display prompt
	  CALL	  DispMess

	  MOV	  SI, OFFSET ALL:PassBuf ; Get password
	  CALL	  GetPass
	  JC	  SHORT PassBad

	  CALL	  EncPass		 ; Convert to uppercase and encode

	  INC	  SI			 ; Compare entered and stored password
	  MOV	  DI, [LD.pPassword]
	  MOV	  CL, [SI]
	  MOV	  CH, 0
	  INC	  CX
	  CLD
     REPZ CMPSB
	  JZ	  SHORT SkipPass	 ; Password okay?
PassBad:
	  MOV	  AL, 0 		 ;   No, set password okay flag FALSE
	  MOV	  [PassOk], AL
SkipPass:
;
; Do log file
;
	  MOV	  DX, [LD.pLogName]	 ; Skip log?
	  CMP	  DX, 0
	  JZL	  SkipLog		 ;   Yes

	  MOV	  [OpenTries], LogRetry
LogLoop:
	  MOV	  DX, [LD.pLogName]
	  MOV	  AH, 03DH		 ; Open log file
	  MOV	  AL, [LD.LogMode]	 ;   Share deny write, access write
	  INT	  21H
	  MOV	  [LogHandle], AX

	  JNC	  SHORT OpenDone	 ; Open ok

	  CMP	  AL, 5 		 ; Can't open log file for write?
	  JNZ	  SHORT SkipRetry	 ;   No
	  DEC	  [OpenTries]		 ; Retried too many times?
	  JZL	  ExitLBad		 ;   Yes
	  MOV	  AX, 5 		 ; Wait 5 clock ticks (0.27s)
	  CALL	  Delay
	  JMP	  SHORT LogLoop 	 ; Try again
SkipRetry:
	  CMP	  AL, 0FFH		 ; Network error?
	  JZ	  SHORT SkipChk 	 ; Yes, assume it was file not found
	  CMP	  AL, 2 		 ; Log file doesn't exist?
	  JNZL	  ExitLBad		 ; No, unexpected error
SkipChk:
	  MOV	  AH, 05BH		 ; Create log file
	  MOV	  AL, [LD.LogMode ]	 ;   Share deny write, access write
	  MOV	  DX, [LD.pLogName]
	  MOV	  CX, [LD.LogAttr ]	 ; File is shareable attribute
	  INT	  21H
	  MOV	  [LogHandle], AX

	  JNC	  SHORT CreateDone	 ; Created okay
	  CMP	  AL, 80		 ; Already exists?
	  JZ	  SHORT LogLoop 	 ;   Yes, open for write
	  JMP	  ExitLBad		 ; Unexpected error

CreateDone:
	  MOV	  AH, 40H		 ; Write log file header
	  MOV	  BX, [LogHandle]
	  MOV	  CX, OFFSET ALL:LogHeadEnd - OFFSET ALL:LogHead
	  MOV	  DX, OFFSET ALL:LogHead
	  INT	  21H

	  JCL	  ExitLBad		 ; Error?

OpenDone:
	  MOV	  AX, 4202H		 ; Move to end of log file
	  MOV	  BX, [LogHandle]
	  MOV	  CX, 0
	  MOV	  DX, 0
	  INT	  21H

	  JCL	  ExitLBad		 ; Error?

	  MOV	  AH, 40H		 ; Write message to log file
	  MOV	  BX, [LogHandle]
	  MOV	  CX, OFFSET ALL:LogDataEnd - OFFSET ALL:LogData
	  MOV	  DX, OFFSET ALL:LogData
	  INT	  21H

	  JCL	  ExitLBad		 ; Error?

	  MOV	  AH, 3EH		 ; Close log file
	  MOV	  BX, [LogHandle]
	  INT	  21H

	  JCL	  ExitLBad		 ; Error?
SkipLog:
;
; Check user limit
;
	  MOV	  AL, [LimitOk]
	  CMP	  AL, 0
	  JZL	  ExitUBad
;
; Check password
;
	  MOV	  AL, [PassOk]
	  CMP	  AL, 0
	  JZL	  ExitPBad
;
; Do broadcast
;
	  MOV	  SI, [LD.pBroName]	 ; Skip broadcast?
	  CMP	  SI, 0
	  JZL	  SkipBroadcast 	 ;   Yes

	  MOV	  DI, OFFSET ALL:GOCNUser; Setup packet for
	  CALL	  MoveBlock		 ;   "GetObjectConnectionNumbers"

	  SUB	  DI, (OFFSET ALL:GOCNLen)+2; Setup GOCN packet length
	  MOV	  [GOCNLen], DI

	  MOV	  AH, 0E3H		 ; Get Object Connection Numbers
	  MOV	  SI, OFFSET ALL:GOCNLen
	  MOV	  DI, OFFSET ALL:OCNLen
	  INT	  21H

	  CMP	  AL, 0 		 ; Error?
	  JNZL	  ExitSBad

	  MOV	  SI, OFFSET ALL:OCNCount; Setup packet for
	  MOV	  DI, OFFSET ALL:SBMData ; "SendBroadcastMessage" (SBM)
	  CALL	  MoveBlock

	  MOV	  [MesStart], DI
	  INC	  DI

	  MOV	  SI, OFFSET ALL:SBMMes1 ; "From "
	  CALL	  MoveCBlk

	  MOV	  SI, OFFSET ALL:CIName  ; Connection name
	  CALL	  MoveZBlk

	  MOV	  SI, OFFSET ALL:SBMMes2 ; "["
	  CALL	  MoveCBlk

	  MOV	  AL, [LogCon]		 ; Connection number
	  MOV	  AH, 0
	  CALL	  StrInt

	  MOV	  SI, OFFSET ALL:SBMMes3 ; "]: "
	  CALL	  MoveCBlk

	  MOV	  SI, [LD.pMesBroa]	 ; Broadcast message
	  CMP	  SI, 0
	  JZ	  SHORT SkipBMove
	  CALL	  MoveCBlk
SkipBMove:
	  PUSH	  DI			 ; Save length of displayed message
	  MOV	  AX, DI
	  MOV	  DI, [MesStart]
	  SUB	  AX, DI
	  DEC	  AX
	  MOV	  [DI], AL
	  POP	  DI

	  CMP	  AX, 56		 ; Generated message too long?
	  JNCL	  ExitSBad

	  SUB	  DI, (OFFSET ALL:SBMLen)+2; Save length of packet
	  MOV	  [SBMLen], DI

	  MOV	  SI, OFFSET ALL:SBMLen  ; Send Broadcast Message
	  MOV	  DI, OFFSET ALL:SBMLen  ; Discard Ok/Bad acknowledgements
	  MOV	  AH, 0E1H		 ;   from each station
	  INT	  21H

	  CMP	  AL, 0 		 ; Error?
	  JNZL	  ExitSBad
SkipBroadcast:
;
; We made it!
;
	  JMP	  ExitOk		; All checks done, start application

AppLock   ENDP
;
; Wait for signed AX clock ticks (AX/18.2 seconds)
; Handles the case where we are locked out for more than a clock tick
;
Delay	  PROC	  NEAR
	  PUSH	  DS
	  PUSH	  DX
	  PUSH	  AX

	  MOV	  DX, AX
	  MOV	  AX, BIOSDATA
	  MOV	  DS, AX
	  ASSUME  DS:BIOSDATA
	  ADD	  DX, [SysTime]

Delay1:   MOV	  AX, [SysTime] ; Check if past current time
	  SUB	  AX, DX
	  JS	  SHORT Delay1

	  POP	  AX
	  POP	  DX
	  POP	  DS
	  ASSUME  DS:ALL
	  RET
Delay	  ENDP
;
; Move a block with a one byte length prefix from DS:[SI] to ES:[DI]
; On exit SI and DI points after argument and result
;
MoveBlock PROC	  NEAR
	  PUSH	  CX

	  CLD
	  MOV	  CL, [SI]
	  MOV	  CH, 0
	  INC	  CX			 ; Move length byte too
      REP MOVSB

	  POP	  CX
	  RET
MoveBlock ENDP
;
; Move a constant block without the length byte prefix from DS:[SI] to ES:[DI]
; On exit SI and DI points after argument and result
;
MoveCBlk  PROC	  NEAR
	  PUSH	  CX

	  CLD
	  MOV	  CL, [SI]
	  MOV	  CH, 0
	  INC	  SI			 ; Skip length byte
      REP MOVSB

	  POP	  CX
	  RET
MoveCBlk ENDP
;
; Move a zero terminated block without transferring zero byte.
; On exit SI and DI points after argument and result.
;
MoveZBlk  PROC	  NEAR
	  PUSH	  AX
	  PUSH	  CX

	  CLD
MoveZBlk1:LODSB
	  CMP	  AL, NUL
	  JZ	  SHORT MZBDone
	  STOSB
	  JMP	  SHORT MoveZBlk1

MZBDone:  POP	  CX
	  POP	  AX
	  RET
MoveZBlk  ENDP
;
; Convert an integer in AX to a decimal string in ES:[DI].
; On exit DI points after result.
;
StrInt	  PROC	  NEAR
	  CLD
StrInt1:  CMP	  AX, 10
	  JC	  SHORT SIDone

	  PUSH	  DX
	  MOV	  DX, 0
	  DIV	  [K10]
	  CALL	  StrInt1
	  MOV	  AX, DX
	  POP	  DX

SIDone:   ADD	  AL, '0'
	  STOSB
	  RET
StrInt	  ENDP
;
; Get connection for file server specified in LD.SemServer into AL/AH.
;
GetExeCon PROC	  NEAR
	  PUSH	  CX
	  PUSH	  SI
	  PUSH	  ES
	  MOV	  AX, 0EF03H		 ; "Get connection ID table"
	  INT	  21H

;	  JC	  SHORT ExeCon3 	 ; Error?

	  MOV	  CL, 1 		 ; Scan table for executable's server
GetExeCon1:
	  CMP	  BYTE PTR ES:[SI+ 0],	0; Entry in use?
	  JZ	  SHORT GetExeCon2	 ;   No
	  CMP	  BYTE PTR ES:[SI+23], -1; Connection?
	  JZ	  SHORT GetExeCon2	 ;   No
	  CMP	  BYTE PTR ES:[SI+24], -1; Connection okay?
	  JNZ	  SHORT GetExeCon2	 ;   No
	  MOV	  AX, [LD.SemServer]	 ; Match server MSW?
	  CMP	  WORD PTR ES:[SI+ 2], AX
	  JNZ	  SHORT GetExeCon2	 ;   No
	  MOV	  AX, [LD.SemServer+2]	 ; Match server LSW?
	  CMP	  WORD PTR ES:[SI+ 4], AX
	  JNZ	  SHORT GetExeCon2	 ;   No
	  MOV	  AL, CL		 ; Get connection index (1-8) for server
	  MOV	  AH, BYTE PTR ES:[SI+23]; Get connection number
	  JMP	  SHORT GetExeCon4
GetExeCon2:
	  ADD	  SI, 32
	  INC	  CL
	  CMP	  CL, 9
	  JC	  SHORT GetExeCon1
GetExeCon3:
	  MOV	  AX, 0
GetExeCon4:
	  POP	  ES
	  POP	  SI
	  POP	  CX
	  RET
GetExeCon ENDP
;
; Get a key without waiting into AL. Z is set if no key is available.
;
GetKey	  PROC	  NEAR
	  PUSH	  DX		; Read key without echo or wait into AL
	  MOV	  AH, 006H
	  MOV	  DL, 0FFH
	  INT	  21H
	  POP	  DX
	  RET
GetKey	  ENDP
;
; Get a key into AL, waiting if necessary
;
WaitKey   PROC	  NEAR
WaitKey1: CALL	  GetKey
	  JZ	  SHORT WaitKey1
	  RET
WaitKey   ENDP
;
; Wait for key or timeout.
; Entry: DX	Signed number of clock ticks to timeout on
; Used:  AX
; Exit:  DX	Number of clock ticks left
;	 AL	Character if Z clear. No character (timeout) if Z set.
;
TimeKey   PROC	  NEAR
	  PUSH	  DS

	  MOV	  AX, BIOSDATA
	  MOV	  DS, AX
	  ASSUME  DS:BIOSDATA
	  ADD	  DX, [SysTime]

TimeKey1: MOV	  AX, [SysTime]
	  SUB	  AX, DX
	  AND	  AX, 8000H
	  JZ	  SHORT TimeKey2

	  CALL	  GetKey
	  JZ	  SHORT TimeKey1

TimeKey2: PUSHF 		; Recover clock ticks left before timeout
	  SUB	  DX, [SysTime]
	  POPF

	  POP	  DS
	  ASSUME  DS:ALL
	  RET
TimeKey   ENDP
;
; Convert a password pointed to by DS:[SI] to uppercase and encode it.
;
EncPass   PROC	  NEAR
	  PUSH	  AX
	  PUSH	  SI
	  PUSH	  CX
	  INC	  SI
	  MOV	  CH, 05AH	 ; Encode start seed
	  MOV	  CL, [SI]
	  CMP	  CL, 0
	  JZ	  SHORT EncPass3
EncPass1: INC	  SI
	  MOV	  AL, [SI]
	  CMP	  AL, 'a'        ; Convert AL to uppercase
	  JC	  SHORT EncPass2
	  CMP	  AL, 'z'+1
	  JNC	  SHORT EncPass2
	  ADD	  AL, 'A'-'a'
EncPass2: XOR	  CH, AL	 ; Encode next byte
	  MOV	  [SI], CH
	  DEC	  CL
	  JNZ	  SHORT EncPass1
EncPass3: POP	  CX
	  POP	  SI
	  POP	  AX
	  RET
EncPass   ENDP
;
; Get an unechoed, buffered input line into DS:SI within 30 seconds.
;   Byte 1 is the maximum number of characters in buffer
;   Byte 2 is the number of characters read
;   Byte 3 onwards are the characters
; If C is set on exit then timeout or ^C occurred and no valid line is returned
;
GetPass   PROC	  NEAR
	  PUSH	  AX
	  PUSH	  BX
	  PUSH	  CX
	  PUSH	  DX

	  MOV	  DX, PassTime	; Time to wait for password entry
	  MOV	  BX, SI
	  MOV	  CL, 0 	; Current buffer length
	  MOV	  CH, [BX]	; Maximum buffer length
	  ADD	  BX, 2 	; Current buffer position
GetPass1:
	  CALL	  TimeKey	; Wait for key without echo or timeout
	  STC
	  JZ	  SHORT GetPass5;   Timeout

	  CMP	  AL, CTRLC	; Break pressed?
	  STC
	  JZ	  SHORT GetPass5;   Yes

	  CMP	  AL, CR	; Enter pressed?
	  JZ	  SHORT GetPass4;   Yes

	  CMP	  AL, BS	; Delete pressed?
	  JNZ	  SHORT GetPass2;   No
	  CMP	  CL, 0 	; Buffer non-empty?
	  JZ	  SHORT GetPass3;   No

	  DEC	  BX		; Remove last character in buffer
	  DEC	  CL
	  JMP	  SHORT GetPass1
GetPass2:
	  CMP	  CL, CH	; Room in buffer?
	  JZ	  SHORT GetPass3;   No

	  MOV	  [BX], AL	; Place character in buffer
	  INC	  BX
	  INC	  CL
	  JMP	  SHORT GetPass1
GetPass3:
	  CALL	  Beep		; Entry error
	  JMP	  SHORT GetPass1
GetPass4:			; Done entry
	  MOV	  BX, SI	; Save current length
	  INC	  BX
	  MOV	  [BX], CL

	  MOV	  BX, OFFSET ALL:CRLFMes; Acknowledge entry done
	  CALL	  DispMess
	  CLC
GetPass5:
	  POP	  DX
	  POP	  CX
	  POP	  BX
	  POP	  AX
	  RET
GetPass   ENDP
;
; Beep standard output
;
Beep	  PROC	  NEAR
	  PUSH	  BX
	  MOV	  BX, OFFSET ALL:BELMes
	  CALL	  DispMess
	  POP	  BX
	  RET
Beep	  ENDP
;
; Display a message pointed to by DS:BX on standard output and wait
;
DispWait  PROC	  NEAR
	  CMP	  BX, 0
	  JZ	  SHORT DispWait4
	  CALL	  DispMess
	  PUSH	  DX
	  PUSH	  AX
	  MOV	  DX, [LD.WaitTime]
	  CMP	  DX, 0
	  JZ	  SHORT DispWait3   ; No wait
	  CMP	  DX, 0FFFFH
	  JNZ	  SHORT DispWait1   ; Wait for key or timeout
	  CALL	  WaitKey	    ; Wait for key
	  JMP	  SHORT DispWait2
DispWait1:CALL	  TimeKey
	  JZ	  SHORT DispWait3   ; Timeout
DispWait2:CMP	  AL, NUL	    ; Handle function keys
	  JNZ	  SHORT DispWait3
	  CALL	  WaitKey
DispWait3:POP	  AX
	  POP	  DX
DispWait4:RET
DispWait  ENDP
;
; Display a message pointed to by DS:BX on standard output
;
DispMess  PROC	  NEAR
	  CMP	  BX, 0
	  JZ	  SHORT DispMess1
	  PUSH	  AX
	  PUSH	  BX
	  PUSH	  CX
	  PUSH	  DX
	  MOV	  AH, 40H		 ; Write Handle function
	  MOV	  CL, [BX]		 ; Number of bytes
	  MOV	  CH, 0
	  MOV	  DX, BX		 ; Pointer
	  INC	  DX
	  MOV	  BX, 1 		 ; Standard Output handle
	  INT	  21H
					 ; Ignore any errors
	  POP	  DX
	  POP	  CX
	  POP	  BX
	  POP	  AX
DispMess1:RET
DispMess  ENDP

BreakHandler PROC NEAR
	  IRET				 ; Ignore all ^C's
BreakHandler ENDP

ErrorHandler PROC NEAR
;	  PUSHF 			 ; Issue Abort, Retry, Ignore?
;	  CALL	  [DWORD PTR CS:pError]
	  AND	  AL, 8 		 ; Fail allowed?
	  JZ	  SHORT ErrorHandler1
	  MOV	  AL, 3 		 ; Fail system call in progress
	  IRET
ErrorHandler1:
	  MOV	  AL, 0 		 ; Ignore the error
	  IRET
ErrorHandler ENDP

Done	  PROC	  FAR
ExitSBad: MOV	  BX, [LD.pMesSBad]	 ; Error: accessing server
	  JMP	  SHORT ExitOMes
ExitABad: MOV	  BX, [LD.pMesABad]	 ; Error: accessing lock semaphore
	  JMP	  SHORT ExitOMes
ExitLBad: MOV	  BX, [LD.pMesLBad]	 ; Error: accessing log file
	  JMP	  SHORT ExitOMes
ExitUBad: MOV	  BX, [LD.pMesUBad]	 ; Error: user limit exceeded
	  JMP	  SHORT ExitOMes
ExitPBad: MOV	  AX, 18		 ; Delay 1s to hinder break in attempts
	  CALL	  Delay
	  MOV	  BX, [LD.pMesPBad]	 ; Error: invalid password
	  JMP	  SHORT ExitOMes
ExitOk:   MOV	  BX, [pPSP]		 ; Setup chaining to user program
	  ADD	  BX, 10H		 ;   Skip PSP
	  MOV	  AX, [LD.UStack+2]	 ; Setup application stack
	  ADD	  AX, BX
	  MOV	  [NewStack+2], AX
	  MOV	  AX, [LD.UStack  ]
	  MOV	  [NewStack  ], AX
	  MOV	  AX, [LD.Chain+2]	 ; Setup application start address
	  ADD	  AX, BX
	  MOV	  [LD.Chain+2], AX
	  MOV	  SI, OFFSET ALL:LD.JmpByte; Change termination code to
	  MOV	  DI, OFFSET ALL:CodeExit;  jump to user program
	  MOV	  CX, 5
	  CLD
      REP MOVSB
	  MOV	  BX, [LD.pMesOk]	 ; Successful start message
	  JMP	  SHORT ExitOMes
ExitOMes:
	  CALL	  DispWait

	  MOV	  AL, [DoFS]		 ; Accessing file server?
	  CMP	  AL, 0
	  JZ	  SHORT SkipFS2 	 ;   No

	  MOV	  AX, 0F000H		 ; Set preferred connection index
	  MOV	  DL, [PrefCon]
	  INT	  21H

	  MOV	  AH, 0DDH		 ; Set network error mode
	  MOV	  DL, [ErrMode]
	  INT	  21H

	  MOV	  AH, 0DEH		 ; Set/get broadcast mode
	  MOV	  DL, [BroMode]
	  INT	  21H
SkipFS2:
	  PUSH	  DS			 ; Restore error vector
	  MOV	  AX, 2524H
	  LDS	  DX, [DWORD PTR pError]
	  INT	  21H
	  POP	  DS

	  PUSH	  DS			 ; Restore break vector
	  MOV	  AX, 2523H
	  LDS	  DX, [DWORD PTR pBreak]
	  INT	  21H
	  POP	  DS

	  MOV	  AX, 3301H		 ; Restore ^C check state
	  MOV	  DL, [OnCtrlC]
	  INT	  21H

	  MOV	  CX, SP		 ; Total data size, including stack
	  SUB	  CX, OFFSET ALL:LimData
	  MOV	  DI, OFFSET ALL:LimData

	  MOV	  DX, [NewStack+2]	 ; Save variables about to be erased
	  MOV	  BP, [NewStack  ]
	  MOV	  SI, [LD.SizeLSW]
	  MOV	  BX, [LD.SizeMSW]
	  MOV	  AX, [pPSP]
	  MOV	  DS, AX
	  MOV	  AX, 0 		 ; Zero unused registers
	  CLD				 ; Erase sensitive data
      REP STOSB
					 ; Erase sensitive code
	  MOV	  CX, OFFSET ALL:CodeEnd - OFFSET ALL:AppLock
	  MOV	  DI, OFFSET ALL:AppLock
CodeEnd:
      REP STOSB
	  MOV	  CX, DS		 ; Set ES=DS=PSP
	  MOV	  ES, CX
	  MOV	  CX, SI		 ; SizeLSW
	  MOV	  SI, AX		 ; Zero unused registers
	  MOV	  DI, AX
	  PUSH	  AX
	  POPF				 ; Implicit CLI
	  MOV	  SS, DX		 ; Restore application/lock stack
	  MOV	  SP, BP
	  MOV	  DX, AX		 ; Zero unused registers
	  MOV	  BP, AX
	  STI
CodeExit:
	  MOV	  AX, 4CFFH		 ;*** Terminate user program (5 bytes)
	  INT	  21H			 ;***	May be overwritten with a jump
Done	  ENDP				 ;***	to the application

CODE	  ENDS

	  END
