;
; Copyright (C) 1991 Julian Byrne. All rights reserved.
;
; Title:        Execute any sub-process
; File name:    ANY.ASM
; Version:      1.00
; Usage:        ANY
; Description:  Executes a sub-process with a command line. The name of the
;               application to be executed in the sub-process is encoded
;               in ANY's binary - See PATCHANY.PAS.
; Dependencies: none
; Author:       Julian Byrne
; Address:      Electrical and Computer Systems Engineering Department
;               Monash University, Wellington Road, Clayton, Victoria, 3168
;               Australia
; Internet:     julian.byrne@monash.edu.au.
; Other nets:   Quaterman & Hoskins "Notable Computer Networks"
;               CACM Oct'86 pp932-971
; History:      91/ 5/ 1 Initial version
; Notes:
;
          .RADIX  10
          DOSSEG

STACKSIZE EQU     64
PSPSIZE   EQU     100H

PSP       STRUC                         ; Program Segment Prefix
INT20     DW      ?
TopOfMem  DW      ?
          DB      ?
CALLFAR   DB      ?
SegSize   DD      ?
pTerm     DD      ?
pBreak    DD      ?
pError    DD      ?
          DB       22 DUP (?)
pEnv      DW      ?           ; 2C
          DB       46 DUP (?)
FCB1      DB       16 DUP (?) ; 5C
FCB2      DB       20 DUP (?) ; 6C
Param     DB      128 DUP (?) ; 80
PSP       ENDS

CODE      SEGMENT BYTE 'CODE'
SEG_PSP   EQU     (SEG CODE)-10H
          ASSUME  CS:CODE, SS:CODE, DS:CODE, ES:CODE ; ES,DS really SEG_PSP

ANY       PROC    FAR
          JMP     Start             ; Skip to initialization code
Name:     DB      64 DUP (?)        ; Command to execute
          DB      STACKSIZE DUP (?) ; Stack
StackTop:
;
; Parameter block used by Load and Execute Program
;
ParBlock: DW      0             ; Segment address of passed environment
          DW      OFFSET Param  ; Command line
          DW      SEG_PSP
          DW      OFFSET FCB1   ; FCB to be placed at 5CH
          DW      SEG_PSP
          DW      OFFSET FCB2   ; FCB to be placed at 6CH
          DW      SEG_PSP
Finish:
      REP STOSB                 ; Erase sensitive data/code at: ES:[DI] length CX

          INT     21H           ; Execute set block at: ES: length BX
          JC      SHORT Done

          MOV     AX, 4B00H     ; Load and execute program
          MOV     BX, PSPSIZE + (OFFSET ParBlock) ; ES: pointing at PSP
          INT     21H
          JC      SHORT Done

          MOV     AH, 4DH       ; Get return code of child process
          INT     21H
Done:
          CLD                   ; Erase rest of sensitive code
          MOV     CX, (OFFSET EndCode) - (OFFSET ANY)
          MOV     DI, PSPSIZE + (OFFSET ANY) ; ES: pointing at PSP
EndCode:
;
; All code before this mark is erased before exitting
;
      REP STOSB                 ; Erase sensitive data/code at: ES:[DI] len CX
          MOV     AH, 4CH       ; End Process
          INT     21H
;
; All code after this mark is erased before executing sub-process
;
Start:    MOV     AX, CS
          MOV     SS, AX
          MOV     SP, OFFSET StackTop ; Use stack lower in memory

          CLD
          MOV     SI, PSPSIZE + (OFFSET Name ) ; DS:
          CALL    DecPass

          MOV     AH, 4AH       ; Set block function. Frees memory for execute
          MOV     BX, (PSPSIZE+(OFFSET Start)-(OFFSET ANY)+0FH) / 16
          MOV     CX, (OFFSET LastByte) - (OFFSET Start) + STACKSIZE
          MOV     DX, PSPSIZE + (OFFSET Name ) ; DS: pointing at PSP
          MOV     DI, PSPSIZE + (OFFSET Start) ; ES: pointing at PSP

          JMP     SHORT Finish  ; Go lower in memory
ANY       ENDP

DecPass   PROC    NEAR
          MOV     AH, 5AH
DecPass1: MOV     AL, [SI]      ; DS:
          MOV     BL, AL
          XOR     AL, AH
          MOV     [SI], AL      ; DS:
          MOV     AH, BL
          INC     SI
          CMP     AL, 0
          JNZ     SHORT DecPass1
          RET
DecPass   ENDP

LastByte:

CODE      ENDS

STACKSEG  SEGMENT PARA STACK 'STACK'
          DB      STACKSIZE DUP (?)
STACKSEG  ENDS

          END     ANY

