
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1995
//------------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <string.h>
#include "..\ipx.h"
#include "getkeyl.h"
#include "videol.h"

void sendpacket ( char * );

unsigned short ra;
unsigned short rb;

unsigned char line=2;
unsigned short keycode;
unsigned char keychar;
unsigned char buffer[80];
unsigned char buflen=0;

#define NPACKETS 10
#define PACKETSIZE 80

FILE *fp;
char gstring[256];
char astring[256];
unsigned short linecount;
typedef struct
{
    char *code;
    char *name;
} NAMELIST;
NAMELIST *namelist;
unsigned char namecount=0;

unsigned short socket=0x2010;

char source[256];

IPXECB recb[NPACKETS];
IPXECB secb;

IPXHEADER rheader[NPACKETS];
IPXHEADER sheader;

unsigned char rbuffer[NPACKETS][PACKETSIZE];
unsigned char sbuffer[PACKETSIZE];

//------------------------------------------------------------------------------
void main ( int argc, char *argv[] )
{
    if(argc==1)
    {
        printf("Socket not specified\n");
        exit(1);
    }
    socket=atoi(argv[1]);
    if(socket==0)
    {
        printf("Invalid socket %u\n",socket);
        exit(1);
    }
    namelist=malloc(sizeof(NAMELIST));
    if(namelist==NULL)
    {
        printf("Error allocating memory\n");
        exit(1);
    }
    fp=fopen("users","rt");
    if(fp!=NULL)
    {
        linecount=0;
        while(1)
        {
            linecount++;
            if(fgets(gstring,sizeof(gstring),fp)==NULL)  break;
            if(gstring[strlen(gstring)-1]==0x0A)
            {
                gstring[strlen(gstring)-1]=0;
            }
            //kill comments
            for(ra=0;gstring[ra];ra++)
            {
                if((gstring[ra]=='#')||(gstring[ra]==';'))
                {
                    gstring[ra]=0;
                    break;
                }
            }
            //kill spaces
            for(ra=0;gstring[ra];ra++)
            {
                while(gstring[ra]==' ')
                {
                    for(rb=ra+1;gstring[rb];rb++) gstring[rb-1]=gstring[rb];
                    gstring[rb-1]=0;
                }
            }
            if(!gstring[0]) continue;
            //split on =
            for(ra=0;gstring[ra];ra++) if(gstring[ra]=='=') break;
            if(!gstring[ra])
            {
                printf("Syntax error on line %u\n",linecount);
                continue;
            }
            gstring[ra]=0;
            strcpy(astring,&gstring[ra+1]);
            //capitalize
            for(ra=0;gstring[ra];ra++) if((gstring[ra]<123)&&(gstring[ra]>96)) gstring[ra]&=0xDF;
            if((namelist=realloc(namelist,(namecount+1)*sizeof(NAMELIST)))==NULL)
            {
                printf("Memory allocation error\n");
                exit(1);
            }
            if((namelist[namecount].code=malloc(strlen(gstring)+1))==NULL)
            {
                printf("Memory allocation error\n");
                exit(1);
            }
            strcpy(namelist[namecount].code,gstring);
            if((namelist[namecount].name=malloc(strlen(astring)+1))==NULL)
            {
                printf("Memory allocation error\n");
                exit(1);
            }
            strcpy(namelist[namecount].name,astring);
            namecount++;
            //printf("[%u][%s]=[%s]\n",linecount,gstring,astring);
        }
    }
    if(!ipxinit())
    {
        printf("IPX not installed\n");
        exit(1);
    }
    switch(ipxopensocket(0x00,&socket))
    {
        case 0x00: //Success
            break;
        case 0xFE:
            printf("Socket Table Full\n");
            exit(1);
        case 0xFF:
            printf("Socket Already Open\n");
            exit(1);
    }
    for(ra=0;ra<NPACKETS;ra++)
    {
        recb[ra].socket=socket;
        recb[ra].esraddress=NULL;
        recb[ra].fragcount=2;
        recb[ra].fragaddr1=&rheader[ra];
        recb[ra].fragsize1=sizeof(IPXHEADER);
        recb[ra].fragaddr2=&rbuffer[ra];
        recb[ra].fragsize2=sizeof(rbuffer);
        ipxlistenforpacket(&recb[ra]);
    }

    sendpacket("On-line");

    setvmode(3);
    normcursor();
    setcurpos(0,24);
    printf("ALT-X or ALT-Q to Exit   ESC to clear line   RETURN to send line");
    setcurpos(0,0);
    while(1)
    {
        ipxrelenquishcontrol();
        /*check for packets*/
        for(ra=0;ra<NPACKETS;ra++)
        {
            if(!recb[ra].inuse)
            {
                if(strcmp(rbuffer[ra],"CHAT")==0)
                {
                    sprintf(source,"%02X%02X%02X%02X%02X%02X",rheader[ra].source.nodeadd[0],rheader[ra].source.nodeadd[1],rheader[ra].source.nodeadd[2],rheader[ra].source.nodeadd[3],rheader[ra].source.nodeadd[4],rheader[ra].source.nodeadd[5]);
                    for(rb=0;rb<namecount;rb++)
                    {
                        if(strcmp(source,namelist[rb].code)==0)
                        {
                            strcpy(source,namelist[rb].name);
                            break;
                        }
                    }
                    setcurpos(0,line++);
                    printf("[%s] %s",source,&rbuffer[ra][5]);
                    if(line>20) line=2;
                    setcurpos(0,line);
                    printf("                                                                                ");
                    setcurpos(buflen,0);
                }
                recb[ra].socket=socket;
                recb[ra].esraddress=NULL;
                recb[ra].fragcount=2;
                recb[ra].fragaddr1=&rheader[ra];
                recb[ra].fragsize1=sizeof(IPXHEADER);
                recb[ra].fragaddr2=&rbuffer[ra];
                recb[ra].fragsize2=sizeof(rbuffer);
                ipxlistenforpacket(&recb[ra]);
            }
        }

        keycode=getkey();
        if(keycode)
        {
            if((keycode==0x1000)||(keycode==0x2D00)) /*ALT-Q ALT-X*/
            {
                sendpacket("Off-line");
                ipxrelenquishcontrol();
                ipxclosesocket(socket);
                setvmode(3);
                exit(0);
            }
            if(keycode==0x011B) /*ESC*/
            {
                buflen=0;
                setcurpos(0,0);
                printf("                                                                              ");
                setcurpos(0,0);
            }
            if(keycode==0x1C0D) /*RETURN*/
            {
                if(buflen)
                {
                    buffer[buflen]=0;
                    sendpacket(buffer);
                    buflen=0;
                    setcurpos(0,0);
                    printf("                                                                                ");
                    setcurpos(0,0);
                }
            }
            if((keycode==0x0E08)||(keycode==0x5300)) /*BACKSPACE DEL*/
            {
                if(buflen) buflen--;
                ttyout(0x08);
                ttyout(0x20);
                ttyout(0x08);
            }
            keychar=keycode&255;
            if((keychar>31)&&(keychar<127))
            {
                if(buflen<65)
                {
                    buffer[buflen++]=keychar;
                    ttyout(keychar);
                }
            }
        }
    }
}
//------------------------------------------------------------------------------
void sendpacket ( char *s )
{
    strcpy(sbuffer,"CHAT");
    strcpy(&sbuffer[5],s);
    for(ra=0;ra<4;ra++) sheader.dest.netadd[ra]=0x00;
    for(ra=0;ra<6;ra++) sheader.dest.nodeadd[ra]=0xFF;
    for(ra=0;ra<6;ra++) secb.immedaddr[ra]=0xFF;
    sheader.dest.socket=socket;
    secb.socket=socket;
    secb.esraddress=NULL;
    sheader.type=4;
    secb.fragcount=2;
    secb.fragaddr1=&sheader;
    secb.fragsize1=sizeof(IPXHEADER);
    secb.fragaddr2=sbuffer;
    secb.fragsize2=sizeof(sbuffer);
    ipxsendpacket(&secb);
}
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1995
//------------------------------------------------------------------------------

