(* program S2S.PAS

Version 1994d

Changes strings into strings by a conversion table (.CTB)

April 13, 1994, revised S2S.DOC.

February 12, 1994, increased stack size to lessen the risk that the 
recursive parsing procedure for the Exclude option causes overflow.
Fixed parsing of tablefile name to allow for directory names with 
extensions.

February 6, 1994, attempt to fix problems that relate to the
	border between two consequtive strings by accepting that
	there may be a character that is never part of a table string
    and appears often enough to be used as a safe cut-off point.
    <SPACE> will be used for that.


aug 25, 1993, added option to exclude treatment of strings inside
specified markers, from '{' to '}'.


aug 22, 1993, conversion protected
(once converted, part of string will no more be
reconverted)

aug 23: add sorting conversion table so that long sources are
examined first


written by jukka-pekka.takala@helsinki.fi

*)

{$M 25000,0,655360} {stack increased because recursive procedure}

const StrL=10;
      GTLnL = 160;
      ArrSiz = 255;
var   ArrS_R : integer;
      OvrS  : String;

const CommCh = ';'; {character to start a comment line in .CTB}
      SplitCh = ^i;  {character that separates source & target in .CTB.
                      TAB (^i) or space recommended }
      ProtCh = #1;  {'protects' converted parts of string;
                      must not appear in text or in .CTB }
      BegExcl = '{';
      EndExcl = '}';
      CutOffCh = ' '; {space as a cut off character to get short
		               enougth strings}
var   TreatOn : Boolean;
      ExclOn  : Boolean;

type Str=String[StrL];

var fi,fo, ftbl: text;
    fin,fon,ftbln:string[50];
type TblLineT = record
                  ExmStr:Str;
                  OutStr:Str;
                  end;
type TblArrT = Array[1..ArrSiz] of TblLineT;
var  TblArr : TblArrT;
    GtLine : String[GtLnL];
type
    CVSAT =  Array[1..255] of Str;
var ConvS_Arr : CVSAT;
    OutLine : String;
    OutCh : Char;
    i : integer;
    Reverse : boolean;


Procedure DoError;
 var hl:string[60];
begin
 hl := paramstr(0);
 while pos('\',hl)>0 do delete(hl,1,pos('\',hl));
 while pos('.',hl)>0 do delete(hl,pos('.',hl),4);
 writeln('Format: ');writeln;
 writeln( hl, ' INFILE OUTFILE TABLE.CTB [/R] [/X]');
 writeln;
 writeln('Normally source string left, target right: /R reverses');
 write('When "/X" is specified, text between "',BegExcl,'" and "',EndExcl);
 writeln('" will not be converted'); writeln;
 writeln('''outfile'' will be overwritten without warning');
 writeln('Max length of strings in conversion table ',StrL);
 writeln('Max no. of such strings: ',ArrSiz);
 writeln(
  'Program assumes text can be cut off at CR/LF and at ASCII ',
    ord(CutOffcH));
 writeln(
  'Current separator character in conversion table: ASCII ',ord(SplitCh));
 writeln(
  'Table or text must currently not include this character : ASCII ',ord(ProtCh));
 halt;
end;

Function UpStr(s: String): String;
 var i : byte;
begin
 for i := 1 to length(s) do
  UpStr[i] := upcase(s[i]);
end;

Procedure ChkLegal( l:string; fn:string );  {must not contain ProtCh}
begin
  if pos( ProtCh, l ) > 0 then
   begin
    writeln(
      ^g,'illegal chracter (ASCII ',ord(ProtCh), ') in ',fn,'.  Aborted.');
    halt;

   end;
end;

Procedure Swap_S(var s1:Str; var s2:str);
var tmp:str;
begin
 tmp := s1;
 s1:=s2;
 s2:=tmp;
end;

Procedure Bsort(var TbA:TblArrT; c: integer);
  var x : TblLineT; i, j : integer; sorted: boolean;
begin
repeat
sorted := true;
  for i := 1 to c-1 do
   begin
     if length( TbA[ i+1 ].ExmStr) > length(TbA[i].ExmStr) then
        begin
          x:=TbA[i]; TbA[i] := TbA[i+1]; TbA[i+1] := x;
          sorted := false;
        end;
   end;
until sorted;
end;

Procedure InitTable;
 var Line : string;
     count:byte;
     entry : boolean;

procedure Analyze(s:string; var exm, out : Str);
var  s_s : array[1..2] of string[40];
       i,j : byte;
const  tab  = '<TAB>';
begin
 s_s[1]:=copy(s,3,pos(splitch,s)-3);
 s_s[2]:=copy(s,pos(splitch,s)+1, length(s));
 for i := 1 to 2 do begin
    j := pos(tab,s_s[i]);
    while j > 0 do begin
         delete(s_s[i],j ,length(tab));
         insert(#9,s_s[i], j );
         j := pos(tab,s_s[i]);
        end;
   end;
exm := s_s[1];
out := s_s[2];
end;

 begin
   {check file.ext for some security }
    if copy(Ftbln,length(ftbln)-3,4) <> '.CTB'
     then begin writeln('Need a *.CTB file'); halt; end;
   if copy(Fon,length(Fon)-3,4) = '.CTB'
     then begin writeln('cannot output to *.CTB file'); halt; end;
   FillChar( TblArr, SizeOf(TblArr), 0);
   reset(Ftbl);
   count:= 1;
   repeat
    readln(Ftbl, Line);
    if Line <> '' then
    begin
      ChkLegal(Line, Ftbln);
      if (Line[ 1 ] <> ';') then
        begin
          entry := true;
          TblArr[count].ExmStr:= copy(Line,1,pos(SplitCh,line)-1);
          TblArr[count].OutStr:= copy(
            Line, pos(SplitCh,line)+1, Length( Line ) - pos(SplitCh,line)+1);
         end
       else
         if pos(';;',Line)=1 then begin  {exception line}
           entry := true;
           with TblArr[Count] do AnalYZE(Line, ExmStr, OutStr);
         end
          else entry := false;
      if entry then
       begin
        If reverse then with TblArr[count] do Swap_s(ExmStr, OutStr);
        count := count + 1;
        if count > ArrSiz then begin
          writeln('table too big, max ',arrsiz ); halt; end;
       end;
    end;
   until eof(Ftbl);
   ArrS_R := Count - 1;
   Bsort(TblArr,ArrS_R);
 end;


Procedure Treat(var l : String;
                    var CVSA: CVSAT;
                    i:byte);
    var j,k : byte;
 Begin
   j := Pos(TblArr[i].ExmStr, l );
   while j > 0 do
   Begin
     Delete( l , j,
             Length(TblArr[i].ExmStr));
     for K := 1 to length(TblArr[i].ExmStr)    {insert protchar string}
       do Insert( ProtCh, l, j);
     CVSA[j] := TblArr[i].OutStr;
     j := Pos(TblArr[i].ExmStr, l );
   end;
  End;

procedure  Merge(var s: string; CVSA:CVSAT);
  var k : byte; l :string;
begin
 l := '';
 for k := 1 to length(s) do
  if s[k] <> ProtCh then l := l + s[k]
    else l:=l+CVSA[k];
 s:=l;
end;


Procedure Conv(var s : string );
    var i : byte;
  begin
   FillChar(ConvS_Arr, SizeOf(ConvS_Arr), 0);
   For i := 1 to ArrS_R do
     if TblArr[i].ExmStr <>'' then
        Treat( s, ConvS_Arr, i );
   Merge(S, ConvS_Arr);
end;

Procedure Parse(var s : string);
  var s1,s2 : string;
begin
  if TreatOn then
     if pos(BegExcl,s) < 1
         then Conv(s)
       else
       begin
            s1:=copy(s,1,pos(BegExcl,s));
            s2:=copy(s,pos(BegExcl,s)+1,length(s));
            TreatOn := False;
            conv(s1);
            Parse(s2);
            s:=s1+s2;
      end
    else {TreatOn=false}
      if pos(EndExcl,s) < 1
         then {do nothing} begin end
       else
        begin
           s1:=copy(s,1,pos(EndExcl,s));
           s2:=copy(s,pos(EndExcl,s)+1,length(s));
           TreatOn := True;
           Parse(s2);
           s := s1 + s2;
        end;
end;

Procedure Switches;
 var parm : string[10];
begin
 parm := paramstr(4)+paramstr(5);
 parm := upstr(parm);
 Reverse := pos('/R', Parm) > 0;
 ExclOn  := pos('/X', Parm) > 0;
end;

procedure Trim(var s: string);
 var k : byte;
begin
 OvrS:='';
 if not eoln(fi) then
  begin
   k := length(s);
   while (s[k] <> CutOffCh) and (k>1) do k:=k-1;
   OvrS := copy(s,k+1,length(s)-k+1);
   s:= copy( S, 1, k);
  end;
end;

(*MAIN*)
begin
   if (paramcount<3) or (paramcount>5) then DoError;
   Switches;
   fin:=paramstr(1); fin:=upStr(fin);
   fon:=paramstr(2); fon:=upStr(fon);
   if fin=fon then begin writeln(
        'source and target must be different');
        halt; end;
   assign(fi,fin);
   assign(fo,fon);
   ftbln:=paramstr(3); ftbln:=upStr(ftbln);
   assign(ftbl, ftbln);

  InitTable;

   reset(fi);
   rewrite(fo);
   OutLine := '';
   OvrS := '';

   TreatOn := True;

   repeat
     While Eoln(Fi) and (not eof(Fi)) do
      begin
        ReadLn(Fi);
        writeln(fo);
     End;
     Read(Fi, GtLine);
     ChkLegal( GtLine, Fin);
     OutLine := OvrS+GtLine;
     Trim(OutLine);
      if Length(OutLine) > 1 then
       if ExclOn then
         Parse(Outline)
          else Conv(Outline);
      If eof(Fi) then
         Write(Fo, Outline,OvrS)
       Else
         Write(Fo, Outline);
    until Eof(Fi);
    close(fi);
    write(fo,^z);
    close(fo);
    end.
