 /********************************************************
 *                                                       *
 *               PERFORM_the_RECEIVE_PROCESSING          *
 *                        (PRCV)                         *
 *                                                       *
 * Checks the appropriate receive buffer pool to see if  *
 * any data has arrived for the conversation             *
 * specified in the passed RECEIVE verb parametrs        *
 *                                                       *
 * INPUT : pointer to RECEIVE verb parametrs,            *
 *         pointer to RCB.                               *
 *                                                       *
 * OUTPUT: The data will be removed from input buffer    *
 *         and then will be placed in RECEIVE verb.      *
 *                                                       *
 *                                                       *
 * CopyRight 1995. Nicholas Poljakov all rights reserved.*
 *                                                       *
 ********************************************************/
#include <preptrcv.h>
#include <state1.h>
#include <rcb.h>
#include <stdio.h>
#include <tcb.h>
#include <cma.h>
#include <repass.h>

int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);

preptrcv(pptr)
struct p_rcv *pptr;
{
struct rcb *p_rcb;
struct tcb *ptr_tcb;
struct cma ar;
unsigned int type;
struct repass *p_rep;

int  fsm_conv();
int  fsm_error();
char s;
char r;
char *p;
int state;


     s = 'S';
     r = 'R';

     if (chkparm(pptr, &ar) == -1) {
        return(0);
     }
     p_rcb = ar.p_rcb;
     ptr_tcb = ar.p_tcb;

#if OS_TYPE == 1
     /* Check if it RCB is in wait qeue */
     if (sk_r_wt(p_rcb) == 0) {
        ptr -> prim_rc = INCOMPLETE;
        return (0);
     }
#endif

    /*     RCB  ᨬ  ਬ⨢  */
    p_rcb ->verb_code = Prepare_to_receive;

    if (p_rcb -> conv_state == SEND) {
	p = &((*p_rcb).first_out);
        type = PREP_TO_RCV_FLUSH;
	buffmng('A', NULL, p, p_rcb, 0, 0, type);
	sendhsf(p_rcb);
    }

    p_rep = pptr;
    if (p_rcb -> hsps != YES) {
        p_rep -> complete = 1; /* req. to retry */
	p_rep -> p_rcb = p_rcb;
        return (0);
    }
    p_rep -> complete = 0; /* req. will be complete */
    p_rep -> tp_fd = ptr_tcb -> tp_fd;

     if((state = fsm_conv(s, PREP_TO_RCV_FLUSH, p_rcb)) ==-1)
          {
              pptr -> prim_rc = PORT_ABENDED;
              return;
          }
     if (state == 1)
          {
              pptr -> prim_rc = PORT_ABENDED;
              return;
          }
     return 0;
}
