/* k 8001 19.07.90 */
/* k 0055 17/09/90 */
/* k 1021 17/01/91 */   /* hssesno short->char        */
/* k 0115	02/02/91	*/
/* k 1075	24/01/92	*//* my node ID               */
/*******************************************************
 *           HSCB - HALF-SESSION CONTROL BLOCK         *
 *******************************************************/
/*  k  1002   08.07.90      */
/*  k  1066   07/12/91      */  /* new struct hsnetad,hsmynet   */
struct hscb {
 struct hscb *next;         /* pointer to next hscb             */
 struct nau *naup;          /* pointer to nau                   */
 struct dlctb *dp;          /* pointer to dlc table             */
 char     tsprof;           /* TS profile                       */
 char     fmprof;           /* FM profile                       */
 char     psprof;           /* presentation service profile     */
 char     priprot;          /* FM usage PLU protocols           */
 char     secprot;          /* FM usage SLU protocols           */
 short unsigned comprot;    /* FM usage common protocols        */
 char     sspac;            /* SLU send pacing count    (TS)    */
 char     srpac;            /* SLU receive pacing count (TS)    */
 char     smaxru;           /* SLU maximum send RU size (TS)    */
 char     pmaxru;           /* PLU maximum send RU size (TS)    */
 char     cspac;            /* common send pacing count (TS)    */
 char     prpac;            /* PLU receive pacing count (TS)    */
 char hsprisnd;             /* primary send                     */
 char hstypses;             /* session flag byte:               *
                             * HSHASESS                         */
 char hspacn;               /* session pacing count             */
 char hsfsmpar;             /* half-session state indicators:   *
                             * HSSDTS, FSMIMM, PARPEND          */
  union {                                          /* 1012 */
   struct {                                        /* 1012 */
    short hsnetad;           /* destination address field  1066*/
    short hsmynet;           /* origin address field       1066*/
      } lan;                                /* 1066 */
   struct {                                 /* @1066 */
     char hsdnode;                          /* @1066 */
     char hsdnetad;                         /* @1066 */
     char hsonode;                          /* @1066 */
     char hsomynet;                         /* @1066 */
      } rout;                               /* @1066 */
   } dest;                                  /* 1066 */
 char hslunam[8];           /* lu name                          */
 char hsnodnam[8];          /* lu node name                     */
 unsigned short hssqscnt;   /* sequence send count        @0115 */
 unsigned short hssqrcnt;   /* sequence receive count     @0115 */
 char hsfsssrc;             /* half-session state indicators    *
                             * HSACT - session active;          *
                             * HSPACT - session pending active; *
                             * HSPR -                         ; *
                             * HSPRRB -                       ; *
                             * HSPRRU -                       ; */
 char hsfssst0;             /* half-session state indicators    *
                             * HSPSTSN - pending STSN;          *
                             * HSPRQR  - pending RQR;           *
                             * HSCTLIMM -                       */
 unsigned char hstype;      /* session type:               @0115*
                             * TYPLULU                          */
 char hscbqpac;             /* hscb pacing queue                */
 char hscflg1;              /* hscb flag 1                      */
 char hssesno;              /* sequence number  1002 1021       */
 char hs2scrn;              /* vt screen number                 */
 struct hscb2 *hp2;         /* pointer to hscb extension        */
 struct rqb *ruqueue;	    /* receive queue			*/
 unsigned char mynode;      /* my node ID                @1075  */
  };

#define hsfsmimm   hsfsmpar /* define an alias                  */
#define hsfsmdt    hsfsmpar /* define an alias                  */
#define hsfsmimm   hsfsmpar /* define an alias                  */
#define HSPACGOT   0x01     /* pacing response got indicator    */
#define HSSEC      0x20     /* secondary half-session           */
#define PARPEND    0x04     /* pacing response pending flag     */
#define FSMIMM     0x08     /* fsm_cntl_immed_exp               */
#define HSSDTS     0x80     /* SDT supported flag               */
#define HSHASESS   0x20     /* activate in progress flag        */
#define HSACT      0x09     /* session active indicators        */
#define HSPACT     0x08     /* session pending active indicator */
#define HSPR       0x0A     /*                                  */
#define HSPRRB     0x0B     /*                                  */
#define HSPRRU     0x0C     /*                                  */
#define HSCTLIMM   0x01     /*                                  */
#define HSPSTSN    0x02     /* STSN pending indicator           */
#define HSPRQR     0x04     /* RQR pending indicator            */
#define HSPSPCNT   63       /* primary session pacing count     */
#define HSSEPCNT   63       /* secondary session pacing count   */
#define TYPLULU     3       /* lu-lu session type               */
