/*
 *  CopyRight 1995. Nicholas Poljakov all rights reserved.
 */
/*********************** REM_DIR ****************************/
/*                 input-string pointer                     */
/************************************************************/

#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <state1.h>
#include <direct.h>
#include <dos.h>
#define MAX_PATH 40
#define MIN 1

extern int sw;
extern char lu_id[8];
extern char tp_id[8];
extern char tp_exist;
extern unsigned  long conv_id;
int get_f(void *, int);


      dir(p)
        char *p;
           {

               p += 4;
               if (memcmp(p,"get",3) == 0)
                   return(gd());
               if (memcmp(p,"mkdir",5) == 0)
                   return(md(p+6));
               if (memcmp(p,"path",4) == 0)
                   return(pt());
               if (memcmp(p,"cd",2) == 0)
                   return(rcd(p+3));
            }
/************************************************************************/
/*       gd() - get contents of directory                               */
/************************************************************************/

    gd()
            {

               struct dt {
                           char reserv[21];
                           char attr;
                           unsigned int time;
                           unsigned int date;
                           unsigned long int size;
                           char name[18];
                         }  *s_dta;
               unsigned char rts;
               unsigned char wr;
               unsigned int max_length ;
               struct rc {
                           unsigned int prim;
                           unsigned long sec;
                          } v_rc;
               struct msg {  /*send_data*/
                            int len;
                            char str[sizeof(struct dt)];
                           } gds;
               unsigned long rc;
               int length;

              max_length = 2017;
              recwait (tp_id,
                    conv_id,
                    ll,
                    &v_rc,
                    &length,
                    max_length,
                    &rts,
                    &gds,
                    &wr);
              if (v_rc.prim != 0) {
                    return -1;
              }

               sw = 0;
               if ((s_dta = malloc(sizeof(struct dt))) == NULL) {
                    return -1;
               }
               while ((get_f(s_dta, 0)) != -1)
                    {
                       memcpy(gds.str, s_dta,sizeof(struct dt)) ;
                       gds.len =sizeof(struct dt) + 2;
                       length=gds.len;
                       send_data(tp_id,
                                 conv_id,
                                 &gds,
                                 0,
                                 0,
                                 length,
                                 &v_rc,
                                 &rts);
                       max_length = 255;
                       if (v_rc.prim == 0) {
                           recwait (tp_id,
                                    conv_id,
                                    ll,
                                    &v_rc,
                                    &length,
                                    max_length,
                                    &rts,
                                    &gds,
                                    &wr);
                       }
                       else
                            return -1;
                    }  /* while */

                  deallocate (tp_id,
                              conv_id,
                              Flush,
                              &v_rc);
                  if (v_rc.prim != 0) {
                              return -1;
                           }
                  tp_ended (tp_id, &rc);
                  return 0;
              }
/*************************************************************************/
/*                md(p) - make a directory                               */
/*************************************************************************/
       md(p)
          char *p;
              {
               unsigned char rts;
               unsigned char wr;
               unsigned int max_length ;
               struct rc {
                           unsigned int prim;
                           unsigned long sec;
                          } v_rc;
               struct msg {  /*send_data*/
                            int len;
                            char str[MIN];
                           } gds;
	       unsigned long rc;
	       int length;

                   mkdir(p);
                   max_length = 255;
                   recwait (tp_id,
                            conv_id,
                            ll,
                            &v_rc,
                            &length,
                            max_length,
                            &rts,
                            &gds,
                            &wr);
                  tp_ended (tp_id, &rc);
                  return 0;
          }
/*****************************************************************************/
/*            pt() - get a current path                                      */
/*****************************************************************************/
      pt()
            {
               unsigned char rts;
               unsigned char wr;
               unsigned int max_length ;
               struct rc {
                           unsigned int prim;
                           unsigned long sec;
                          } v_rc;
               struct msg {  /*send_data*/
                            int len;
			    char str[_MAX_PATH];
                           } gds;
               unsigned long rc;
               int length;

               max_length = 2017;
               recwait (tp_id,
                        conv_id,
                        ll,
                        &v_rc,
                        &length,
                        max_length,
                        &rts,
                        &gds,
                        &wr);
               if (v_rc.prim != 0) {
                     return -1;
               }

	       _getdcwd(0, gds.str, _MAX_PATH);

               gds.len = strlen(gds.str) + 2;
               length = gds.len;

               send_data(tp_id,
                         conv_id,
                         &gds,
                         0,
                         0,
                         length,
                         &v_rc,
                         &rts);

               deallocate (tp_id,
                           conv_id,
                           Flush,
                           &v_rc);

               tp_ended (tp_id, &rc);

               return 0;
                 }
/*****************************************************************************/
/*            rcd(p) - make a cd command                                     */
/*****************************************************************************/
     rcd(p)
        char *p;
            {
               unsigned char rts;
               unsigned char wr;
               unsigned int max_length ;
               struct rc {
                           unsigned int prim;
                           unsigned long sec;
                          } v_rc;
               struct msg {  /*send_data*/
                            int len;
                            char str[MIN];
                           } gds;
               unsigned long rc;
               unsigned char strp[MAX_PATH*2];
	       int i;
	       int length;
	       struct SREGS segregs;
	       union REGS regs;

		    regs.h.ah = 0x3b;
		    regs.x.dx = FP_OFF( p );
		    segregs.ds = FP_SEG( p );
		    intdosx( &regs, &regs, &segregs );
		    max_length = 255;
                    recwait (tp_id,
                            conv_id,
                            ll,
                            &v_rc,
                            &length,
                            max_length,
                            &rts,
                            &gds,
                            &wr);
                  deallocate (tp_id,
                              conv_id,
                              Flush,
                              &v_rc);
                  if (v_rc.prim != 0) {
                              return -1;
                  }
                    tp_ended (tp_id, &rc);
                    return 0;
          }
/***************************** THE END *************************************/
