/*
 *                        DEALLOCATE
 *
 * Function: has deal with DEALLOCATE verb. If the defined resource
 *           exist and the conversation has appropriate state,
 *           PS calls an appopriate subroutine for proceeding the processing
 *           of the DEALLOCATE verb.
 *
 * Input: Pointer to "deallocate" structure.
 *
 * CopyRight 1995. Nicholas Poljakov all rights reserved.
 */
#include <stdio.h>
#include <sendat.h>
#include <state1.h>
#include <rcb.h>
#include <tcb.h>
#include <drcb.h>
#include <dall.h>
#include <cma.h>
#include <partner.h>
#include <string.h>
int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);
int bldfmh7(struct rcb *, unsigned long);

dealloc(pptr)
struct deallocate *pptr;
{
extern struct psp psp_ini;
struct rcb *ptr_rcb;
struct tcb *ptr_tcb;
struct drcb d_rcb;
struct cma ar;
struct pnlu *p_partner;

int  fsm_conv();
int  fsm_error();
char s;
char r;
int code;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;       /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "dalloc");
pnum = 1;
drec = pptr;
lenr = sizeof(struct deallocate);
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif

     s = 'S';
     r = 'R';

     if (chkparm(pptr, &ar) == -1) {
        return(0);
     }
     ptr_rcb = ar.p_rcb;
     ptr_tcb = ar.p_tcb;

     /* Check if it RCB is in wait qeue */
     if (sk_r_wt(ptr_rcb) == 0) {
        pptr -> prim_rc = INCOMPLETE;
        return (0);
     }

     d_rcb.p_rcb = ptr_rcb;
     d_rcb.p_tcb = ptr_tcb;

     p_partner = ptr_rcb -> p_partner;
     if (p_partner -> lu_type == 0) {   /* for lu_type == 0 */
        code = RM_DEACTIVATE_SESSION;   /* make clsdst */
        psrm(code, ptr_rcb, 0);
        return (0);                     /* and return */
     }
     code = DEALLOCATE_RCB;

    /*     RCB  ᨬ  ਬ⨢  */
       ptr_rcb ->verb_code = Deallocate;

     switch (pptr -> type)
             {
            case Flush: {
                           dflush(pptr, ptr_tcb, ptr_rcb);
                           psrm(code, &d_rcb, 0);
                           break;
                        }
            case Confirm:
                        {
                           dconfirm(pptr, ptr_tcb, ptr_rcb);
                           break;
                        }
            case Local:
                        {
                           psrm(code, &d_rcb, 0);
                           break;
                        }
            case abend_prog:
            case abend_svc:
            case abend_timer:
                        {
                           dabend(pptr, ptr_tcb, ptr_rcb);
                           psrm(code, &d_rcb, 0);
                           break;
                        }
            default:
                        {
                           pptr -> prim_rc = INCOMPLETE;
			   return 0;
                        }
             }
}
dflush(pptr, p_tcb, p_rcb)
struct deallocate *pptr;
struct tcb *p_tcb;
struct rcb *p_rcb;
{
    int type;
    int state;
    char *p;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;       /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "dflush");
pnum = 1;
drec = pptr;
lenr = sizeof(struct deallocate);
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif


    if ((state = fsm_conv('S',Deallocate_flush,p_rcb)) == -1) {
             pptr -> prim_rc = PORT_ABENDED;
             return;
    }
    if (state == 1) {
             pptr -> prim_rc = STATE_CHECK;
             pptr -> sec_rc = DEALLOC_FLUSH_BAD_STATE;
	     return 0;
    }

    if (p_rcb -> send_ll_remainder != 0) {
        dcp(p_tcb);
    }
    switch (p_rcb -> error_state) {
        case NO_RQS      :
        case RCVD_ERROR  :
                           {
                             p = &((*p_rcb).first_out);
                             type = Deallocate_flush;
                             buffmng('A', NULL, p, p_rcb, 0, 0, type);
                             sendhsf(p_rcb);
                           }
     }
     pptr -> prim_rc = OK;
}

dconfirm(pptr, p_tcb, p_rcb)
struct deallocate *pptr;
struct tcb *p_tcb;
struct rcb *p_rcb;
{
    int type;
    int state;
    char s;
    char *p;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;       /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "dconf");
pnum = 1;
drec = pptr;
lenr = sizeof(struct deallocate);
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif

    if (p_rcb -> send_ll_remainder != 0) {
        dcp(p_tcb);
    }
    s = 'S';
    if ((state = fsm_conv(s,Deallocate_confirm,p_rcb)) == -1) {
             pptr -> prim_rc = PORT_ABENDED;
	     return 0;
    }
    if (state == 1) {
             pptr -> prim_rc = STATE_CHECK;
             pptr -> sec_rc = DEALLOC_FLUSH_BAD_STATE;
	     return 0;
    }
    switch (p_rcb -> error_state) {
        case CONV_FAILURE_PROTOCOL_ERROR :
               {
                 pptr -> prim_rc = CONV_FAILURE_NO_RETRY;
                 s = 'R';
                 fsm_conv(s, RESOURCE_FAILURE_RC, p_rcb);
                 break;
               }
        case CONV_FAILURE_SON:
               {
                 pptr -> prim_rc = CONV_FAILURE_RETRY;
                 s = 'R';
                 fsm_conv(s, RESOURCE_FAILURE_RC, p_rcb);
                 break;
               }
        case ALLOCATE_FAILURE_RETRY :
        case ALLOCATE_FAILURE_NO_RETRY :
        case SYNC_LEVEL_NOT_SUPPORTED_BY_LU :
               {
                 pptr -> prim_rc = ALLOCATION_ERROR;
                 pptr -> sec_rc = DEALLOC_CONFIRM_BAD_STATE;
                 s = 'R';
                 fsm_conv(s, RESOURCE_FAILURE_RC, p_rcb);
                 break;
               }
        case RCVD_ERROR:
               {
                 pptr -> prim_rc = CONV_FAILURE_RETRY;
                 s = 'R';
                 fsm_conv(s, RESOURCE_FAILURE_RC, p_rcb);
                 break;
               }
        case NO_RQS:
               {
                 p = &((*p_rcb).first_out);
                 type = Deallocate_confirm;
                 buffmng('A', NULL, p, p_rcb, 0, 0, type);
                 /* No flush
                 sendhs(p_rcb);
                  */
                 break;
               }
     }
}
dabend(pptr, p_tcb, p_rcb)
struct deallocate *pptr;
struct tcb *p_tcb;
struct rcb *p_rcb;
{
    unsigned long sense;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;       /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "dabend");
pnum = 1;
drec = pptr;
lenr = sizeof(struct deallocate);
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif

    pptr -> prim_rc = OK;
    if ((p_rcb -> error_state == NO_RQS)||
   (p_rcb -> error_state == RCVD_ERROR))  {
       if (pptr -> type == 2) { /* ABEND_PROG */
            sense = 0x08640000;
       }
       if (pptr -> type == 3) { /* ABEND_SVC */
            sense = 0x08640001;
       }
       if (pptr -> type == 4) { /* ABEND_TIMER */
            sense = 0x08640002;
       }
       else
            {
                sense = 0x08640000;
            }
       bldfmh7(p_rcb, sense); /* Build and send the FMH-7 */
    }
}
