
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1995
//------------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <conio.h>

unsigned short ra;
unsigned short rb;
unsigned char irq=0;
unsigned char dma=0;
unsigned char dma16=0;
unsigned short iobase;

//------------------------------------------------------------------------------
void dspwrite ( unsigned char c )
{
    while(inp(iobase+0xC)&0x80);
    outp(iobase+0xC,c);
}
//------------------------------------------------------------------------------
unsigned char dspread ( void )
{
    while(!(inp(iobase+0xE)&0x80)) continue;
    return(inp(iobase+0xA));
}
//------------------------------------------------------------------------------
void main ( int argc, char *argv[] )
{
    if(argc==1) goto nocommand;
    for(ra=1;ra<argc;ra++)
    {
        if( (argv[ra][0]!='/')&&(argv[ra][0]!='-') )
        {
            printf("Invalid switch [%s]\n",argv[ra]);
        }
        else
        {
            switch(argv[ra][1])
            {
                case 'i':
                case 'I':
                    irq=atoi(&argv[ra][2]);
                    break;
                case 'd':
                case 'D':
                    dma=atoi(&argv[ra][2]);
                    break;
                case 'h':
                case 'H':
                    dma16=atoi(&argv[ra][2]);
                    break;
                case '?':
                    nocommand:
                    printf("\nSB16 [option] [option] ...\n");
                    printf("\noptions:\n");
                    printf("  /?    This help screen\n");
                    printf("  /i#   IRQ number (2,5,7,10)\n");
                    printf("  /d#   8-Bit DMA Channel (0,1,3)\n");
                    printf("  /h#   16-Bit DMA Channel (5,6,7)\n");
                    exit(0);
            }
        }
    }
    for(iobase=0x220;iobase<=0x280;iobase+=0x20)
    {
        if(inp(iobase)==0xFF) continue;
        outp(iobase+0x6,0x01);
        for(ra=0;ra<65000;ra++) continue;
        outp(iobase+0x6,0x00);
        for(ra=0;ra<65000;ra++) if(dspread()==0xAA) break;
        if(ra<65000) break;
    }
    if(iobase>0x280)
    {
        printf("Sound Blaster 16 not detected\n");
        exit(1);
    }
    dspwrite(0xE1);
    ra=dspread();
    rb=dspread();
    printf("Sound Blaster Detected, DSP Version %u.%02u\n",ra,rb);
    if(ra!=4)
    {
        printf("Only Sound Blaster DSP Versions 4.xx (SB16) supported.\n");
        exit(1);
    }
    outp(iobase+0x4,0x80);
    switch(irq)
    {
        default:
            printf("Warning:  IRQ not selected\n");
            outp(iobase+0x5,0x00);
            break;
        case 2:
            printf("IRQ 2/9 selected\n");
            outp(iobase+0x5,0x01);
            break;
        case 5:
            printf("IRQ 5 selected\n");
            outp(iobase+0x5,0x02);
            break;
        case 7:
            printf("IRQ 7 selected\n");
            outp(iobase+0x5,0x04);
            break;
        case 10:
            printf("IRQ 10 selected\n");
            outp(iobase+0x5,0x08);
            break;
    }
    outp(iobase+0x4,0x81);
    ra=0;
    switch(dma)
    {
        default:
            printf("Warning:  8-Bit DMA channel not selected\n");
            break;
        case 0:
            printf("8-Bit DMA channel 0 selected\n");
            ra|=0x01;
            break;
        case 1:
            printf("8-Bit DMA channel 1 selected\n");
            ra|=0x02;
            break;
        case 3:
            printf("8-Bit DMA channel 3 selected\n");
            ra|=0x08;
            break;
    }
    switch(dma16)
    {
        case 5:
            printf("16-Bit DMA channel 5 selected\n");
            ra|=0x20;
            break;
        case 6:
            printf("16-Bit DMA channel 6 selected\n");
            ra|=0x40;
            break;
        case 7:
            printf("16-Bit DMA channel 7 selected\n");
            ra|=0x80;
            break;
    }
    outp(iobase+0x5,ra);
    //Set default audio levels
    for(ra=0x30;ra<=0x35;ra++) outp(iobase+0x4,ra); outp(iobase+0x5,0xC0);
    for(ra=0x36;ra<=0x3A;ra++) outp(iobase+0x4,ra); outp(iobase+0x5,0x00);
    outp(iobase+0x4,0x3B); outp(iobase+0x5,0x00);
    outp(iobase+0x4,0x3C); outp(iobase+0x5,0x1F);
    outp(iobase+0x4,0x3D); outp(iobase+0x5,0x15);
    outp(iobase+0x4,0x3E); outp(iobase+0x5,0x0B);
    for(ra=0x3F;ra<=0x42;ra++) outp(iobase+0x4,ra); outp(iobase+0x5,0x00);
    outp(iobase+0x4,0x43); outp(iobase+0x5,0x00);
    for(ra=0x44;ra<=0x47;ra++) outp(iobase+0x4,ra); outp(iobase+0x5,0x80);
}
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1995
//------------------------------------------------------------------------------

